#!/bin/bash
# Use command line option in case "Desktop" is translated into another language.
# Example:
# ./desktoplink.sh Schreibtisch

DESKTOP=$HOME/Desktop
if [ -e $HOME/.config/user-dirs.dirs ]; then
  source $HOME/.config/user-dirs.dirs
  echo $XDG_DESKTOP_DIR
  DESKTOP=$XDG_DESKTOP_DIR
fi

TEMPFILE="Rocview.desktop"
echo "[Desktop Entry]" > $TEMPFILE
echo "Version=1.0" >> $TEMPFILE
echo "Name=Rocview" >> $TEMPFILE
echo "Comment=Rocrail - Innovative Model Railroad Control System" >> $TEMPFILE
echo "Path=$(pwd)" >> $TEMPFILE
if [[ "$XDG_SESSION_TYPE" == "wayland" ]]; then
  echo "Exec=env GDK_BACKEND=x11 $(pwd)/bin/rocview -sp $(pwd)/bin -dp $(pwd)/demo %U" >> $TEMPFILE
else
  echo "Exec=$(pwd)/bin/rocview -sp $(pwd)/bin -dp $(pwd)/demo %U" >> $TEMPFILE
fi
echo "Icon=$(pwd)/rocrail.png" >> $TEMPFILE
echo "Terminal=false" >> $TEMPFILE
echo "Type=Application" >> $TEMPFILE
echo "Categories=Application;" >> $TEMPFILE

chmod +x $TEMPFILE
if [ $1 ]; then
  cp -p $TEMPFILE ~/$1
  cp -p $TEMPFILE ~/.local/share/applications
  sudo cp -p $TEMPFILE /usr/share/applications
else
  cp -p $TEMPFILE $DESKTOP
  cp -p $TEMPFILE ~/.local/share/applications
fi
rm $TEMPFILE
