; Compiled with: PIC Simulator IDE v7.42
; Microcontroller model: PIC12F675
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
;       The address of 'max_volt' (word) (global) is 0x032
;       The address of 'value' (word) (global) is 0x034
;       The address of 'value_2' (word) (global) is 0x036
;       The address of 'sw' (byte) (global) is 0x027
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0003
	ORG 0x0004
	RETFIE
; User code start
L0003:
; 1: 'program for ORD-VC-1 IC5
; 2: 'this program measures voltsage in ananlog inputs 0 and 1
; 3: 'If one of them exceeds the setting in eeprom it will sett gp2 high.
; 4: 'this will shutt off booster via IC1
; 5: Define CONF_WORD = 0x31c4
; 6: 
; 7: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON
; 8: ANSEL.ANS0 = 1
	BSF STATUS,RP0
	BSF ANSEL,0
; 9: ANSEL.ANS1 = 1
	BSF ANSEL,1
	BCF STATUS,RP0
; 10: 
; 11: ADCON0.ADON = 1
	BSF ADCON0,0
; 12: ADCON0.VCFG = 0
	BCF ADCON0,6
; 13: 
; 14: TRISIO = %111011
	MOVLW 0x3B
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 15: 
; 16: Dim max_volt As Word
; 17: Dim value As Word
; 18: Dim value_2 As Word
; 19: Dim sw As Byte
; 20: 
; 21: main:
L0001:
; 22: Gosub check_sw1
	CALL L0002
; 23: Adcin 0, value  'measure currect
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	BCF STATUS,RP0
	CLRF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x034
	MOVF ADRESH,W
	MOVWF 0x035
; 24: Adcin 1, value_2  'measure currect
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	MOVLW 0x01
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x036
	MOVF ADRESH,W
	MOVWF 0x037
; 25: If value < value_2 Then
	MOVF 0x034,W
	MOVWF R0L
	MOVF 0x035,W
	MOVWF R0H
	MOVF 0x036,W
	MOVWF R1L
	MOVF 0x037,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0004
; 26: value = value_2
	MOVF 0x036,W
	MOVWF 0x034
	MOVF 0x037,W
	MOVWF 0x035
; 27: Endif
L0004:
; 28: If value > max_volt Then
	MOVF 0x034,W
	MOVWF R0L
	MOVF 0x035,W
	MOVWF R0H
	MOVF 0x032,W
	MOVWF R1L
	MOVF 0x033,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0005
; 29: GP2 = 1
	BSF GPIO,2
; 30: Else
	GOTO L0006
L0005:
; 31: GP2 = 0
	BCF GPIO,2
; 32: Endif
L0006:
; 33: Goto main
	GOTO L0001
; 34: End
L0007:	GOTO L0007
; 35: 
; 36: check_sw1:
L0002:
; 37: sw = GPIO
	MOVF GPIO,W
	MOVWF 0x027
; 38: sw = sw / 8
	MOVF 0x027,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x027
; 39: Select Case sw
; 40: Case 0
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0008
; 41: max_volt = 20
	MOVLW 0x14
	MOVWF 0x032
	CLRF 0x033
; 42: Case 1
	GOTO L0009
L0008:
	MOVF 0x027,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0010
; 43: max_volt = 38
	MOVLW 0x26
	MOVWF 0x032
	CLRF 0x033
; 44: Case 2
	GOTO L0011
L0010:
	MOVF 0x027,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0012
; 45: max_volt = 64
	MOVLW 0x40
	MOVWF 0x032
	CLRF 0x033
; 46: Case 3
	GOTO L0013
L0012:
	MOVF 0x027,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0014
; 47: max_volt = 102
	MOVLW 0x66
	MOVWF 0x032
	CLRF 0x033
; 48: Case 4
	GOTO L0015
L0014:
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0016
; 49: max_volt = 128
	MOVLW 0x80
	MOVWF 0x032
	CLRF 0x033
; 50: Case 5
	GOTO L0017
L0016:
	MOVF 0x027,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0018
; 51: max_volt = 205
	MOVLW 0xCD
	MOVWF 0x032
	CLRF 0x033
; 52: Case 6
	GOTO L0019
L0018:
	MOVF 0x027,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0020
; 53: max_volt = 256
	CLRF 0x032
	MOVLW 0x01
	MOVWF 0x033
; 54: Case Else
	GOTO L0021
L0020:
; 55: max_volt = 320
	MOVLW 0x40
	MOVWF 0x032
	MOVLW 0x01
	MOVWF 0x033
; 56: EndSelect
L0021:
L0019:
L0017:
L0015:
L0013:
L0011:
L0009:
; 57: Return
	RETURN
; 58: 
; End of user code
L0022:	GOTO L0022
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
;
;
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x05
	MOVWF R4L
	CALL DL01
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
