	list p=12f675
	#include <p12f675.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC12F675
; Clock frequency: 4.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
L0002:
; 1:  'program for MGV105 DDX booster
; 2: Define CONF_WORD = 0x3194
; 3: TRISIO = %001001 'bits 0 , 3 as input
	BSF STATUS,RP0
	MOVLW 0x09
	MOVWF 0x05
; 4: ANSEL = 1
	MOVLW 0x01
	MOVWF 0x1F
; 5: WPU = %000000 'internal pull-up disabled
	CLRF 0x15
; 6:  'assigned pins :
; 7:  'bit 0 = analog input current detection
; 8:  'bit 1 = enable L6203
; 9:  'bit 2 = led 4
; 10:  'bit 3 = input start from serial port
; 11:  'bit4 = short circuit indication loconet
; 12:  'bit5 = power on/off indication to serial port and loc0net
	BCF STATUS,RP0
; 13: Dim current_value As Byte
;       The address of 'current_value' is 0x2D
	current_value EQU 0x2D
; 14: Dim current_count As Byte
;       The address of 'current_count' is 0x2E
	current_count EQU 0x2E
; 15: Dim short_circuit As Bit
;       The address of 'short_circuit' is 0x2C,0
; 16: Dim ddx_in_control As Bit
;       The address of 'ddx_in_control' is 0x2C,1
; 17: Dim led As Byte
;       The address of 'led' is 0x2F
	led EQU 0x2F
; 18: Symbol demand_power_on = GP3
;       The address of 'demand_power_on' is 0x5,3
; 19: short_circuit = 0
	BCF 0x2C,0
; 20: GPIO = %1111101 'everything off
	MOVLW 0x7D
	MOVWF 0x05
; 21: main: 
L0001:
; 22: WaitMs 100 'loop 10 x per second
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
	CALL W001
; 23: Adcin 0, current_value 'measure currect
	BCF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	MOVLW 0x00
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	MOVF ADRESH,W
	MOVWF 0x2D
; 24: If current_value > 75 Then '~~ 0,47Ohm x 3Amp x 255 / 5
	MOVF 0x2D,W
	SUBLW 0x4B
	BTFSC STATUS,C
	GOTO L0003
; 25: If current_count < 11 Then '10 times too high = after 1 second
	MOVLW 0x0B
	SUBWF 0x2E,W
	BTFSC STATUS,C
	GOTO L0004
; 26: current_count = current_count + 1
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 27: Endif
L0004:	MOVLW 0x1F
	ANDWF STATUS,F
; 28: If current_count > 10 Then '10 times too high, then shut off
	MOVF 0x2E,W
	SUBLW 0x0A
	BTFSC STATUS,C
	GOTO L0005
; 29: short_circuit = 1 'indicate power should be off
	BSF 0x2C,0
; 30: Endif
L0005:	MOVLW 0x1F
	ANDWF STATUS,F
; 31: Else
	GOTO L0006
L0003:	MOVLW 0x1F
	ANDWF STATUS,F
; 32: If short_circuit = 0 Then
	BTFSC 0x2C,0
	GOTO L0007
; 33: If current_count > 0 Then
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0008
; 34: current_count = current_count - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 35: Endif
L0008:	MOVLW 0x1F
	ANDWF STATUS,F
; 36: Endif
L0007:	MOVLW 0x1F
	ANDWF STATUS,F
; 37: Endif
L0006:	MOVLW 0x1F
	ANDWF STATUS,F
; 38: 
; 39: If short_circuit = 1 Then '> 0,5sec short too high current > shut off
	BTFSS 0x2C,0
	GOTO L0009
; 40: If led = 0 Then 'create flashing led
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0010
; 41: led = 1
	MOVLW 0x01
	MOVWF 0x2F
; 42: GPIO = %001100
	MOVLW 0x0C
	MOVWF 0x05
; 43: Else
	GOTO L0011
L0010:	MOVLW 0x1F
	ANDWF STATUS,F
; 44: led = 0
	CLRF 0x2F
; 45: GPIO = %001000
	MOVLW 0x08
	MOVWF 0x05
; 46: Endif
L0011:	MOVLW 0x1F
	ANDWF STATUS,F
; 47: Endif
L0009:	MOVLW 0x1F
	ANDWF STATUS,F
; 48: 
; 49: If demand_power_on = 1 Then 'ddx has send power off command
	BTFSS 0x05,3
	GOTO L0012
; 50: ddx_in_control = 1 'ddx is from here able to switch on
	BSF 0x2C,1
; 51: If short_circuit = 1 Then '> 0,5sec short too high current > shut off
	BTFSS 0x2C,0
	GOTO L0013
; 52: If led = 0 Then 'create flashing led
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0014
; 53: led = 1
	MOVLW 0x01
	MOVWF 0x2F
; 54: GPIO = %001100
	MOVLW 0x0C
	MOVWF 0x05
; 55: Else
	GOTO L0015
L0014:	MOVLW 0x1F
	ANDWF STATUS,F
; 56: led = 0
	CLRF 0x2F
; 57: GPIO = %001000
	MOVLW 0x08
	MOVWF 0x05
; 58: Endif
L0015:	MOVLW 0x1F
	ANDWF STATUS,F
; 59: Else
	GOTO L0016
L0013:	MOVLW 0x1F
	ANDWF STATUS,F
; 60: GPIO = %001000
	MOVLW 0x08
	MOVWF 0x05
; 61: Endif
L0016:	MOVLW 0x1F
	ANDWF STATUS,F
; 62: Endif
L0012:	MOVLW 0x1F
	ANDWF STATUS,F
; 63: If demand_power_on = 0 Then 'ddx has send power on command
	BTFSC 0x05,3
	GOTO L0017
; 64: If ddx_in_control = 1 Then 'ddx is allowed to switch on
	BTFSS 0x2C,1
	GOTO L0018
; 65: short_circuit = 0 'assume no problem anymore
	BCF 0x2C,0
; 66: GPIO = %111111 'indicators off, power on
	MOVLW 0x3F
	MOVWF 0x05
; 67: current_count = 0 'short circuit counter reset
	CLRF 0x2E
; 68: ddx_in_control = 0 'no next power on possible
	BCF 0x2C,1
; 69: Endif
L0018:	MOVLW 0x1F
	ANDWF STATUS,F
; 70: Endif
L0017:	MOVLW 0x1F
	ANDWF STATUS,F
; 71: 
; 72: Goto main
	GOTO L0001
; 73: 
; 74: 
; 75: End
L0019:	GOTO L0019
; End of program
L0020:	GOTO L0020
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine - Byte Argument
X001:	MOVLW 0x0A
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x06
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3194
; End of listing
	END
