; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_bridge_switch1' (global) is 113
;       The value of 'mem_bridge_switch2' (global) is 114
;       The value of 'mem_bridge_switch3' (global) is 115
;       The value of 'mem_bridge_switch4' (global) is 116
;       The value of 'mem_bridge_switch5' (global) is 117
;       The value of 'mem_bridge_switch6' (global) is 118
;       The address of 'value' (byte) (global) is 0x30
	value EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x31
	act_pos EQU 0x31
;       The address of 'ctrl_type' (byte) (global) is 0x32
	ctrl_type EQU 0x32
;       The address of 'max_pos' (byte) (global) is 0x33
	max_pos EQU 0x33
;       The address of 'steps' (word) (global) is 0x34
	steps EQU 0x34
;       The address of 'new_steps' (word) (global) is 0x36
	new_steps EQU 0x36
;       The address of 'bridge_switch' (bit) (global) is 0x38,0
;       The address of 'speed_max' (word) (global) is 0x39
	speed_max EQU 0x39
;       The address of 'speed_min' (word) (global) is 0x3B
	speed_min EQU 0x3B
;       The address of 'result' (byte) (global) is 0x3D
	result EQU 0x3D
;       The address of 'manual_pos' (byte) (global) is 0x3E
	manual_pos EQU 0x3E
;       The address of 'one_round' (word) (global) is 0x3F
	one_round EQU 0x3F
;       The address of 'turn_counter' (byte) (global) is 0x41
	turn_counter EQU 0x41
;       The address of 'program_set' (byte) (global) is 0x42
	program_set EQU 0x42
;       The address of 'value2' (byte) (global) is 0x43
	value2 EQU 0x43
;       The address of 'free_space_steps' (byte) (global) is 0x44
	free_space_steps EQU 0x44
;       The address of 'speed_step' (byte) (global) is 0x45
	speed_step EQU 0x45
;       The address of 'act_steps' (word) (global) is 0x46
	act_steps EQU 0x46
;       The address of 'steps_set' (bit) (global) is 0x38,1
;       The address of 'new_pos' (byte) (global) is 0x48
	new_pos EQU 0x48
;       The address of 'bus_pos' (byte) (global) is 0x49
	bus_pos EQU 0x49
;       The address of 'disp1_val' (byte) (global) is 0x4A
	disp1_val EQU 0x4A
;       The address of 'new_encoder' (byte) (global) is 0x4B
	new_encoder EQU 0x4B
;       The address of 'encoder_count' (byte) (global) is 0x4C
	encoder_count EQU 0x4C
;       The address of 'bridge_power' (bit) (global) is 0x38,2
;       The address of 'speed' (word) (global) is 0x4D
	speed EQU 0x4D
;       The address of 'disp2_val' (byte) (global) is 0x4F
	disp2_val EQU 0x4F
;       The address of 'eprom_pointer' (byte) (global) is 0x50
	eprom_pointer EQU 0x50
;       The address of 'old_encoder' (byte) (global) is 0x51
	old_encoder EQU 0x51
;       The address of 'old_manual_pos' (byte) (global) is 0x52
	old_manual_pos EQU 0x52
;       The address of 'ramp_up' (bit) (global) is 0x38,3
;       The address of 'version' (bit) (global) is 0x38,4
;       The address of 'ramp_down_point' (word) (global) is 0x53
	ramp_down_point EQU 0x53
;       The address of 'one_round_half' (word) (global) is 0x55
	one_round_half EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'old_bridge_switch' (bit) (global) is 0x38,5
;       The address of 'old_pos_write' (bit) (global) is 0x38,6
;       The address of 'free_space_word' (word) (global) is 0x58
	free_space_word EQU 0x58
;       The address of 'half_steps' (word) (global) is 0x5A
	half_steps EQU 0x5A
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'fy_stop' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,3
	GOTO L0017
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0017:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: 'V4.4 initial setting freespace dafaults to 0.
; 12: '-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
; 13: '-    manual position setting can be turned through zero
; 14: 'V4.5 extra menu 8 for setting the first position where rail power should be reversed
; 15: 'V4.6 0 point will also control cable twist
; 16: 'V4.7 Fiddle yard (ctrl type 6) has only 5 selection lines.(max 30 positions , 31 = zero adjust)
; 17: '-    pos.req 6 is set as input, MGV50 should be set as block output
; 18: '-    the two connection rails in and out are connected to current detection
; 19: '-    any train on these tracks will give siganl,where FY will stop immediately (same as endswitch)
; 20: 'V4.8 Extra menu added for settings of reverse/not per position (only for 0,2,4 )
; 21: '-    These bits (bridge_switch) are stored and read in 6 bytes
; 22: 'V4.9 Free_space_steps multiplied by 10 , 990 correction steps available
; 23: '-    Positions are changed to 0-47
; 24: '-    Maximum positons can be as low as two
; 25: 'V5.0 Correction for init eprom routine position change to 0-47
; 26: '-    Free_space_steps multiplier changed to 4
; 27: '-    Added position 62 for recalibration, turn in direction 0 until 0 detector reached and set position to 0
; 28: '-    Added menu option 9 to operate the stepper motor without changing the stored steps
; 29: 'V5.1 Correction for bug that when a position is at 0 steps (perfectly aligned zero detector)
; 30: '-    the "determine one round" routine is called when selecting that position
; 31: 'V5.2 Correction for relay control, only switch relays before and after moving, only when needed
; 32: '-    Menu 0 and 1 only available when posistion is a real position, not a special position (62, 63)
; 33: Define CONF_WORD = 0x3f72
; 34: Define CLOCK_FREQUENCY = 20
; 35: 'Define SIMULATION_WAITuS_VALUE = 1
; 36: Dim steps As Word
; 37: Dim half_steps As Word
; 38: Dim ramp_down_point As Word
; 39: Dim program_set As Byte
; 40: Dim new_steps As Word
; 41: Dim act_steps As Word
; 42: Dim new_pos As Byte
; 43: Dim act_pos As Byte
; 44: Dim one_round As Word
; 45: Dim one_round_half As Word
; 46: Dim bus_pos As Byte
; 47: Dim old_bus_pos As Byte
; 48: Dim speed As Word
; 49: Dim speed_min As Word
; 50: Dim speed_max As Word
; 51: Dim new_encoder As Byte
; 52: Dim old_encoder As Byte
; 53: Dim manual_pos As Byte
; 54: Dim old_manual_pos As Byte
; 55: Dim result As Byte
; 56: Dim free_space_steps As Byte
; 57: Dim free_space_word As Word
; 58: Dim value As Byte
; 59: Dim value2 As Byte
; 60: Dim eprom_pointer As Byte
; 61: Dim encoder_count As Byte
; 62: Dim turn_counter As Byte
; 63: Dim old_bridge_switch As Bit
; 64: Dim max_pos As Byte
; 65: Dim disp1_val As Byte
; 66: Dim disp2_val As Byte
; 67: Dim ctrl_type As Byte
; 68: Dim old_pos_write As Bit
; 69: Dim ramp_up As Bit
; 70: Dim speed_step As Byte
; 71: Dim version As Bit
; 72: Dim steps_set As Bit
; 73: Dim bridge_power As Bit
; 74: Dim bridge_switch As Bit
; 75: Const disp1 = 64
; 76: Const disp2 = 66
; 77: Const mem_turn_counter = 101
; 78: Const mem_act_pos = 102
; 79: Const mem_speed_min = 103
; 80: Const mem_speed_max = 104
; 81: Const mem_speed_step = 105
; 82: Const mem_one_round_lb = 106
; 83: Const mem_one_round_hb = 107
; 84: Const mem_ctrl_type = 108
; 85: Const mem_max_pos = 109
; 86: Const mem_free_space = 110
; 87: 
; 88: Const mem_bridge_power = 112
; 89: Const mem_bridge_switch1 = 113
; 90: Const mem_bridge_switch2 = 114
; 91: Const mem_bridge_switch3 = 115
; 92: Const mem_bridge_switch4 = 116
; 93: Const mem_bridge_switch5 = 117
; 94: Const mem_bridge_switch6 = 118
; 95: Symbol swfw = RB0
; 96: Symbol swrev = RB1
; 97: Symbol sck = RB2
; 98: Symbol sda = RB3
; 99: Symbol pos_match = RB4
; 100: Symbol pos_write = RB5
; 101: Symbol eep = RB6
; 102: Symbol max_end = RB7
; 103: Symbol direction = RC0
; 104: Symbol clk = RC1
; 105: Symbol ena = RC2
; 106: Symbol zero = RC3
; 107: Symbol ec1 = RC4
; 108: Symbol ec2 = RC5
; 109: Symbol ecsw = RC6
; 110: Symbol pgm = RC7
; 111: Symbol fy_stop = RA5
; 112: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 113: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 114: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 115: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 116: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 117: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 118: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 119: value = 53  'version number
	MOVLW 0x35
	MOVWF 0x30
; 120: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 121: value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 122: version = 1
	BSF 0x38,4
; 123: Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 124: Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 125: old_bridge_switch = Not bridge_switch  'make sure that bridge power will be turned on
	BTFSS 0x38,0
	BSF 0x38,5
	BTFSC 0x38,0
	BCF 0x38,5
; 126: Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 127: program_set = 1
	MOVLW 0x01
	MOVWF 0x42
; 128: main:
L0001:
; 129: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0018
; 130: 		Gosub adjust_settings
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0004
; 131: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 132: 	Endif
L0018:
; 133: 
; 134: 	Gosub get_new_position
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0002
; 135: 	If bus_pos <> old_bus_pos Then
	MOVF 0x49,W
	SUBWF 0x57,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0019
; 136: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 137: 		If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x38,2
	GOTO L0020
; 138: 			swfw = 0
	BCF 0x06,0
; 139: 			swrev = 0
	BCF 0x06,1
; 140: 		Endif
L0020:
; 141: 		new_pos = bus_pos
	MOVF 0x49,W
	MOVWF 0x48
; 142: 		Gosub stepmotor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0007
; 143: 		value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 144: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 145: 		Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 146: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 147: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0021
L0019:
; 148: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0022
; 149: 			If manual_pos <> old_manual_pos Then
	MOVF 0x3E,W
	SUBWF 0x52,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0023
; 150: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 151: 				If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x38,2
	GOTO L0024
; 152: 					swfw = 0
	BCF 0x06,0
; 153: 					swrev = 0
	BCF 0x06,1
; 154: 				Endif
L0024:
; 155: 				old_manual_pos = manual_pos
	MOVF 0x3E,W
	MOVWF 0x52
; 156: 				new_pos = manual_pos
	MOVF 0x3E,W
	MOVWF 0x48
; 157: 				Gosub stepmotor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0007
; 158: 				value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 159: 				Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 160: 				Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 161: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 162: 			Endif
L0023:
; 163: 		Endif
L0022:
; 164: 	Endif
L0021:
; 165: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 166: 	Goto main
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0001
; 167: End
;       PAGE SELECT
;	BCF PCLATH,3
L0025:	GOTO L0025
; 168: 
; 169: get_new_position:
L0002:
; 170: 	value = bus_pos  'remember the position
	MOVF 0x49,W
	MOVWF 0x30
; 171: 	If pos_write = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0026
; 172: 		If old_pos_write = 0 Then  'react only once on rising edge
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x38,6
	GOTO L0027
; 173: 			old_pos_write = 1
	BSF 0x38,6
; 174: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x30
; 175: 			If ctrl_type = 6 Then  'fiddle yard max = 30
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 176: 				value = value And 31
	MOVF 0x30,W
	MOVWF R0L
	MOVLW 0x1F
	ANDWF R0L,W
	MOVWF 0x30
; 177: 				If value = 31 Then  '31 is for zero adjust, maybe only 5 bits are available
	MOVF 0x30,W
	SUBLW 0x1F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 178: 					value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 179: 				Endif
L0029:
; 180: 			Endif
L0028:
; 181: 			Select Case value
; 182: 			Case 63  'make zero adjust
	MOVF 0x30,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0030
; 183: 				value = 0
	CLRF 0x30
; 184: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0031
L0030:
; 185: 				If value > max_pos Then  'this is not allowed
	MOVF 0x30,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 186: 					value = bus_pos  'put it back to old situation
	MOVF 0x49,W
	MOVWF 0x30
; 187: 				Endif
L0032:
; 188: 			EndSelect
L0031:
; 189: 						Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 190: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x30,W
	SUBWF 0x49,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 191: 				pos_match = 1
	BSF 0x06,4
; 192: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 193: 				pos_match = 0
	BCF 0x06,4
; 194: 			Endif
L0033:
; 195: 		Endif
L0027:
; 196: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0034
L0026:
; 197: 		old_pos_write = 0
	BCF 0x38,6
; 198: 	Endif
L0034:
; 199: 	bus_pos = value  'now take over the desired position
	MOVF 0x30,W
	MOVWF 0x49
; 200: 	Gosub calc_rotation
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 201: 	Select Case result
; 202: 	Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 203: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4C,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0036
; 204: 			encoder_count = encoder_count + 1
	MOVF 0x4C,W
	ADDLW 0x01
	MOVWF 0x4C
; 205: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0037
L0036:
; 206: 			encoder_count = 0
	CLRF 0x4C
; 207: 			Select Case manual_pos
; 208: 			Case 63
	MOVF 0x3E,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 209: 				manual_pos = 0
	CLRF 0x3E
; 210: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0039
L0038:
	MOVF 0x3E,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 211: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x3E
; 212: 			Case max_pos
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0041
L0040:
	MOVF 0x3E,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 213: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x3E
; 214: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0043
L0042:
; 215: 				manual_pos = manual_pos + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
; 216: 			EndSelect
L0043:
L0041:
L0039:
; 217: 			value = manual_pos
	MOVF 0x3E,W
	MOVWF 0x30
; 218: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 219: 		Endif
L0037:
; 220: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0044
L0035:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0045
; 221: 		If encoder_count > 0 Then
	MOVF 0x4C,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0046
; 222: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4C,W
	MOVWF 0x4C
; 223: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0047
L0046:
; 224: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4C
; 225: 			Select Case manual_pos
; 226: 			Case 63
	MOVF 0x3E,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0048
; 227: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x3E
; 228: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0049
L0048:
	MOVF 0x3E,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 229: 				manual_pos = max_pos
	MOVF 0x33,W
	MOVWF 0x3E
; 230: 			Case 0
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x3E,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 231: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x3E
; 232: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0053
L0052:
; 233: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 234: 			EndSelect
L0053:
L0051:
L0049:
; 235: 			value = manual_pos
	MOVF 0x3E,W
	MOVWF 0x30
; 236: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 237: 		Endif
L0047:
; 238: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0045:
; 239: 	EndSelect
L0054:
L0044:
; 240: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 241: 	
; 242: Return
	RETURN
; 243: 
; 244: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 245: '1 = increasing value
; 246: '2 = decreasing value
; 247: '3 = no change
; 248: 		new_encoder = 0
	CLRF 0x4B
; 249: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4B,0
	BTFSS 0x07,4
	BCF 0x4B,0
; 250: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4B,1
	BTFSS 0x07,5
	BCF 0x4B,1
; 251: 		Select Case old_encoder
; 252: 		Case 0
	MOVF 0x51,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0055
; 253: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0056
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3D
L0056:
; 254: 		Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0057
L0055:
	MOVF 0x51,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 255: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0059
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3D
L0059:
; 256: 		Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0060
L0058:
	MOVF 0x51,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 257: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3D
L0062:
; 258: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0063
L0061:
; 259: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0064
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3D
L0064:
; 260: 		EndSelect
L0063:
L0060:
L0057:
; 261: 		old_encoder = new_encoder
	MOVF 0x4B,W
	MOVWF 0x51
; 262: Return
	RETURN
; 263: 
; 264: adjust_settings:
L0004:
; 265: 	If program_set = 0 Or program_set = 1 Then  'menu 0 and 1 not available when position has a special value (62, 63)
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0066
L0067:
	MOVF 0x42,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
L0066:
; 266: 		If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
	MOVF 0x3E,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
	MOVF 0x49,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
; 267: 			program_set = program_set
; 268: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0069
L0068:
; 269: 			program_set = 2
	MOVLW 0x02
	MOVWF 0x42
; 270: 		Endif
L0069:
; 271: 	Endif
L0065:
; 272: 	If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x38,2
	GOTO L0070
; 273: 		swfw = 0
	BCF 0x06,0
; 274: 		swrev = 0
	BCF 0x06,1
; 275: 	Endif
L0070:
; 276: 	Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 277: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 278: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 279: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x46,W
	MOVWF 0x36
	MOVF 0x47,W
	MOVWF 0x37
; 280: 	While pgm = 0  'the program switch is still activated
L0071:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0072
; 281: 		If ecsw = 0 Then  'knob is pressed, increase program_set
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0073
; 282: 			program_set = program_set + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 283: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x42,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0074
; 284: 				If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then  'menu 0 and 1 only available when position is not a special position
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0075
	MOVF 0x3E,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0075
	MOVF 0x49,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0075
; 285: 					program_set = 0
	CLRF 0x42
; 286: 				Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0076
L0075:
; 287: 					program_set = 2
	MOVLW 0x02
	MOVWF 0x42
; 288: 				Endif
L0076:
; 289: 			Endif
L0074:
; 290: 			Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 291: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 292: 			While ecsw = 0  'be sure pushbutton is released
L0077:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0078
; 293: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 294: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0077
L0078:
; 295: 		Endif
L0073:
; 296: 		Select Case program_set
; 297: 		Case 0  'correction of current position
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 298: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 299: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 300: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 301: 			Select Case result
; 302: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 303: 				If new_steps < 60000 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 304: 					ena = 1  'motor on
	BSF 0x07,2
; 305: 					new_steps = new_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x37
; 306: 					direction = 1
	BSF 0x07,0
; 307: 					clk = 1  'clock out
	BSF 0x07,1
; 308: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 309: 					clk = 0
	BCF 0x07,1
; 310: 				Endif
L0081:
; 311: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0082
L0080:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0083
; 312: 				If new_steps > 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0084
; 313: 					ena = 1  'motor on
	BSF 0x07,2
; 314: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 315: 					direction = 0
	BCF 0x07,0
; 316: 					clk = 1  'clock out
	BSF 0x07,1
; 317: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 318: 					clk = 0
	BCF 0x07,1
; 319: 				Endif
L0084:
; 320: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0085
L0083:
; 321: 			EndSelect
L0085:
L0082:
; 322: 			Select Case act_pos
; 323: 			Case 1
	MOVF 0x31,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 324: 				steps_set = 1
	BSF 0x38,1
; 325: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0087
L0086:
	MOVF 0x31,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 326: 				If steps_set = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x38,1
	GOTO L0089
; 327: 					If eep = 1 Then  'iF jumper eep1 is set to on
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0090
; 328: 											'routine to set steps for pos 3 to max_pos
; 329: 						value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 330: 						Gosub i2c_display  'show 63 to indicate adjusting is proceeded
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 331: 						If act_steps <> new_steps Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0091
; 332: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 333: 						Endif
L0091:
; 334: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 335: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x48
; 336: 						Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 337: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x34
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x35
; 338: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x31
L0092:
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0093
; 339: 							new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x34,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x35,W
	MOVWF 0x37
; 340: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 341: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0092
L0093:
; 342: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 343: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x31
; 344: 						steps_set = 0  'do this routine only once
	BCF 0x38,1
; 345: 					Endif
L0090:
; 346: 				Endif
L0089:
; 347: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0094
L0088:
; 348: 				steps_set = 0
	BCF 0x38,1
; 349: 			EndSelect  'act_pos
L0094:
L0087:
; 350: 		Case 1  'setting of inverse / not inverse bridge rail power
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0095
L0079:
	MOVF 0x42,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0096
; 351: 			Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 352: 			value = 0
	CLRF 0x30
; 353: 			value.0 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,0
	BTFSS 0x38,0
	BCF 0x30,0
; 354: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 355: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 356: 			Select Case result
; 357: 			Case 1, 2
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0098
L0099:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
L0098:
; 358: 				bridge_switch = Not bridge_switch
	MOVLW 0x01
	XORWF 0x38,F
; 359: 				Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 360: 				swfw = bridge_switch
	BTFSC 0x38,0
	BSF 0x06,0
	BTFSS 0x38,0
	BCF 0x06,0
; 361: 				swrev = Not bridge_switch
	BTFSS 0x38,0
	BSF 0x06,1
	BTFSC 0x38,0
	BCF 0x06,1
; 362: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0100
L0097:
; 363: 			EndSelect
L0100:
; 364: 		Case 2  'setting of maximum positions
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0101
L0096:
	MOVF 0x42,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0102
; 365: 			steps_set = 0
	BCF 0x38,1
; 366: 			ena = 0  'shut off motor
	BCF 0x07,2
; 367: 			value = max_pos
	MOVF 0x33,W
	MOVWF 0x30
; 368: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 369: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 370: 			Select Case result
; 371: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 372: 				max_pos = max_pos + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 373: 				Select Case ctrl_type
; 374: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0104
; 375: 					If max_pos > 30 Then  'no more positions possible
	MOVF 0x33,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0105
; 376: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x33
; 377: 					Endif
L0105:
; 378: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0106:	BTFSC EECON1,WR
	GOTO L0106
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 379: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0107
L0104:
; 380: 					If max_pos > 47 Then  'no more positions possible
	MOVF 0x33,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0108
; 381: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x33
; 382: 					Endif
L0108:
; 383: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0109:	BTFSC EECON1,WR
	GOTO L0109
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 384: 				EndSelect
L0107:
; 385: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0110
L0103:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0111
; 386: 				max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 387: 				If max_pos < 1 Then  'mininum 2 positions
	MOVLW 0x01
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0112
; 388: 					Select Case ctrl_type
; 389: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0113
; 390: 						max_pos = 30
	MOVLW 0x1E
	MOVWF 0x33
; 391: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0114
L0113:
; 392: 						max_pos = 47
	MOVLW 0x2F
	MOVWF 0x33
; 393: 					EndSelect
L0114:
; 394: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0115:	BTFSC EECON1,WR
	GOTO L0115
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 395: 				Endif
L0112:
; 396: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0116
L0111:
; 397: 			EndSelect
L0116:
L0110:
; 398: 		Case 3  'setting control type
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0117
L0102:
	MOVF 0x42,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0118
; 399: 			steps_set = 0
	BCF 0x38,1
; 400: 			ena = 0  'shut off motor
	BCF 0x07,2
; 401: 			If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0119
; 402: 				ctrl_type = 0
	CLRF 0x32
; 403: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0120:	BTFSC EECON1,WR
	GOTO L0120
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 404: 			Endif
L0119:
; 405: 			value = ctrl_type
	MOVF 0x32,W
	MOVWF 0x30
; 406: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 407: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 408: 			Select Case result
; 409: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 410: 				ctrl_type = ctrl_type + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 411: 				If ctrl_type = 7 Then
	MOVF 0x32,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0122
; 412: 					ctrl_type = 0
	CLRF 0x32
; 413: 				Endif
L0122:
; 414: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 415: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0124
L0121:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 416: 				ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 417: 				If ctrl_type = 255 Then
	MOVF 0x32,W
	SUBLW 0xFF
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 418: 					ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 419: 				Endif
L0126:
; 420: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 421: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0128
L0125:
; 422: 			EndSelect
L0128:
L0124:
; 423: 		Case 4  'setting of speed interval Minimum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0129
L0118:
	MOVF 0x42,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 424: 					'setting will be done in multiple of 256 uSecs
; 425: 					'minimum is 2 and maximum is 99 (is real slow)
; 426: 			steps_set = 0
	BCF 0x38,1
; 427: 			ena = 0  'shut off motor
	BCF 0x07,2
; 428: 			value = speed_min.HB
	MOVF 0x3C,W
	MOVWF 0x30
; 429: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 430: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 431: 			Select Case result
; 432: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0131
; 433: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3C,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0132
; 434: 					speed_min = speed_min + 256
	MOVF 0x3B,W
	ADDLW 0x00
	MOVWF 0x3B
	MOVF 0x3C,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3C
; 435: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 436: 				Endif
L0132:
; 437: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0134
L0131:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 438: 				If speed_min > speed_max Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	MOVF 0x3A,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0136
; 439: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3B,W
	MOVWF 0x3B
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 440: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 441: 				Endif
L0136:
; 442: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0138
L0135:
; 443: 			EndSelect
L0138:
L0134:
; 444: 		Case 5  'setting of speed interval Maximum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0139
L0130:
	MOVF 0x42,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 445: 					'setting will be done in multiple of 256 uSecs
; 446: 					'minimum is 1 and maximum is 99 (is real slow)
; 447: 			steps_set = 0
	BCF 0x38,1
; 448: 			ena = 0  'shut off motor
	BCF 0x07,2
; 449: 			value = speed_max.HB
	MOVF 0x3A,W
	MOVWF 0x30
; 450: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 451: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 452: 			Select Case result
; 453: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0141
; 454: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3C,W
	SUBWF 0x3A,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0142
; 455: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 456: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0143:	BTFSC EECON1,WR
	GOTO L0143
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 457: 				Endif
L0142:
; 458: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0144
L0141:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 459: 				If speed_max.HB > 1 Then
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 460: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 461: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 462: 				Endif
L0146:
; 463: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0148
L0145:
; 464: 			EndSelect
L0148:
L0144:
; 465: 		Case 6  'setting of ramp up and down speed
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0149
L0140:
	MOVF 0x42,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
; 466: 					'speed will be the value that speed will be changed every step up and down
; 467: 			steps_set = 0
	BCF 0x38,1
; 468: 			ena = 0  'shut off motor
	BCF 0x07,2
; 469: 			value = speed_step
	MOVF 0x45,W
	MOVWF 0x30
; 470: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 471: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 472: 			Select Case result
; 473: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
; 474: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x45,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0152
; 475: 					speed_step = speed_step + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 476: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0153:	BTFSC EECON1,WR
	GOTO L0153
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 477: 				Endif
L0152:
; 478: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0154
L0151:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0155
; 479: 				If speed_step > 1 Then
	MOVF 0x45,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0156
; 480: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 481: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0157:	BTFSC EECON1,WR
	GOTO L0157
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 482: 				Endif
L0156:
; 483: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0158
L0155:
; 484: 			EndSelect
L0158:
L0154:
; 485: 	
; 486: 		Case 7  'setting of extra free space steps
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0159
L0150:
	MOVF 0x42,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 487: 			steps_set = 0
	BCF 0x38,1
; 488: 			ena = 0  'shut off motor
	BCF 0x07,2
; 489: 			If free_space_steps > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0161
; 490: 				free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x44
; 491: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0162:	BTFSC EECON1,WR
	GOTO L0162
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 492: 			Endif
L0161:
; 493: 			value = free_space_steps
	MOVF 0x44,W
	MOVWF 0x30
; 494: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 495: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 496: 			Select Case result
; 497: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0163
; 498: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0164
; 499: 					free_space_steps = free_space_steps + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 500: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0165:	BTFSC EECON1,WR
	GOTO L0165
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 501: 				Endif
L0164:
; 502: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0166
L0163:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
; 503: 				If free_space_steps > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0168
; 504: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 505: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 506: 				Endif
L0168:
; 507: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0170
L0167:
; 508: 			EndSelect
L0170:
L0166:
; 509: 		Case 8  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0171
L0160:
	MOVF 0x42,W
	SUBLW 0x08
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0172
; 510: 			Read mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 511: 			If value > 1 Then
	MOVF 0x30,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0173
; 512: 				value = 1
	MOVLW 0x01
	MOVWF 0x30
; 513: 			Endif
L0173:
; 514: 			bridge_power = value.0
	BTFSC 0x30,0
	BSF 0x38,2
	BTFSS 0x30,0
	BCF 0x38,2
; 515: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 516: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 517: 			Select Case result
; 518: 			Case 1, 2
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0176
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0175
L0176:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0174
L0175:
; 519: 				bridge_power = Not bridge_power
	MOVLW 0x04
	XORWF 0x38,F
; 520: 				value.0 = bridge_power
	BTFSC 0x38,2
	BSF 0x30,0
	BTFSS 0x38,2
	BCF 0x30,0
; 521: 				Write mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 522: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0178
L0174:
; 523: 			EndSelect
L0178:
; 524: 		Case 9  'move but do not change stored steps
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0179
L0172:
	MOVF 0x42,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0180
; 525: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 526: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 527: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 528: 			Select Case result
; 529: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0181
; 530: 					ena = 1  'motor on
	BSF 0x07,2
; 531: 					direction = 0
	BCF 0x07,0
; 532: 					clk = 1  'clock out
	BSF 0x07,1
; 533: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 534: 					clk = 0
	BCF 0x07,1
; 535: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0182
L0181:
	MOVF 0x3D,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0183
; 536: 					ena = 1  'motor on
	BSF 0x07,2
; 537: 					direction = 1
	BSF 0x07,0
; 538: 					clk = 1  'clock out
	BSF 0x07,1
; 539: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 540: 					clk = 0
	BCF 0x07,1
; 541: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0184
L0183:
; 542: 			EndSelect
L0184:
L0182:
; 543: 		EndSelect
L0180:
L0179:
L0171:
L0159:
L0149:
L0139:
L0129:
L0117:
L0101:
L0095:
; 544: 	Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0071
L0072:
; 545: 	ena = 0  'shut off motor
	BCF 0x07,2
; 546: 		'***************   now check if changes have to BE written in eeprom
; 547: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0185
; 548: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 549: 	Endif
L0185:
; 550: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 551: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 552: 	Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 553: Return
	RETURN
; 554: 
; 555: i2c_display:
L0005:
; 556: 	disp1_val = value
	MOVF 0x30,W
	MOVWF 0x4A
; 557: 	disp1_val = disp1_val Mod 10
	MOVF 0x4A,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4A
; 558: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0186
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4A
L0186:
; 559: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4A,7
	BTFSS 0x07,7
	BCF 0x4A,7
; 560: 	disp2_val = value
	MOVF 0x30,W
	MOVWF 0x4F
; 561: 	disp2_val = disp2_val / 10
	MOVF 0x4F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4F
; 562: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4F,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0187
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x4F
L0187:
; 563: 	disp2_val.7 = version
	BTFSC 0x38,4
	BSF 0x4F,7
	BTFSS 0x38,4
	BCF 0x4F,7
; 564: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 565: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 566: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4A,W
	CALL IC01
; 567: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 568: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 569: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 570: 	I2CSend disp2_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4F,W
	CALL IC01
; 571: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 572: Return
	RETURN
; 573: 
; 574: i2c_display_pgm:
L0006:
; 575: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x42,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0188
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4A
L0188:
; 576: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 577: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 578: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4A,W
	CALL IC01
; 579: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 580: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 581: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 582: 	I2CSend %10111111
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 583: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 584: Return
	RETURN
; 585: 
; 586: stepmotor:
L0007:
; 587: 	speed = 0
	CLRF 0x4D
	CLRF 0x4E
; 588: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 589: 	If new_steps = 65534 Then  'goto 0 detector position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0xFE
	MOVWF R1L
	MOVLW 0xFF
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 590: 		direction = 0
	BCF 0x07,0
; 591: 		ena = 1  'set enable on
	BSF 0x07,2
; 592: 		While zero = 1  'turn motor until zero switch is activated
L0190:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0191
; 593: 			clk = 1  'clock out
	BSF 0x07,1
; 594: 			WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 595: 			clk = 0
	BCF 0x07,1
; 596: 			WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 597: 		Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0190
L0191:
; 598: 		ena = 0  'set enable off
	BCF 0x07,2
; 599: 		If act_steps = 0 Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0192
; 600: 			new_pos = 0
	CLRF 0x48
; 601: 		Else  'one_round count to be done
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0193
L0192:
; 602: 			act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 603: 			value = 0  'first considerate that extra round is not allowed
	CLRF 0x30
; 604: 			Select Case ctrl_type
; 605: 			Case 2, 3  'check if extra round is allowed
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0196
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0195
L0196:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0194
L0195:
; 606: 				Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 607: 				Select Case turn_counter
; 608: 				Case > 126  'check if shortest way is allowed
	MOVF 0x41,W
	SUBLW 0x7E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0197
; 609: 					turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 610: 					Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0198:	BTFSC EECON1,WR
	GOTO L0198
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 611: 					value = 1  'now it is allowed
	MOVLW 0x01
	MOVWF 0x30
; 612: 				Case < 126
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0199
L0197:
	MOVLW 0x7E
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0200
; 613: 					Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0201:	BTFSC EECON1,WR
	GOTO L0201
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 614: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0202
L0200:
; 615: 				EndSelect
L0202:
L0199:
; 616: 			Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0203
L0194:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0205
L0206:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0204
L0205:
; 617: 				value = 1
	MOVLW 0x01
	MOVWF 0x30
; 618: 			Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0207
L0204:
; 619: 			EndSelect
L0207:
L0203:
; 620: 			If value = 1 Then
	MOVF 0x30,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
; 621: 				one_round = 0  'start counting one round steps
	CLRF 0x3F
	CLRF 0x40
; 622: 				ena = 1  'set enable on
	BSF 0x07,2
; 623: 				While zero = 0  'turn motor until zero switch is DISactivated
L0209:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0210
; 624: 					clk = 1  'clock out
	BSF 0x07,1
; 625: 					WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 626: 					clk = 0
	BCF 0x07,1
; 627: 					one_round = one_round + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 628: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 629: 				Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0209
L0210:
; 630: 				For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x30
L0211:
	MOVF 0x30,W
	SUBLW 0x64
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0212
; 631: 					clk = 1  'clock out
	BSF 0x07,1
; 632: 					WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 633: 					clk = 0
	BCF 0x07,1
; 634: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 635: 					one_round = one_round + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 636: 				Next value
	MOVLW 0x01
	ADDWF 0x30,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0211
L0212:
; 637: 				While zero = 1  'turn motor until zero switch is activated
L0213:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0214
; 638: 					clk = 1  'clock out
	BSF 0x07,1
; 639: 					WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 640: 					clk = 0
	BCF 0x07,1
; 641: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 642: 					one_round = one_round + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 643: 				Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0213
L0214:
; 644: 				one_round_half = one_round / 2
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 645: 				Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0215:	BTFSC EECON1,WR
	GOTO L0215
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 646: 				Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0216:	BTFSC EECON1,WR
	GOTO L0216
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 647: 				act_pos = 63
	MOVLW 0x3F
	MOVWF 0x31
; 648: 			Endif
L0208:
; 649: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0217:	BTFSC EECON1,WR
	GOTO L0217
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 650: 			ena = 0  'set enable off
	BCF 0x07,2
; 651: 		Endif
L0193:
; 652: 	Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0218
L0189:
; 653: 		steps = 0
	CLRF 0x34
	CLRF 0x35
; 654: 		If new_steps > act_steps Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0219
; 655: 			steps = new_steps - act_steps
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x34
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x35
; 656: 			direction = 1
	BSF 0x07,0
; 657: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0220
; 658: 				Select Case ctrl_type
; 659: 				Case 2, 3
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0223
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0222
L0223:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0221
L0222:
; 660: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 661: 					Select Case turn_counter
; 662: 					Case > 126  'check if shortest way is allowed
	MOVF 0x41,W
	SUBLW 0x7E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0224
; 663: 						turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 664: 						steps = one_round - steps  'go shortest way
	MOVF 0x34,W
	SUBWF 0x3F,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x35
; 665: 						direction = 0  'change  direction
	BCF 0x07,0
; 666: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0225:	BTFSC EECON1,WR
	GOTO L0225
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 667: 					Case < 126
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0226
L0224:
	MOVLW 0x7E
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0227
; 668: 							Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0228:	BTFSC EECON1,WR
	GOTO L0228
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 669: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0229
L0227:
; 670: 					EndSelect
L0229:
L0226:
; 671: 				Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0230
L0221:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0232
L0233:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0231
L0232:
; 672: 					steps = one_round - steps
	MOVF 0x34,W
	SUBWF 0x3F,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x35
; 673: 					direction = 0
	BCF 0x07,0
; 674: 				Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0234
L0231:
; 675: 				EndSelect
L0234:
L0230:
; 676: 			Endif
L0220:
; 677: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0235
L0219:
; 678: 			steps = act_steps - new_steps
	MOVF 0x36,W
	SUBWF 0x46,W
	MOVWF 0x34
	MOVF 0x37,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x35
; 679: 			direction = 0
	BCF 0x07,0
; 680: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0236
; 681: 				Select Case ctrl_type
; 682: 				Case 2, 3  'cable connected bridges
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0239
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0238
L0239:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0237
L0238:
; 683: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 684: 					Select Case turn_counter
; 685: 					Case < 130
	MOVLW 0x82
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0240
; 686: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 687: 						steps = one_round - steps  'go shortest way
	MOVF 0x34,W
	SUBWF 0x3F,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x35
; 688: 						direction = 1  'change direction
	BSF 0x07,0
; 689: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0241:	BTFSC EECON1,WR
	GOTO L0241
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 690: 					Case > 130
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0242
L0240:
	MOVF 0x41,W
	SUBLW 0x82
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0243
; 691: 						Write mem_turn_counter, 130
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x82
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0244:	BTFSC EECON1,WR
	GOTO L0244
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 692: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0245
L0243:
; 693: 					EndSelect
L0245:
L0242:
; 694: 				Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0246
L0237:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0249
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0248
L0249:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0247
L0248:
; 695: 					steps = one_round - steps
	MOVF 0x34,W
	SUBWF 0x3F,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x35
; 696: 					direction = 1
	BSF 0x07,0
; 697: 				Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0250
L0247:
; 698: 				EndSelect
L0250:
L0246:
; 699: 			Endif
L0236:
; 700: 		Endif
L0235:
; 701: 		If steps > 0 Then  'motor must be activated
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0251
; 702: 			If direction = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0252
; 703: 				steps = steps + free_space_word
	MOVF 0x34,W
	ADDWF 0x58,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x59,W
	MOVWF 0x35
; 704: 			Endif
L0252:
; 705: 			ramp_up = 1
	BSF 0x38,3
; 706: 			ramp_down_point = 0
	CLRF 0x53
	CLRF 0x54
; 707: 			half_steps = steps / 2
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5A
	MOVF R0H,W
	MOVWF 0x5B
; 708: 			speed = speed_min
	MOVF 0x3B,W
	MOVWF 0x4D
	MOVF 0x3C,W
	MOVWF 0x4E
; 709: 			ena = 1  'set enable on
	BSF 0x07,2
; 710: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0253:
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0254
; 711: 				If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0255
; 712: 					Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 713: 				Endif
L0255:
; 714: 				Select Case ctrl_type
; 715: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0256
; 716: 					If fy_stop = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0257
; 717: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 718: 					Endif
L0257:
; 719: 				Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0258
L0256:
; 720: 				EndSelect
L0258:
; 721: 				clk = 1  'clock out
	BSF 0x07,1
; 722: 				WaitUs speed
	MOVF 0x4D,W
	MOVWF R4L
	MOVF 0x4E,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 723: 				clk = 0
	BCF 0x07,1
; 724: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 725: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 726: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0253
L0254:
; 727: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 728: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0259
; 729: 				steps = free_space_word
	MOVF 0x58,W
	MOVWF 0x34
	MOVF 0x59,W
	MOVWF 0x35
; 730: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 731: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0260:
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0261
; 732: 					If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0262
; 733: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 734: 					Endif
L0262:
; 735: 					Select Case ctrl_type
; 736: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0263
; 737: 						If fy_stop = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0264
; 738: 							Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 739: 						Endif
L0264:
; 740: 					Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0265
L0263:
; 741: 					EndSelect
L0265:
; 742: 					clk = 1  'clock out
	BSF 0x07,1
; 743: 					WaitUs speed_min
	MOVF 0x3B,W
	MOVWF R4L
	MOVF 0x3C,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 744: 					clk = 0
	BCF 0x07,1
; 745: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 746: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 747: 				Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0260
L0261:
; 748: 			Endif
L0259:
; 749: 			ena = 0  'enable off
	BCF 0x07,2
; 750: 		Endif
L0251:
; 751: 	Endif
L0218:
; 752: 	act_pos = new_pos
	MOVF 0x48,W
	MOVWF 0x31
; 753: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0266:	BTFSC EECON1,WR
	GOTO L0266
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 754: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x49
; 755: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 756: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x3E
; 757: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 758: Return
	RETURN
; 759: 
; 760: speed_calc:
L0008:
; 761: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x5A,W
	MOVWF R1L
	MOVF 0x5B,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0267
; 762: 		ramp_up = 0
	BCF 0x38,3
; 763: 	Endif
L0267:
; 764: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x38,3
	GOTO L0268
; 765: 		If speed > speed_max Then
	MOVF 0x4D,W
	MOVWF R0L
	MOVF 0x4E,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	MOVF 0x3A,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0269
; 766: 			speed = speed - speed_step
	MOVF 0x45,W
	SUBWF 0x4D,W
	MOVWF 0x4D
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 767: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x53,W
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x54
; 768: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0270
L0269:
; 769: 			ramp_up = 0
	BCF 0x38,3
; 770: 		Endif
L0270:
; 771: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0271
L0268:
; 772: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x53,W
	MOVWF R1L
	MOVF 0x54,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0272
; 773: 			If speed < speed_min Then
	MOVF 0x4D,W
	MOVWF R0L
	MOVF 0x4E,W
	MOVWF R0H
	MOVF 0x3B,W
	MOVWF R1L
	MOVF 0x3C,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0273
; 774: 				speed = speed + speed_step
	MOVF 0x4D,W
	ADDWF 0x45,W
	MOVWF 0x4D
	MOVF 0x4E,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4E
; 775: 			Endif
L0273:
; 776: 		Endif
L0272:
; 777: 	Endif
L0271:
; 778: Return
	RETURN
; 779: 
; 780: set_relays:
L0009:
; 781: 	Gosub read_bridge_switch
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0013
; 782: 	If bridge_power = 0 Then  'bridge railpower must be switched on
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x38,2
	GOTO L0274
; 783: 		Select Case ctrl_type
; 784: 		Case 1, 3, 5, 6
	MOVF 0x32,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0277
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0276
L0277:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0278
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0276
L0278:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0279
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0276
L0279:
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0275
L0276:
; 785: 			swfw = 0
	BCF 0x06,0
; 786: 			swrev = 1
	BSF 0x06,1
; 787: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0280
L0275:
; 788: 			swfw = bridge_switch
	BTFSC 0x38,0
	BSF 0x06,0
	BTFSS 0x38,0
	BCF 0x06,0
; 789: 			swrev = Not bridge_switch
	BTFSS 0x38,0
	BSF 0x06,1
	BTFSC 0x38,0
	BCF 0x06,1
; 790: 		EndSelect
L0280:
; 791: 	Else  'BRIDGE IS ALWAYS ON
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0281
L0274:
; 792: 		If bridge_switch <> old_bridge_switch Then  'polarisation must be changed
	CLRW
	BTFSC 0x38,0
	ADDLW 0x01
	BTFSC 0x38,5
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0282
; 793: 			swfw = bridge_switch
	BTFSC 0x38,0
	BSF 0x06,0
	BTFSS 0x38,0
	BCF 0x06,0
; 794: 			swrev = Not bridge_switch
	BTFSS 0x38,0
	BSF 0x06,1
	BTFSC 0x38,0
	BCF 0x06,1
; 795: 			old_bridge_switch = bridge_switch
	BTFSC 0x38,0
	BSF 0x38,5
	BTFSS 0x38,0
	BCF 0x38,5
; 796: 		Endif
L0282:
; 797: 	Endif
L0281:
; 798: Return
	RETURN
; 799: 
; 800: init_eeprom:
L0010:
; 801: 	If pgm = 0 Then  'special for my own fiddle yard
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0283
; 802: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x36
	CLRF 0x37
; 803: 		For act_pos = 0 To 11
	CLRF 0x31
L0284:
	MOVF 0x31,W
	SUBLW 0x0B
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0285
; 804: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0015
; 805: 			new_steps = new_steps + 4300
	MOVF 0x36,W
	ADDLW 0xCC
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x37
; 806: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0284
L0285:
; 807: 		Write mem_max_pos, 11
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0B
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0286:	BTFSC EECON1,WR
	GOTO L0286
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 808: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 809: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0287
L0283:
; 810: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 811: 		steps = one_round / (max_pos + 1)  'devide the steps between min and max
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x34
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x34,W
	MOVWF R1L
	MOVF 0x35,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x34
	MOVF R0H,W
	MOVWF 0x35
; 812: 		For act_pos = 0 To max_pos
	CLRF 0x31
L0288:
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0289
; 813: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0015
; 814: 			bridge_switch = 0
	BCF 0x38,0
; 815: 			Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 816: 			new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x34,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x35,W
	MOVWF 0x37
; 817: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0288
L0289:
; 818: 	Endif
L0287:
; 819: 	act_pos = 0
	CLRF 0x31
; 820: 	Write mem_act_pos, act_pos  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0290:	BTFSC EECON1,WR
	GOTO L0290
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 821: Return
	RETURN
; 822: 
; 823: init_values:
L0011:
; 824: 	version = 0  'decimal point in display on
	BCF 0x38,4
; 825: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 826: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 827: 	version = 1  'decimal point in display off
	BSF 0x38,4
; 828: 	encoder_count = 0
	CLRF 0x4C
; 829: 	speed_min = 0
	CLRF 0x3B
	CLRF 0x3C
; 830: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 831: 	If speed_min.HB > 99 Then
	MOVF 0x3C,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0291
; 832: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3C
; 833: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0292
L0291:
; 834: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3C,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0293
; 835: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3C
; 836: 		Endif
L0293:
; 837: 	Endif
L0292:
; 838: 	speed_max = 0
	CLRF 0x39
	CLRF 0x3A
; 839: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 840: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x3A,W
	SUBWF 0x3C,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0294
; 841: 		speed_max.HB = speed_min.HB
	MOVF 0x3C,W
	MOVWF 0x3A
; 842: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0295
L0294:
; 843: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3A,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0296
; 844: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x3A
; 845: 		Endif
L0296:
; 846: 	Endif
L0295:
; 847: 
; 848: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 849: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 850: 	If one_round = 0 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0297
; 851: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 852: 	Endif
L0297:
; 853: 	If one_round > 60000 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0298
; 854: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 855: 	Endif
L0298:
; 856: 	one_round_half = one_round / 2
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 857: 
; 858: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 859: 	If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0299
; 860: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 861: 	Endif
L0299:
; 862: 
; 863: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 864: 	Select Case ctrl_type
; 865: 	Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0300
; 866: 		If max_pos > 30 Then
	MOVF 0x33,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0301
; 867: 			max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 868: 		Endif
L0301:
; 869: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0302
L0300:
; 870: 		If max_pos > 47 Then
	MOVF 0x33,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0303
; 871: 			max_pos = 47
	MOVLW 0x2F
	MOVWF 0x33
; 872: 		Endif
L0303:
; 873: 	EndSelect
L0302:
; 874: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 875: 	If act_pos > max_pos Then
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0304
; 876: 		act_pos = 0
	CLRF 0x31
; 877: 	Endif
L0304:
; 878: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 879: 	If free_space_steps > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0305
; 880: 		free_space_steps = 0
	CLRF 0x44
; 881: 	Endif
L0305:
; 882: 
; 883: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 884: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x41,W
	SUBLW 0x83
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0306
; 885: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x41
; 886: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0307
L0306:
; 887: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0308
; 888: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x41
; 889: 		Endif
L0308:
; 890: 	Endif
L0307:
; 891: 	
; 892: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 893: 	If speed_step > 99 Then
	MOVF 0x45,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0309
; 894: 		speed_step = 0
	CLRF 0x45
; 895: 	Endif
L0309:
; 896: 	
; 897: 	Read mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 898: 	If value > 1 Then
	MOVF 0x30,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0310
; 899: 		value = 0
	CLRF 0x30
; 900: 	Endif
L0310:
; 901: 	bridge_power = value.0
	BTFSC 0x30,0
	BSF 0x38,2
	BTFSS 0x30,0
	BCF 0x38,2
; 902: 	
; 903: 	If eep = 1 Then  'jumper set for initialisation
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0311
; 904: 		Gosub init_eeprom
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0010
; 905: 	Endif
L0311:
; 906: 	steps_set = 0
	BCF 0x38,1
; 907: 	new_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x48
; 908: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x49
; 909: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 910: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x3E
; 911: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 912: Return
	RETURN
; 913: 
; 914: steps_reading:
L0012:
; 915: 	Select Case new_pos
; 916: 	Case 63
	MOVF 0x48,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0312
; 917: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 918: 		act_steps = 1
	MOVLW 0x01
	MOVWF 0x46
	CLRF 0x47
; 919: 	Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0313
L0312:
	MOVF 0x48,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0314
; 920: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 921: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 922: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0315
L0314:
; 923: 		eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 924: 		Read act_pos, act_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 925: 		Read eprom_pointer, act_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 926: 		eprom_pointer = new_pos + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x50
; 927: 		Read new_pos, new_steps.LB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 928: 		Read eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 929: 		Read mem_free_space, value
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 930: 		free_space_word = free_space_steps * 4
	MOVF 0x44,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x58
	MOVF R2H,W
	MOVWF 0x59
; 931: 	EndSelect
L0315:
L0313:
; 932: Return
	RETURN
; 933: 
; 934: read_bridge_switch:
L0013:
; 935: 	Select Case act_pos
; 936: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0316
; 937: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 938: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0317
L0316:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0318
; 939: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 940: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0319
L0318:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0320
; 941: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 942: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0321
L0320:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0322
; 943: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 944: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0323
L0322:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0324
; 945: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 946: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0325
L0324:
; 947: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 948: 	EndSelect
L0325:
L0323:
L0321:
L0319:
L0317:
; 949: 	value2 = act_pos Mod 8
	MOVF 0x31,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x43
; 950: 	Select Case value2
; 951: 	Case 0
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0326
; 952: 		bridge_switch = value.0
	BTFSC 0x30,0
	BSF 0x38,0
	BTFSS 0x30,0
	BCF 0x38,0
; 953: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0327
L0326:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0328
; 954: 		bridge_switch = value.1
	BTFSC 0x30,1
	BSF 0x38,0
	BTFSS 0x30,1
	BCF 0x38,0
; 955: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0329
L0328:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0330
; 956: 		bridge_switch = value.2
	BTFSC 0x30,2
	BSF 0x38,0
	BTFSS 0x30,2
	BCF 0x38,0
; 957: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0331
L0330:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0332
; 958: 		bridge_switch = value.3
	BTFSC 0x30,3
	BSF 0x38,0
	BTFSS 0x30,3
	BCF 0x38,0
; 959: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0333
L0332:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0334
; 960: 		bridge_switch = value.4
	BTFSC 0x30,4
	BSF 0x38,0
	BTFSS 0x30,4
	BCF 0x38,0
; 961: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0335
L0334:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0336
; 962: 		bridge_switch = value.5
	BTFSC 0x30,5
	BSF 0x38,0
	BTFSS 0x30,5
	BCF 0x38,0
; 963: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0337
L0336:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0338
; 964: 		bridge_switch = value.6
	BTFSC 0x30,6
	BSF 0x38,0
	BTFSS 0x30,6
	BCF 0x38,0
; 965: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0339
L0338:
; 966: 		bridge_switch = value.7
	BTFSC 0x30,7
	BSF 0x38,0
	BTFSS 0x30,7
	BCF 0x38,0
; 967: 	EndSelect
L0339:
L0337:
L0335:
L0333:
L0331:
L0329:
L0327:
; 968: Return
	RETURN
; 969: 
; 970: store_bridge_switch:
L0014:
; 971: 	Select Case act_pos
; 972: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0340
; 973: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 974: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0341
L0340:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0342
; 975: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 976: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0343
L0342:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0344
; 977: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 978: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0345
L0344:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0346
; 979: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 980: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0347
L0346:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0348
; 981: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 982: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0349
L0348:
; 983: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 984: 	EndSelect
L0349:
L0347:
L0345:
L0343:
L0341:
; 985: 	value2 = act_pos
	MOVF 0x31,W
	MOVWF 0x43
; 986: 	value2 = value2 Mod 8
	MOVF 0x43,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x43
; 987: 	Select Case value2
; 988: 	Case 0
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0350
; 989: 		value.0 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,0
	BTFSS 0x38,0
	BCF 0x30,0
; 990: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0351
L0350:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0352
; 991: 		value.1 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,1
	BTFSS 0x38,0
	BCF 0x30,1
; 992: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0353
L0352:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0354
; 993: 		value.2 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,2
	BTFSS 0x38,0
	BCF 0x30,2
; 994: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0355
L0354:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0356
; 995: 		value.3 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,3
	BTFSS 0x38,0
	BCF 0x30,3
; 996: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0357
L0356:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0358
; 997: 		value.4 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,4
	BTFSS 0x38,0
	BCF 0x30,4
; 998: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0359
L0358:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0360
; 999: 		value.5 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,5
	BTFSS 0x38,0
	BCF 0x30,5
; 1000: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0361
L0360:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0362
; 1001: 		value.6 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,6
	BTFSS 0x38,0
	BCF 0x30,6
; 1002: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0363
L0362:
; 1003: 		value.7 = bridge_switch
	BTFSC 0x38,0
	BSF 0x30,7
	BTFSS 0x38,0
	BCF 0x30,7
; 1004: 	EndSelect
L0363:
L0361:
L0359:
L0357:
L0355:
L0353:
L0351:
; 1005: 	Select Case act_pos
; 1006: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0364
; 1007: 		Write mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0365:	BTFSC EECON1,WR
	GOTO L0365
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1008: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0366
L0364:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0367
; 1009: 		Write mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0368:	BTFSC EECON1,WR
	GOTO L0368
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1010: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0369
L0367:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0370
; 1011: 		Write mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0371:	BTFSC EECON1,WR
	GOTO L0371
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1012: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0372
L0370:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0373
; 1013: 		Write mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0374:	BTFSC EECON1,WR
	GOTO L0374
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1014: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0375
L0373:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0376
; 1015: 		Write mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0377:	BTFSC EECON1,WR
	GOTO L0377
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1016: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0378
L0376:
; 1017: 		Write mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0379:	BTFSC EECON1,WR
	GOTO L0379
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1018: 	EndSelect
L0378:
L0375:
L0372:
L0369:
L0366:
; 1019: Return
	RETURN
; 1020: 
; 1021: save_steps:
L0015:
; 1022: 	eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 1023: 	Write act_pos, new_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0380:	BTFSC EECON1,WR
	GOTO L0380
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1024: 	Write eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0381:	BTFSC EECON1,WR
	GOTO L0381
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1025: Return
	RETURN
; 1026: 
; 1027: stop_the_motor:
L0016:
; 1028: 	While ecsw = 1
L0382:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,6
	GOTO L0383
; 1029: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 1030: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0382
L0383:
; 1031: Return
	RETURN
; End of program
;       PAGE SELECT
;	BCF PCLATH,3
L0384:	GOTO L0384
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
