'program TT for PCBoard MGV145
'version V3-1  Fiddle Yard version, for turntables and fiddle yard
'this version has all possibilities changeable by menue's.
'V3-2 counter for twisting cables tored at eeprom pos zero.
'the value of the counter can be anything between 125 and 131. 128 is zero point.
'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
'V3.6 startup delayed, to avoid wrong positions
'V3.7 extra separate positions for FY and TT with contact sliders.
'-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
'V4.4 initial setting freespace dafaults to 0.
'-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
'-    manual position setting can be turned through zero
'V4.5 extra menu 8 for setting the first position where rail power should be reversed
'V4.6 0 point will also control cable twist
'V4.7 Fiddle yard (ctrl type 6) has only 5 selection lines.(max 30 positions , 31 = zero adjust)
'-    pos.req 6 is set as input, MGV50 should be set as block output
'-    the two connection rails in and out are connected to current detection
'-    any train on these tracks will give siganl,where FY will stop immediately (same as endswitch)
'V4.8 Extra menu added for settings of reverse/not per position (only for 0,2,4 )
'-    These bits (bridge_switch) are stored and read in 6 bytes
'V4.9 Free_space_steps multiplied by 10 , 990 correction steps available
'-    Positions are changed to 0-47
'-    Maximum positons can be as low as two
'V5.0 Correction for init eprom routine position change to 0-47
'-    Free_space_steps multiplier changed to 4
'-    Added position 62 for recalibration, turn in direction 0 until 0 detector reached and set position to 0
'-    Added menu option 9 to operate the stepper motor without changing the stored steps
'V5.1 Correction for bug that when a position is at 0 steps (perfectly aligned zero detector)
'-    the "determine one round" routine is called when selecting that position
'V5.2 Correction for relay control, only switch relays before and after moving, only when needed
'-    Menu 0 and 1 only available when posistion is a real position, not a special position (62, 63)
Define CONF_WORD = 0x3f72
Define CLOCK_FREQUENCY = 20
'Define SIMULATION_WAITuS_VALUE = 1
Dim steps As Word
Dim half_steps As Word
Dim ramp_down_point As Word
Dim program_set As Byte
Dim new_steps As Word
Dim act_steps As Word
Dim new_pos As Byte
Dim act_pos As Byte
Dim one_round As Word
Dim one_round_half As Word
Dim bus_pos As Byte
Dim old_bus_pos As Byte
Dim speed As Word
Dim speed_min As Word
Dim speed_max As Word
Dim new_encoder As Byte
Dim old_encoder As Byte
Dim manual_pos As Byte
Dim old_manual_pos As Byte
Dim result As Byte
Dim free_space_steps As Byte
Dim free_space_word As Word
Dim value As Byte
Dim value2 As Byte
Dim eprom_pointer As Byte
Dim encoder_count As Byte
Dim turn_counter As Byte
Dim old_bridge_switch As Bit
Dim max_pos As Byte
Dim disp1_val As Byte
Dim disp2_val As Byte
Dim ctrl_type As Byte
Dim old_pos_write As Bit
Dim ramp_up As Bit
Dim speed_step As Byte
Dim version As Bit
Dim steps_set As Bit
Dim bridge_power As Bit
Dim bridge_switch As Bit
Const disp1 = 64
Const disp2 = 66
Const mem_turn_counter = 101
Const mem_act_pos = 102
Const mem_speed_min = 103
Const mem_speed_max = 104
Const mem_speed_step = 105
Const mem_one_round_lb = 106
Const mem_one_round_hb = 107
Const mem_ctrl_type = 108
Const mem_max_pos = 109
Const mem_free_space = 110

Const mem_bridge_power = 112
Const mem_bridge_switch1 = 113
Const mem_bridge_switch2 = 114
Const mem_bridge_switch3 = 115
Const mem_bridge_switch4 = 116
Const mem_bridge_switch5 = 117
Const mem_bridge_switch6 = 118
Symbol swfw = RB0
Symbol swrev = RB1
Symbol sck = RB2
Symbol sda = RB3
Symbol pos_match = RB4
Symbol pos_write = RB5
Symbol eep = RB6
Symbol max_end = RB7
Symbol direction = RC0
Symbol clk = RC1
Symbol ena = RC2
Symbol zero = RC3
Symbol ec1 = RC4
Symbol ec2 = RC5
Symbol ecsw = RC6
Symbol pgm = RC7
Symbol fy_stop = RA5
ADCON1 = %0110
TRISA = %111111
TRISB = %11101100
TRISC = %11111000
PORTB = %11101100
PORTC = %11111000
I2CPrepare sda, sck
value = 52  'version number
Gosub init_values
value = act_pos
version = 1
Gosub i2c_display
Gosub read_bridge_switch
old_bridge_switch = Not bridge_switch  'make sure that bridge power will be turned on
Gosub set_relays
program_set = 1
main:
	If pgm = 0 Then
		Gosub adjust_settings
		WaitMs 500
	Endif

	Gosub get_new_position
	If bus_pos <> old_bus_pos Then
		pos_match = 1  'indicate not in position
		If bridge_power = 0 Then  'bridge railpower must be switched off
			swfw = 0
			swrev = 0
		Endif
		new_pos = bus_pos
		Gosub stepmotor
		value = act_pos
		Gosub i2c_display
		Gosub set_relays
		pos_match = 0  'indicate pos_match
	Else
		If ecsw = 0 Then  'only when knob is pushed
			If manual_pos <> old_manual_pos Then
				pos_match = 1  'indicate not in position
				If bridge_power = 0 Then  'bridge railpower must be switched off
					swfw = 0
					swrev = 0
				Endif
				old_manual_pos = manual_pos
				new_pos = manual_pos
				Gosub stepmotor
				value = act_pos
				Gosub i2c_display
				Gosub set_relays
				pos_match = 0  'indicate pos_match
			Endif
		Endif
	Endif
	WaitMs 10
	Goto main
End                                               

get_new_position:
	value = bus_pos  'remember the position
	If pos_write = 1 Then
		If old_pos_write = 0 Then  'react only once on rising edge
			old_pos_write = 1
			value = PORTA And 63  'now get value from J5
			If ctrl_type = 6 Then  'fiddle yard max = 30
				value = value And 31
				If value = 31 Then  '31 is for zero adjust, maybe only 5 bits are available
					value = 63
				Endif
			Endif
			Select Case value
			Case 63  'make zero adjust
				value = 0
			Case Else
				If value > max_pos Then  'this is not allowed
					value = bus_pos  'put it back to old situation
				Endif
			EndSelect
						Gosub i2c_display
			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
				pos_match = 1
				WaitMs 1000
				pos_match = 0
			Endif
		Endif
	Else
		old_pos_write = 0
	Endif
	bus_pos = value  'now take over the desired position
	Gosub calc_rotation
	Select Case result
	Case 1
		If encoder_count < 4 Then
			encoder_count = encoder_count + 1
		Else
			encoder_count = 0
			Select Case manual_pos
			Case 63
				manual_pos = 0
			Case 62
				manual_pos = 63
			Case max_pos
				manual_pos = 62
			Case Else
				manual_pos = manual_pos + 1
			EndSelect
			value = manual_pos
			Gosub i2c_display
		Endif
	Case 2
		If encoder_count > 0 Then
			encoder_count = encoder_count - 1
		Else
			encoder_count = 4
			Select Case manual_pos
			Case 63
				manual_pos = 62
			Case 62
				manual_pos = max_pos
			Case 0
				manual_pos = 63
			Case Else
				manual_pos = manual_pos - 1
			EndSelect
			value = manual_pos
			Gosub i2c_display
		Endif
	Case Else
	EndSelect
	WaitMs 1
	
Return                                            

calc_rotation:  'this routine checks the incrimental switch
'1 = increasing value
'2 = decreasing value
'3 = no change
		new_encoder = 0
		new_encoder.0 = ec1
		new_encoder.1 = ec2
		Select Case old_encoder
		Case 0
			result = LookUp(3, 2, 1, 3), new_encoder
		Case 1
			result = LookUp(1, 3, 3, 2), new_encoder
		Case 2
			result = LookUp(2, 3, 3, 1), new_encoder
		Case Else
			result = LookUp(3, 1, 2, 3), new_encoder
		EndSelect
		old_encoder = new_encoder
Return                                            

adjust_settings:
	If program_set = 0 Or program_set = 1 Then  'menu 0 and 1 not available when position has a special value (62, 63)
		If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then
			program_set = program_set
		Else
			program_set = 2
		Endif
	Endif
	If bridge_power = 0 Then  'bridge railpower must be switched off
		swfw = 0
		swrev = 0
	Endif
	Gosub i2c_display_pgm
	WaitMs 800  'give some time for display to be read
	Gosub steps_reading
	new_steps = act_steps  'nothing is changed yet
	While pgm = 0  'the program switch is still activated
		If ecsw = 0 Then  'knob is pressed, increase program_set
			program_set = program_set + 1
			If program_set > 9 Then  'no more than 9 items te change
				If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then  'menu 0 and 1 only available when position is not a special position
					program_set = 0
				Else
					program_set = 2
				Endif
			Endif
			Gosub i2c_display_pgm
			WaitMs 800  'give some time for display to be read
			While ecsw = 0  'be sure pushbutton is released
				WaitMs 250  'cancel contact dender
			Wend
		Endif
		Select Case program_set
		Case 0  'correction of current position
			value = act_pos
			Gosub i2c_display
			Gosub calc_rotation  'look for the knob to be turned
			Select Case result
			Case 1
				If new_steps < 60000 Then
					ena = 1  'motor on
					new_steps = new_steps + 1
					direction = 1
					clk = 1  'clock out
					WaitMs 5
					clk = 0
				Endif
			Case 2
				If new_steps > 0 Then
					ena = 1  'motor on
					new_steps = new_steps - 1
					direction = 0
					clk = 1  'clock out
					WaitMs 5
					clk = 0
				Endif
			Case Else
			EndSelect
			Select Case act_pos
			Case 1
				steps_set = 1
			Case 2
				If steps_set = 1 Then
					If eep = 1 Then  'iF jumper eep1 is set to on
											'routine to set steps for pos 3 to max_pos
						value = 63
						Gosub i2c_display  'show 63 to indicate adjusting is proceeded
						If act_steps <> new_steps Then
							Gosub save_steps
						Endif
						act_pos = 1
						new_pos = 2
						Gosub steps_reading
						steps = new_steps - act_steps  'calculate difference between one and two
						For act_pos = 3 To max_pos
							new_steps = new_steps + steps
							Gosub save_steps
						Next act_pos
						WaitMs 2000  'give some timne to read display
						act_pos = 2  'we were at this position
						steps_set = 0  'do this routine only once
					Endif
				Endif
			Case Else
				steps_set = 0
			EndSelect  'act_pos
		Case 1  'setting of inverse / not inverse bridge rail power
			Gosub read_bridge_switch
			value = 0
			value.0 = bridge_switch
			Gosub i2c_display
			Gosub calc_rotation  'look for the knob to be turned
			Select Case result
			Case 1, 2
				bridge_switch = Not bridge_switch
				Gosub store_bridge_switch
				swfw = bridge_switch
				swrev = Not bridge_switch
			Case Else
			EndSelect
		Case 2  'setting of maximum positions
			steps_set = 0
			ena = 0  'shut off motor
			value = max_pos
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				max_pos = max_pos + 1
				Select Case ctrl_type
				Case 6
					If max_pos > 30 Then  'no more positions possible
						max_pos = 1
					Endif
					Write mem_max_pos, max_pos
				Case Else
					If max_pos > 47 Then  'no more positions possible
						max_pos = 1
					Endif
					Write mem_max_pos, max_pos
				EndSelect
			Case 2
				max_pos = max_pos - 1
				If max_pos < 1 Then  'mininum 2 positions
					Select Case ctrl_type
					Case 6
						max_pos = 30
					Case Else
						max_pos = 47
					EndSelect
					Write mem_max_pos, max_pos
				Endif
			Case Else
			EndSelect
		Case 3  'setting control type
			steps_set = 0
			ena = 0  'shut off motor
			If ctrl_type > 6 Then
				ctrl_type = 0
				Write mem_ctrl_type, ctrl_type
			Endif
			value = ctrl_type
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				ctrl_type = ctrl_type + 1
				If ctrl_type = 7 Then
					ctrl_type = 0
				Endif
				Write mem_ctrl_type, ctrl_type
			Case 2
				ctrl_type = ctrl_type - 1
				If ctrl_type = 255 Then
					ctrl_type = 6
				Endif
				Write mem_ctrl_type, ctrl_type
			Case Else
			EndSelect
		Case 4  'setting of speed interval Minimum
					'setting will be done in multiple of 256 uSecs
					'minimum is 2 and maximum is 99 (is real slow)
			steps_set = 0
			ena = 0  'shut off motor
			value = speed_min.HB
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed_min.HB < 99 Then  'display is limited to 99
					speed_min = speed_min + 256
					Write mem_speed_min, speed_min.HB
				Endif
			Case 2
				If speed_min > speed_max Then
					speed_min = speed_min - 256
					Write mem_speed_min, speed_min.HB
				Endif
			Case Else
			EndSelect
		Case 5  'setting of speed interval Maximum
					'setting will be done in multiple of 256 uSecs
					'minimum is 1 and maximum is 99 (is real slow)
			steps_set = 0
			ena = 0  'shut off motor
			value = speed_max.HB
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed_max.HB < speed_min.HB Then  'not more then speed_min
					speed_max.HB = speed_max.HB + 1
					Write mem_speed_max, speed_max.HB
				Endif
			Case 2
				If speed_max.HB > 1 Then
					speed_max.HB = speed_max.HB - 1
					Write mem_speed_max, speed_max.HB
				Endif
			Case Else
			EndSelect
		Case 6  'setting of ramp up and down speed
					'speed will be the value that speed will be changed every step up and down
			steps_set = 0
			ena = 0  'shut off motor
			value = speed_step
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed_step < 99 Then  'maximum 99 is possible
					speed_step = speed_step + 1
					Write mem_speed_step, speed_step
				Endif
			Case 2
				If speed_step > 1 Then
					speed_step = speed_step - 1
					Write mem_speed_step, speed_step
				Endif
			Case Else
			EndSelect
	
		Case 7  'setting of extra free space steps
			steps_set = 0
			ena = 0  'shut off motor
			If free_space_steps > 99 Then
				free_space_steps = 99
				Write mem_free_space, free_space_steps
			Endif
			value = free_space_steps
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If free_space_steps < 99 Then  'display is limited to 99
					free_space_steps = free_space_steps + 1
					Write mem_free_space, free_space_steps
				Endif
			Case 2
				If free_space_steps > 0 Then
					free_space_steps = free_space_steps - 1
					Write mem_free_space, free_space_steps
				Endif
			Case Else
			EndSelect
		Case 8  'setting if power should be on or off while bridge is moving (0 = off)
			Read mem_bridge_power, value
			If value > 1 Then
				value = 1
			Endif
			bridge_power = value.0
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1, 2
				bridge_power = Not bridge_power
				value.0 = bridge_power
				Write mem_bridge_power, value
			Case Else
			EndSelect
		Case 9  'move but do not change stored steps
			value = act_pos
			Gosub i2c_display
			Gosub calc_rotation  'look for the knob to be turned
			Select Case result
			Case 1
					ena = 1  'motor on
					direction = 0
					clk = 1  'clock out
					WaitMs 5
					clk = 0
			Case 2
					ena = 1  'motor on
					direction = 1
					clk = 1  'clock out
					WaitMs 5
					clk = 0
			Case Else
			EndSelect
		EndSelect
	Wend
	ena = 0  'shut off motor
		'***************   now check if changes have to BE written in eeprom
	If new_steps <> act_steps Then  'now save new position
		Gosub save_steps
	Endif
	value = act_pos
	Gosub i2c_display
	Gosub set_relays
Return                                            

i2c_display:
	disp1_val = value
	disp1_val = disp1_val Mod 10
	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	disp1_val.7 = pgm
	disp2_val = value
	disp2_val = disp2_val / 10
	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	disp2_val.7 = version
	I2CStart
	I2CSend disp1
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp2
	I2CSend disp2_val
	I2CStop
Return                                            

i2c_display_pgm:
	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	I2CStart
	I2CSend disp1
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp2
	I2CSend %10111111
	I2CStop
Return                                            

stepmotor:
	speed = 0
	Gosub steps_reading
	If new_steps = 65534 Then  'goto 0 detector position
		direction = 0
		ena = 1  'set enable on
		While zero = 1  'turn motor until zero switch is activated
			clk = 1  'clock out
			WaitUs speed_max
			clk = 0
			WaitUs 5
		Wend
		ena = 0  'set enable off
		If act_steps = 0 Then
			new_pos = 0
		Else  'one_round count to be done
			act_steps = 0
			value = 0  'first considerate that extra round is not allowed
			Select Case ctrl_type
			Case 2, 3  'check if extra round is allowed
				Read mem_turn_counter, turn_counter
				Select Case turn_counter
				Case > 126  'check if shortest way is allowed
					turn_counter = turn_counter - 1  'yes it is, so substract one pass
					Write mem_turn_counter, turn_counter
					value = 1  'now it is allowed
				Case < 126
					Write mem_turn_counter, 126
				Case Else
				EndSelect
			Case 4, 5  'type with contact sliders, no twisting cables
				value = 1
			Case Else  'no short way possible
			EndSelect
			If value = 1 Then
				one_round = 0  'start counting one round steps
				ena = 1  'set enable on
				While zero = 0  'turn motor until zero switch is DISactivated
					clk = 1  'clock out
					WaitUs speed_max
					clk = 0
					one_round = one_round + 1
					WaitUs 5
				Wend
				For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
					clk = 1  'clock out
					WaitUs speed_max
					clk = 0
					WaitUs 5
					one_round = one_round + 1
				Next value
				While zero = 1  'turn motor until zero switch is activated
					clk = 1  'clock out
					WaitUs speed_max
					clk = 0
					WaitUs 5
					one_round = one_round + 1
				Wend
				one_round_half = one_round / 2
				Write mem_one_round_lb, one_round.LB
				Write mem_one_round_hb, one_round.HB
				act_pos = 63
			Endif
			Write mem_act_pos, act_pos
			ena = 0  'set enable off
		Endif
	Else  'this is the normal position sequence
		steps = 0
		If new_steps > act_steps Then
			steps = new_steps - act_steps
			direction = 1
			If steps > one_round_half Then  'is other direction shorter?
				Select Case ctrl_type
				Case 2, 3
					Read mem_turn_counter, turn_counter
					Select Case turn_counter
					Case > 126  'check if shortest way is allowed
						turn_counter = turn_counter - 1  'yes it is, so substract one pass
						steps = one_round - steps  'go shortest way
						direction = 0  'change  direction
						Write mem_turn_counter, turn_counter
					Case < 126
							Write mem_turn_counter, 126
					Case Else
					EndSelect
				Case 4, 5  'type with contact sliders, no twisting cables
					steps = one_round - steps
					direction = 0
				Case Else  'no short way possible
				EndSelect
			Endif
		Else
			steps = act_steps - new_steps
			direction = 0
			If steps > one_round_half Then  'other direction shorter?
				Select Case ctrl_type
				Case 2, 3  'cable connected bridges
					Read mem_turn_counter, turn_counter
					Select Case turn_counter
					Case < 130
						turn_counter = turn_counter + 1  'yes it is, so add one pass
						steps = one_round - steps  'go shortest way
						direction = 1  'change direction
						Write mem_turn_counter, turn_counter
					Case > 130
						Write mem_turn_counter, 130
					Case Else
					EndSelect
				Case 4, 5  'type with contact sliders, no twisting cables
					steps = one_round - steps
					direction = 1
				Case Else  'no short way possible
				EndSelect
			Endif
		Endif
		If steps > 0 Then  'motor must be activated
			If direction = 1 Then
				steps = steps + free_space_word
			Endif
			ramp_up = 1
			ramp_down_point = 0
			half_steps = steps / 2
			speed = speed_min
			ena = 1  'set enable on
			While steps > 0  'NOW RUN UNTIL STEPS = 0
				If max_end = 0 Then
					Gosub stop_the_motor
				Endif
				Select Case ctrl_type
				Case 6
					If fy_stop = 1 Then
						Gosub stop_the_motor
					Endif
				Case Else
				EndSelect
				clk = 1  'clock out
				WaitUs speed
				clk = 0
				Gosub speed_calc
				steps = steps - 1
			Wend
			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
			If direction = 1 Then
				steps = free_space_word
				direction = 0  'now go back the free-space correction
				While steps > 0  'NOW RUN UNTIL STEPS = 0
					If max_end = 0 Then
						Gosub stop_the_motor
					Endif
					Select Case ctrl_type
					Case 6
						If fy_stop = 1 Then
							Gosub stop_the_motor
						Endif
					Case Else
					EndSelect
					clk = 1  'clock out
					WaitUs speed_min
					clk = 0
					steps = steps - 1
					WaitUs 5
				Wend
			Endif
			ena = 0  'enable off
		Endif
	Endif
	act_pos = new_pos
	Write mem_act_pos, act_pos
	bus_pos = act_pos
	old_bus_pos = act_pos
	manual_pos = act_pos
	old_manual_pos = act_pos
Return                                            

speed_calc:
	If steps < half_steps Then  'at this point  ramp up MUST end
		ramp_up = 0
	Endif
	If ramp_up = 1 Then  'we were supposed to ramp up
		If speed > speed_max Then
			speed = speed - speed_step
			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
		Else
			ramp_up = 0
		Endif
	Else
		If steps < ramp_down_point Then  'this is the point tot start ramp down
			If speed < speed_min Then
				speed = speed + speed_step
			Endif
		Endif
	Endif
Return                                            

set_relays:
	Gosub read_bridge_switch
	If bridge_power = 0 Then  'bridge railpower must be switched on
		Select Case ctrl_type
		Case 1, 3, 5, 6
			swfw = 0
			swrev = 1
		Case Else
			swfw = bridge_switch
			swrev = Not bridge_switch
		EndSelect
	Else  'BRIDGE IS ALWAYS ON
		If bridge_switch <> old_bridge_switch Then  'polarisation must be changed
			swfw = bridge_switch
			swrev = Not bridge_switch
			old_bridge_switch = bridge_switch
		Endif
	Endif
Return                                            

init_eeprom:
	If pgm = 0 Then  'special for my own fiddle yard
		new_steps = 178
		For act_pos = 0 To 11
			Gosub save_steps
			new_steps = new_steps + 4300
		Next act_pos
		Write mem_max_pos, 11
		max_pos = 12
	Else
		new_steps = 0
		steps = one_round / (max_pos + 1)  'devide the steps between min and max
		For act_pos = 0 To max_pos
			Gosub save_steps
			bridge_switch = 0
			Gosub store_bridge_switch
			new_steps = new_steps + steps
		Next act_pos
	Endif
	act_pos = 0
	Write mem_act_pos, act_pos  'act_pos
Return                                            

init_values:
	version = 0  'decimal point in display on
	Gosub i2c_display
	WaitMs 3000
	version = 1  'decimal point in display off
	encoder_count = 0
	speed_min = 0
	Read mem_speed_min, speed_min.HB
	If speed_min.HB > 99 Then
		speed_min.HB = 40
	Else
		If speed_min.HB < 1 Then
			speed_min.HB = 40
		Endif
	Endif
	speed_max = 0
	Read mem_speed_max, speed_max.HB
	If speed_max.HB > speed_min.HB Then
		speed_max.HB = speed_min.HB
	Else
		If speed_max.HB < 1 Then
			speed_max.HB = 6
		Endif
	Endif

	Read mem_one_round_lb, one_round.LB
	Read mem_one_round_hb, one_round.HB
	If one_round = 0 Then
		one_round = 8000
	Endif
	If one_round > 60000 Then
		one_round = 8000
	Endif
	one_round_half = one_round / 2

	Read mem_ctrl_type, ctrl_type
	If ctrl_type > 6 Then
		ctrl_type = 6
	Endif

	Read mem_max_pos, max_pos
	Select Case ctrl_type
	Case 6
		If max_pos > 30 Then
			max_pos = 12
		Endif
	Case Else
		If max_pos > 47 Then
			max_pos = 47
		Endif
	EndSelect
	Read mem_act_pos, act_pos
	If act_pos > max_pos Then
		act_pos = 0
	Endif
	Read mem_free_space, free_space_steps
	If free_space_steps > 99 Then
		free_space_steps = 0
	Endif

	Read mem_turn_counter, turn_counter
	If turn_counter > 131 Then  'in program impossible value
		turn_counter = 128
	Else
		If turn_counter < 125 Then  'in program impossible value
			turn_counter = 128
		Endif
	Endif
	
	Read mem_speed_step, speed_step
	If speed_step > 99 Then
		speed_step = 0
	Endif
	
	If eep = 1 Then  'jumper set for initialisation
		Gosub init_eeprom
	Endif
	steps_set = 0
	new_pos = act_pos
	bus_pos = act_pos
	old_bus_pos = act_pos
	manual_pos = act_pos
	old_manual_pos = act_pos
Return                                            

steps_reading:
	Select Case new_pos
	Case 63
		new_steps = 65534
		act_steps = 1
	Case 62
		new_steps = 65534
		act_steps = 0
	Case Else
		eprom_pointer = act_pos + 48
		Read act_pos, act_steps.LB
		Read eprom_pointer, act_steps.HB
		eprom_pointer = new_pos + 48
		Read new_pos, new_steps.LB
		Read eprom_pointer, new_steps.HB
		Read mem_free_space, value
		free_space_word = free_space_steps * 4
	EndSelect
Return                                            

read_bridge_switch:
	Select Case act_pos
	Case < 8
		Read mem_bridge_switch1, value
	Case < 16
		Read mem_bridge_switch2, value
	Case < 24
		Read mem_bridge_switch3, value
	Case < 32
		Read mem_bridge_switch4, value
	Case < 40
		Read mem_bridge_switch5, value
	Case Else
		Read mem_bridge_switch6, value
	EndSelect
	value2 = act_pos Mod 8
	Select Case value2
	Case 0
		bridge_switch = value.0
	Case 1
		bridge_switch = value.1
	Case 2
		bridge_switch = value.2
	Case 3
		bridge_switch = value.3
	Case 4
		bridge_switch = value.4
	Case 5
		bridge_switch = value.5
	Case 6
		bridge_switch = value.6
	Case Else
		bridge_switch = value.7
	EndSelect
Return                                            

store_bridge_switch:
	Select Case act_pos
	Case < 8
		Read mem_bridge_switch1, value
	Case < 16
		Read mem_bridge_switch2, value
	Case < 24
		Read mem_bridge_switch3, value
	Case < 32
		Read mem_bridge_switch4, value
	Case < 40
		Read mem_bridge_switch5, value
	Case Else
		Read mem_bridge_switch6, value
	EndSelect
	value2 = act_pos
	value2 = value2 Mod 8
	Select Case value2
	Case 0
		value.0 = bridge_switch
	Case 1
		value.1 = bridge_switch
	Case 2
		value.2 = bridge_switch
	Case 3
		value.3 = bridge_switch
	Case 4
		value.4 = bridge_switch
	Case 5
		value.5 = bridge_switch
	Case 6
		value.6 = bridge_switch
	Case Else
		value.7 = bridge_switch
	EndSelect
	Select Case act_pos
	Case < 8
		Write mem_bridge_switch1, value
	Case < 16
		Write mem_bridge_switch2, value
	Case < 24
		Write mem_bridge_switch3, value
	Case < 32
		Write mem_bridge_switch4, value
	Case < 40
		Write mem_bridge_switch5, value
	Case Else
		Write mem_bridge_switch6, value
	EndSelect
Return                                            

save_steps:
	eprom_pointer = act_pos + 48
	Write act_pos, new_steps.LB
	Write eprom_pointer, new_steps.HB
Return                                            

stop_the_motor:
	While ecsw = 1
		WaitMs 250
	Wend
Return                                            
