; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The address of 'act_pos' (byte) (global) is 0x30
	act_pos EQU 0x30
;       The address of 'value' (byte) (global) is 0x31
	value EQU 0x31
;       The address of 'ctrl_type' (byte) (global) is 0x32
	ctrl_type EQU 0x32
;       The address of 'steps' (word) (global) is 0x33
	steps EQU 0x33
;       The address of 'max_pos' (byte) (global) is 0x35
	max_pos EQU 0x35
;       The address of 'new_steps' (word) (global) is 0x36
	new_steps EQU 0x36
;       The address of 'one_round' (word) (global) is 0x38
	one_round EQU 0x38
;       The address of 'speed_max' (word) (global) is 0x3A
	speed_max EQU 0x3A
;       The address of 'speed_min' (word) (global) is 0x3C
	speed_min EQU 0x3C
;       The address of 'result' (byte) (global) is 0x3E
	result EQU 0x3E
;       The address of 'turn_counter' (byte) (global) is 0x3F
	turn_counter EQU 0x3F
;       The address of 'rev_pos' (byte) (global) is 0x40
	rev_pos EQU 0x40
;       The address of 'free_space_steps' (byte) (global) is 0x41
	free_space_steps EQU 0x41
;       The address of 'manual_pos' (byte) (global) is 0x42
	manual_pos EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'speed_step' (byte) (global) is 0x44
	speed_step EQU 0x44
;       The address of 'steps_set' (bit) (global) is 0x45,0
;       The address of 'act_steps' (word) (global) is 0x46
	act_steps EQU 0x46
;       The address of 'disp1_val' (byte) (global) is 0x48
	disp1_val EQU 0x48
;       The address of 'new_encoder' (byte) (global) is 0x49
	new_encoder EQU 0x49
;       The address of 'encoder_count' (byte) (global) is 0x4A
	encoder_count EQU 0x4A
;       The address of 'bridge_power' (byte) (global) is 0x4B
	bridge_power EQU 0x4B
;       The address of 'new_pos' (byte) (global) is 0x4C
	new_pos EQU 0x4C
;       The address of 'bus_pos' (byte) (global) is 0x4D
	bus_pos EQU 0x4D
;       The address of 'speed' (word) (global) is 0x4E
	speed EQU 0x4E
;       The address of 'onoff' (bit) (global) is 0x45,1
;       The address of 'disp2_val' (byte) (global) is 0x50
	disp2_val EQU 0x50
;       The address of 'eprom_pointer' (byte) (global) is 0x51
	eprom_pointer EQU 0x51
;       The address of 'old_encoder' (byte) (global) is 0x52
	old_encoder EQU 0x52
;       The address of 'old_manual_pos' (byte) (global) is 0x53
	old_manual_pos EQU 0x53
;       The address of 'ramp_up' (bit) (global) is 0x45,2
;       The address of 'version' (bit) (global) is 0x45,3
;       The address of 'ramp_down_point' (word) (global) is 0x54
	ramp_down_point EQU 0x54
;       The address of 'one_round_half' (word) (global) is 0x56
	one_round_half EQU 0x56
;       The address of 'old_bus_pos' (byte) (global) is 0x58
	old_bus_pos EQU 0x58
;       The address of 'old_pos_write' (bit) (global) is 0x45,4
;       The address of 'half_steps' (word) (global) is 0x59
	half_steps EQU 0x59
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0015:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: 'V4.4 initial setting freespace dafaults to 0.
; 12: '-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
; 13: '-    manual position setting can be turned through zero
; 14: 'V4.5 extra menu 8 for setting the first position where rail power should be reversed
; 15: Define CONF_WORD = 0x3f72
; 16: Define CLOCK_FREQUENCY = 20
; 17: 'Define SIMULATION_WAITuS_VALUE = 1
; 18: Dim steps As Word
; 19: Dim half_steps As Word
; 20: Dim ramp_down_point As Word
; 21: Dim program_set As Byte
; 22: Dim new_steps As Word
; 23: Dim act_steps As Word
; 24: Dim new_pos As Byte
; 25: Dim act_pos As Byte
; 26: Dim one_round As Word
; 27: Dim one_round_half As Word
; 28: Dim bus_pos As Byte
; 29: Dim old_bus_pos As Byte
; 30: Dim speed As Word
; 31: Dim speed_min As Word
; 32: Dim speed_max As Word
; 33: Dim new_encoder As Byte
; 34: Dim old_encoder As Byte
; 35: Dim manual_pos As Byte
; 36: Dim old_manual_pos As Byte
; 37: Dim result As Byte
; 38: Dim free_space_steps As Byte
; 39: Dim value As Byte
; 40: Dim eprom_pointer As Byte
; 41: Dim encoder_count As Byte
; 42: Dim turn_counter As Byte
; 43: Dim onoff As Bit
; 44: Dim max_pos As Byte
; 45: Dim rev_pos As Byte
; 46: Dim disp1_val As Byte
; 47: Dim disp2_val As Byte
; 48: Dim ctrl_type As Byte
; 49: Dim old_pos_write As Bit
; 50: Dim ramp_up As Bit
; 51: Dim speed_step As Byte
; 52: Dim version As Bit
; 53: Dim steps_set As Bit
; 54: Dim bridge_power As Byte
; 55: Const disp1 = 64
; 56: Const disp2 = 66
; 57: Const mem_turn_counter = 101
; 58: Const mem_act_pos = 102
; 59: Const mem_speed_min = 103
; 60: Const mem_speed_max = 104
; 61: Const mem_speed_step = 105
; 62: Const mem_one_round_lb = 106
; 63: Const mem_one_round_hb = 107
; 64: Const mem_ctrl_type = 108
; 65: Const mem_max_pos = 109
; 66: Const mem_free_space = 110
; 67: Const mem_rev_pos = 111
; 68: Const mem_bridge_power = 112
; 69: 
; 70: Symbol swfw = RB0
; 71: Symbol swrev = RB1
; 72: Symbol sck = RB2
; 73: Symbol sda = RB3
; 74: Symbol pos_match = RB4
; 75: Symbol pos_write = RB5
; 76: Symbol eep = RB6
; 77: Symbol max_end = RB7
; 78: Symbol direction = RC0
; 79: Symbol clk = RC1
; 80: Symbol ena = RC2
; 81: Symbol zero = RC3
; 82: Symbol ec1 = RC4
; 83: Symbol ec2 = RC5
; 84: Symbol ecsw = RC6
; 85: Symbol pgm = RC7
; 86: 
; 87: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 88: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 89: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 90: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 91: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 92: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 93: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 94: Gosub init_values
	BSF PCLATH,3
	CALL L0011
; 95: value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 96: version = 1
	BSF 0x45,3
; 97: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 98: onoff = 1
	BSF 0x45,1
; 99: Gosub relays
	BSF PCLATH,3
	CALL L0009
; 100: program_set = 1
	MOVLW 0x01
	MOVWF 0x43
; 101: main:
L0001:
; 102: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0016
; 103: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 104: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 105: 	Endif
L0016:
; 106: 
; 107: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 108: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4D,W
	SUBWF 0x58,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0017
; 109: 		onoff = 0
	BCF 0x45,1
; 110: 		Gosub relays
	BSF PCLATH,3
	CALL L0009
; 111: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 112: 		new_pos = bus_pos
	MOVF 0x4D,W
	MOVWF 0x4C
; 113: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0007
; 114: 		value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 115: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 116: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 117: 		onoff = 1
	BSF 0x45,1
; 118: 	Else
	BCF PCLATH,3
	GOTO L0018
L0017:
; 119: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0019
; 120: 			If manual_pos <> old_manual_pos Then
	MOVF 0x42,W
	SUBWF 0x53,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0020
; 121: 				onoff = 0
	BCF 0x45,1
; 122: 				Gosub relays
	BSF PCLATH,3
	CALL L0009
; 123: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 124: 				old_manual_pos = manual_pos
	MOVF 0x42,W
	MOVWF 0x53
; 125: 				new_pos = manual_pos
	MOVF 0x42,W
	MOVWF 0x4C
; 126: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0007
; 127: 				value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 128: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 129: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 130: 				onoff = 1
	BSF 0x45,1
; 131: 			Endif
L0020:
; 132: 		Endif
L0019:
; 133: 	Endif
L0018:
; 134: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 135: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 136: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 137: End
	BCF PCLATH,3
L0021:	GOTO L0021
; 138: 
; 139: 
; 140: get_new_position:
L0002:
; 141: 	value = bus_pos  'remember the position
	MOVF 0x4D,W
	MOVWF 0x31
; 142: 	If pos_write = 1 Then
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0022
; 143: 		If old_pos_write = 0 Then  'react only once on rising edge
	BCF PCLATH,3
	BTFSC 0x45,4
	GOTO L0023
; 144: 			old_pos_write = 1
	BSF 0x45,4
; 145: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x31
; 146: 			Select Case value
; 147: 			Case 0, 63  'zero position is desired
	MOVF 0x31,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0026
	BCF PCLATH,3
	GOTO L0025
L0026:
	MOVF 0x31,W
	SUBLW 0x3F
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
L0025:
; 148: 				value = 0
	CLRF 0x31
; 149: 			Case Else
	BCF PCLATH,3
	GOTO L0027
L0024:
; 150: 				If value > max_pos Then  'this is not allowed
	MOVF 0x31,W
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0028
; 151: 					value = bus_pos  'put it back to old situation
	MOVF 0x4D,W
	MOVWF 0x31
; 152: 				Endif
L0028:
; 153: 			EndSelect
L0027:
; 154: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 155: 			If value = bus_pos Then  'no other position is set, just a res[onse on pos_write is required
	MOVF 0x31,W
	SUBWF 0x4D,W
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 156: 				pos_match = 1
	BSF 0x06,4
; 157: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 158: 				pos_match = 0
	BCF 0x06,4
; 159: 			Endif
L0029:
; 160: 		Endif
L0023:
; 161: 	Else
	BCF PCLATH,3
	GOTO L0030
L0022:
; 162: 		old_pos_write = 0
	BCF 0x45,4
; 163: 	Endif
L0030:
; 164: 	bus_pos = value  'now take over the desired position
	MOVF 0x31,W
	MOVWF 0x4D
; 165: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 166: 	Select Case result
; 167: 	Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0031
; 168: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 169: 			encoder_count = encoder_count + 1
	MOVF 0x4A,W
	ADDLW 0x01
	MOVWF 0x4A
; 170: 		Else
	BCF PCLATH,3
	GOTO L0033
L0032:
; 171: 			encoder_count = 0
	CLRF 0x4A
; 172: 			If manual_pos < max_pos Then
	MOVF 0x35,W
	SUBWF 0x42,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 173: 				manual_pos = manual_pos + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 174: 			Else
	BCF PCLATH,3
	GOTO L0035
L0034:
; 175: 				manual_pos = 0
	CLRF 0x42
; 176: 			Endif
L0035:
; 177: 			value = manual_pos
	MOVF 0x42,W
	MOVWF 0x31
; 178: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 179: 		Endif
L0033:
; 180: 	Case 2
	BCF PCLATH,3
	GOTO L0036
L0031:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0037
; 181: 		If encoder_count > 0 Then
	MOVF 0x4A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0038
; 182: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4A,W
	MOVWF 0x4A
; 183: 		Else
	BCF PCLATH,3
	GOTO L0039
L0038:
; 184: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4A
; 185: 			If manual_pos > 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0040
; 186: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 187: 			Else
	BCF PCLATH,3
	GOTO L0041
L0040:
; 188: 				manual_pos = max_pos
	MOVF 0x35,W
	MOVWF 0x42
; 189: 			Endif
L0041:
; 190: 			value = manual_pos
	MOVF 0x42,W
	MOVWF 0x31
; 191: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 192: 		Endif
L0039:
; 193: 	Case Else
	BCF PCLATH,3
	GOTO L0042
L0037:
; 194: 	EndSelect
L0042:
L0036:
; 195: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 196: 	
; 197: Return
	RETURN
; 198: 
; 199: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 200: '1 = increasing value
; 201: '2 = decreasing value
; 202: '3 = no change
; 203: 		new_encoder = 0
	CLRF 0x49
; 204: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x49,0
	BTFSS 0x07,4
	BCF 0x49,0
; 205: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x49,1
	BTFSS 0x07,5
	BCF 0x49,1
; 206: 		Select Case old_encoder
; 207: 		Case 0
	MOVF 0x52,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0043
; 208: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0044
	BCF PCLATH,3
	CALL L0045
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0044
L0045:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0044:
; 209: 		Case 1
	BCF PCLATH,3
	GOTO L0046
L0043:
	MOVF 0x52,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0047
; 210: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0048
	BCF PCLATH,3
	CALL L0049
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0048
L0049:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0048:
; 211: 		Case 2
	BCF PCLATH,3
	GOTO L0050
L0047:
	MOVF 0x52,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0051
; 212: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0052
	BCF PCLATH,3
	CALL L0053
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0052
L0053:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0052:
; 213: 		Case Else
	BCF PCLATH,3
	GOTO L0054
L0051:
; 214: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0055
	BCF PCLATH,3
	CALL L0056
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0055
L0056:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0055:
; 215: 		EndSelect
L0054:
L0050:
L0046:
; 216: 		old_encoder = new_encoder
	MOVF 0x49,W
	MOVWF 0x52
; 217: Return
	RETURN
; 218: 
; 219: 
; 220: adjust_settings:
L0004:
; 221: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 222: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 223: 	onoff = 0
	BCF 0x45,1
; 224: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 225: 	Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 226: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x46,W
	MOVWF 0x36
	MOVF 0x47,W
	MOVWF 0x37
; 227: 	While pgm = 0  'the program switch is still activated
L0057:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0058
; 228: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0059
; 229: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 230: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x43,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0060
; 231: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x43
; 232: 			Endif
L0060:
; 233: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 234: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 235: 			While ecsw = 0  'be sure pushbutton is released
L0061:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0062
; 236: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 237: 			Wend
	BCF PCLATH,3
	GOTO L0061
L0062:
; 238: 		Endif
L0059:
; 239: 		Select Case program_set
; 240: 		Case 1  'correction of current position
	MOVF 0x43,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0063
; 241: 			value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 242: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 243: 			Gosub calc_rotation  'look for the knob to be turned
	BCF PCLATH,3
	CALL L0003
; 244: 			Select Case result
; 245: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 246: 				If new_steps < 60000 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
; 247: 					ena = 1  'motor on
	BSF 0x07,2
; 248: 					new_steps = new_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x37
; 249: 					direction = 1
	BSF 0x07,0
; 250: 					clk = 1  'clock out
	BSF 0x07,1
; 251: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 252: 					clk = 0
	BCF 0x07,1
; 253: 				Endif
L0065:
; 254: 			Case 2
	BCF PCLATH,3
	GOTO L0066
L0064:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
; 255: 				If new_steps > 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0068
; 256: 					ena = 1  'motor on
	BSF 0x07,2
; 257: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 258: 					direction = 0
	BCF 0x07,0
; 259: 					clk = 1  'clock out
	BSF 0x07,1
; 260: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 261: 					clk = 0
	BCF 0x07,1
; 262: 				Endif
L0068:
; 263: 			Case Else
	BCF PCLATH,3
	GOTO L0069
L0067:
; 264: 			EndSelect
L0069:
L0066:
; 265: 			Select Case act_pos
; 266: 			Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0070
; 267: 				steps_set = 1
	BSF 0x45,0
; 268: 			Case 2
	BCF PCLATH,3
	GOTO L0071
L0070:
	MOVF 0x30,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0072
; 269: 				If steps_set = 1 Then
	BCF PCLATH,3
	BTFSS 0x45,0
	GOTO L0073
; 270: 					If eep = 1 Then  'iF jumper eep1 is set to on
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0074
; 271: 											'routine to set steps for pos 3 to max_pos
; 272: 						value = 88
	MOVLW 0x58
	MOVWF 0x31
; 273: 						Gosub i2c_display  'show 88 to indicate adjusting is proceeded
	BCF PCLATH,3
	CALL L0005
; 274: 						If act_steps <> new_steps Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0075
; 275: 							Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 276: 						Endif
L0075:
; 277: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 278: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x4C
; 279: 						Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 280: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x33
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x34
; 281: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x30
L0076:
	MOVF 0x30,W
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0077
; 282: 							new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x33,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x37
; 283: 							Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 284: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x30,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0076
L0077:
; 285: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 286: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x30
; 287: 						steps_set = 0  'do this routine only once
	BCF 0x45,0
; 288: 					Endif
L0074:
; 289: 				Endif
L0073:
; 290: 			Case Else
	BCF PCLATH,3
	GOTO L0078
L0072:
; 291: 				steps_set = 0
	BCF 0x45,0
; 292: 			EndSelect  'act_pos
L0078:
L0071:
; 293: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0079
L0063:
	MOVF 0x43,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 294: 			steps_set = 0
	BCF 0x45,0
; 295: 			ena = 0  'shut off motor
	BCF 0x07,2
; 296: 			value = max_pos
	MOVF 0x35,W
	MOVWF 0x31
; 297: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 298: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 299: 			Select Case result
; 300: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 301: 				If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0082
; 302: 					max_pos = max_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 303: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0083:	BTFSC EECON1,WR
	GOTO L0083
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 304: 				Endif
L0082:
; 305: 			Case 2
	BCF PCLATH,3
	GOTO L0084
L0081:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 306: 				If max_pos > 4 Then  'minum 4 positions
	MOVF 0x35,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0086
; 307: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 308: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0087:	BTFSC EECON1,WR
	GOTO L0087
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 309: 				Endif
L0086:
; 310: 			Case Else
	BCF PCLATH,3
	GOTO L0088
L0085:
; 311: 			EndSelect
L0088:
L0084:
; 312: 		Case 3  'setting control type
	BCF PCLATH,3
	GOTO L0089
L0080:
	MOVF 0x43,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0090
; 313: 			steps_set = 0
	BCF 0x45,0
; 314: 			ena = 0  'shut off motor
	BCF 0x07,2
; 315: 			If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0091
; 316: 				ctrl_type = 0
	CLRF 0x32
; 317: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0092:	BTFSC EECON1,WR
	GOTO L0092
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 318: 			Endif
L0091:
; 319: 			value = ctrl_type
	MOVF 0x32,W
	MOVWF 0x31
; 320: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 321: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 322: 			Select Case result
; 323: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0093
; 324: 				If ctrl_type < 6 Then
	MOVLW 0x06
	SUBWF 0x32,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0094
; 325: 					ctrl_type = ctrl_type + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 326: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0095:	BTFSC EECON1,WR
	GOTO L0095
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 327: 				Endif
L0094:
; 328: 			Case 2
	BCF PCLATH,3
	GOTO L0096
L0093:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 329: 				If ctrl_type > 0 Then
	MOVF 0x32,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0098
; 330: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 331: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0099:	BTFSC EECON1,WR
	GOTO L0099
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 332: 				Endif
L0098:
; 333: 			Case Else
	BCF PCLATH,3
	GOTO L0100
L0097:
; 334: 			EndSelect
L0100:
L0096:
; 335: 		Case 4  'setting of speed interval Minimum
	BCF PCLATH,3
	GOTO L0101
L0090:
	MOVF 0x43,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0102
; 336: 					'setting will be done in multiple of 256 uSecs
; 337: 					'minimum is 2 and maximum is 99 (is real slow)
; 338: 			steps_set = 0
	BCF 0x45,0
; 339: 			ena = 0  'shut off motor
	BCF 0x07,2
; 340: 			value = speed_min.HB
	MOVF 0x3D,W
	MOVWF 0x31
; 341: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 342: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 343: 			Select Case result
; 344: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 345: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0104
; 346: 					speed_min = speed_min + 256
	MOVF 0x3C,W
	ADDLW 0x00
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3D
; 347: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 348: 				Endif
L0104:
; 349: 			Case 2
	BCF PCLATH,3
	GOTO L0106
L0103:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 350: 				If speed_min > speed_max Then
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 351: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 352: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0109:	BTFSC EECON1,WR
	GOTO L0109
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 353: 				Endif
L0108:
; 354: 			Case Else
	BCF PCLATH,3
	GOTO L0110
L0107:
; 355: 			EndSelect
L0110:
L0106:
; 356: 		Case 5  'setting of speed interval Maximum
	BCF PCLATH,3
	GOTO L0111
L0102:
	MOVF 0x43,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0112
; 357: 					'setting will be done in multiple of 256 uSecs
; 358: 					'minimum is 1 and maximum is 99 (is real slow)
; 359: 			steps_set = 0
	BCF 0x45,0
; 360: 			ena = 0  'shut off motor
	BCF 0x07,2
; 361: 			value = speed_max.HB
	MOVF 0x3B,W
	MOVWF 0x31
; 362: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 363: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 364: 			Select Case result
; 365: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0113
; 366: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3D,W
	SUBWF 0x3B,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0114
; 367: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x3B,W
	ADDLW 0x01
	MOVWF 0x3B
; 368: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0115:	BTFSC EECON1,WR
	GOTO L0115
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 369: 				Endif
L0114:
; 370: 			Case 2
	BCF PCLATH,3
	GOTO L0116
L0113:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0117
; 371: 				If speed_max.HB > 1 Then
	MOVF 0x3B,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0118
; 372: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 373: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0119:	BTFSC EECON1,WR
	GOTO L0119
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 374: 				Endif
L0118:
; 375: 			Case Else
	BCF PCLATH,3
	GOTO L0120
L0117:
; 376: 			EndSelect
L0120:
L0116:
; 377: 		Case 6  'setting of ramp up and down speed
	BCF PCLATH,3
	GOTO L0121
L0112:
	MOVF 0x43,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0122
; 378: 					'speed will be the value that speed will be changed every step up and down
; 379: 			steps_set = 0
	BCF 0x45,0
; 380: 			ena = 0  'shut off motor
	BCF 0x07,2
; 381: 			value = speed_step
	MOVF 0x44,W
	MOVWF 0x31
; 382: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 383: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 384: 			Select Case result
; 385: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0123
; 386: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x44,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0124
; 387: 					speed_step = speed_step + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 388: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0125:	BTFSC EECON1,WR
	GOTO L0125
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 389: 				Endif
L0124:
; 390: 			Case 2
	BCF PCLATH,3
	GOTO L0126
L0123:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0127
; 391: 				If speed_step > 1 Then
	MOVF 0x44,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0128
; 392: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 393: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0129:	BTFSC EECON1,WR
	GOTO L0129
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 394: 				Endif
L0128:
; 395: 			Case Else
	BCF PCLATH,3
	GOTO L0130
L0127:
; 396: 			EndSelect
L0130:
L0126:
; 397: 	
; 398: 		Case 7  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0131
L0122:
	MOVF 0x43,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0132
; 399: 			steps_set = 0
	BCF 0x45,0
; 400: 			ena = 0  'shut off motor
	BCF 0x07,2
; 401: 			If free_space_steps > 250 Then
	MOVF 0x41,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0133
; 402: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x41
; 403: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0134:	BTFSC EECON1,WR
	GOTO L0134
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 404: 			Endif
L0133:
; 405: 			value = free_space_steps
	MOVF 0x41,W
	MOVWF 0x31
; 406: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 407: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 408: 			Select Case result
; 409: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 410: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x41,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0136
; 411: 					free_space_steps = free_space_steps + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 412: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 413: 				Endif
L0136:
; 414: 			Case 2
	BCF PCLATH,3
	GOTO L0138
L0135:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0139
; 415: 				If free_space_steps > 0 Then
	MOVF 0x41,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0140
; 416: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 417: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0141:	BTFSC EECON1,WR
	GOTO L0141
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 418: 				Endif
L0140:
; 419: 			Case Else
	BCF PCLATH,3
	GOTO L0142
L0139:
; 420: 			EndSelect
L0142:
L0138:
; 421: 		Case 8  'setting of first position for reverse railpower
	BCF PCLATH,3
	GOTO L0143
L0132:
	MOVF 0x43,W
	SUBLW 0x08
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
; 422: 			Read mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 423: 			If rev_pos > max_pos Then
	MOVF 0x40,W
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0145
; 424: 				rev_pos = max_pos
	MOVF 0x35,W
	MOVWF 0x40
; 425: 				Write mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0146:	BTFSC EECON1,WR
	GOTO L0146
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 426: 			Endif
L0145:
; 427: 			value = rev_pos
	MOVF 0x40,W
	MOVWF 0x31
; 428: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 429: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 430: 			Select Case result
; 431: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0147
; 432: 				If rev_pos < max_pos Then  'no more then max_pos allowed
	MOVF 0x35,W
	SUBWF 0x40,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0148
; 433: 					rev_pos = rev_pos + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 434: 					Write mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0149:	BTFSC EECON1,WR
	GOTO L0149
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 435: 				Endif
L0148:
; 436: 			Case 2
	BCF PCLATH,3
	GOTO L0150
L0147:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
; 437: 				If rev_pos > 1 Then
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0152
; 438: 					rev_pos = rev_pos - 1
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 439: 					Write mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0153:	BTFSC EECON1,WR
	GOTO L0153
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 440: 				Endif
L0152:
; 441: 			Case Else
	BCF PCLATH,3
	GOTO L0154
L0151:
; 442: 			EndSelect
L0154:
L0150:
; 443: 		Case Else  'setting if power should be on or off while bridge is moving (0 = off)
	BCF PCLATH,3
	GOTO L0155
L0144:
; 444: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4B
; 445: 			If bridge_power > 1 Then
	MOVF 0x4B,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0156
; 446: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x4B
; 447: 			Endif
L0156:
; 448: 			value = bridge_power
	MOVF 0x4B,W
	MOVWF 0x31
; 449: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 450: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 451: 			Select Case result
; 452: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 453: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x4B
; 454: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0158:	BTFSC EECON1,WR
	GOTO L0158
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 455: 			Case 2
	BCF PCLATH,3
	GOTO L0159
L0157:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 456: 				bridge_power = 2
	MOVLW 0x02
	MOVWF 0x4B
; 457: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 458: 			Case Else
	BCF PCLATH,3
	GOTO L0162
L0160:
; 459: 			EndSelect
L0162:
L0159:
; 460: 		EndSelect
L0155:
L0143:
L0131:
L0121:
L0111:
L0101:
L0089:
L0079:
; 461: 	Wend
	BCF PCLATH,3
	GOTO L0057
L0058:
; 462: 	ena = 0  'shut off motor
	BCF 0x07,2
; 463: 		'***************   now check if changes have to BE written in eeprom
; 464: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0163
; 465: 		Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 466: 	Endif
L0163:
; 467: 	value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 468: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 469: 	onoff = 1
	BSF 0x45,1
; 470: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 471: Return
	RETURN
; 472: 
; 473: i2c_display:
L0005:
; 474: 	disp1_val = value
	MOVF 0x31,W
	MOVWF 0x48
; 475: 	disp1_val = disp1_val Mod 10
	MOVF 0x48,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x48
; 476: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x48,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0164
	BCF PCLATH,3
	CALL L0165
	MOVWF 0x48
	BCF PCLATH,3
	GOTO L0164
L0165:
	MOVLW 0x06
	MOVWF PCLATH
	MOVF 0x48,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0164:
; 477: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x48,7
	BTFSS 0x07,7
	BCF 0x48,7
; 478: 	disp2_val = value
	MOVF 0x31,W
	MOVWF 0x50
; 479: 	disp2_val = disp2_val / 10
	MOVF 0x50,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x50
; 480: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x50,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0166
	BCF PCLATH,3
	CALL L0167
	MOVWF 0x50
	BCF PCLATH,3
	GOTO L0166
L0167:
	MOVLW 0x06
	MOVWF PCLATH
	MOVF 0x50,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0166:
; 481: 	disp2_val.7 = version
	BTFSC 0x45,3
	BSF 0x50,7
	BTFSS 0x45,3
	BCF 0x50,7
; 482: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 483: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 484: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x48,W
	CALL IC01
; 485: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 486: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 487: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 488: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x50,W
	CALL IC01
; 489: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 490: Return
	RETURN
; 491: 
; 492: i2c_display_pgm:
L0006:
; 493: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x43,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0168
	BCF PCLATH,3
	CALL L0169
	MOVWF 0x48
	BCF PCLATH,3
	GOTO L0168
L0169:
	MOVLW 0x06
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0168:
; 494: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 495: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 496: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x48,W
	CALL IC01
; 497: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 498: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 499: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 500: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 501: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 502: Return
	RETURN
; 503: 
; 504: stepmotor:
L0007:
; 505: 	speed = 0
	CLRF 0x4E
	CLRF 0x4F
; 506: 	Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 507: 	If new_steps = 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0170
; 508: 		direction = 0
	BCF 0x07,0
; 509: 		ena = 1  'set anable on
	BSF 0x07,2
; 510: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 511: 		While zero = 1  'turn motor until zero switch is activated
L0171:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0172
; 512: 			clk = 1  'clock out
	BSF 0x07,1
; 513: 			WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 514: 			clk = 0
	BCF 0x07,1
; 515: 			WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 516: 		Wend
	BCF PCLATH,3
	GOTO L0171
L0172:
; 517: 		value = 0  'first condierate that extra round is not allowed
	CLRF 0x31
; 518: 		Select Case ctrl_type
; 519: 		Case 2, 3  'check if extra round is allowed
	MOVF 0x32,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0175
	BCF PCLATH,3
	GOTO L0174
L0175:
	MOVF 0x32,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0173
L0174:
; 520: 			Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 521: 			Select Case turn_counter
; 522: 			Case > 126  'check if shortest way is allowed
	MOVF 0x3F,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0176
; 523: 				turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 524: 				Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 525: 				value = 1  'now it is allowed
	MOVLW 0x01
	MOVWF 0x31
; 526: 			Case < 126
	BCF PCLATH,3
	GOTO L0178
L0176:
	MOVLW 0x7E
	SUBWF 0x3F,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0179
; 527: 				Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0180:	BTFSC EECON1,WR
	GOTO L0180
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 528: 			Case Else
	BCF PCLATH,3
	GOTO L0181
L0179:
; 529: 			EndSelect
L0181:
L0178:
; 530: 		Case 4, 5  'type with contact sliders, no twisting cables
	BCF PCLATH,3
	GOTO L0182
L0173:
	MOVF 0x32,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0185
	BCF PCLATH,3
	GOTO L0184
L0185:
	MOVF 0x32,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0183
L0184:
; 531: 			value = 1
	MOVLW 0x01
	MOVWF 0x31
; 532: 		Case Else  'no short way possible
	BCF PCLATH,3
	GOTO L0186
L0183:
; 533: 		EndSelect
L0186:
L0182:
; 534: 		If value = 1 Then
	MOVF 0x31,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 535: 			one_round = 0  'start counting one round steps
	CLRF 0x38
	CLRF 0x39
; 536: 			ena = 1  'set anable on
	BSF 0x07,2
; 537: 			While zero = 0  'turn motor until zero switch is DISactivated
L0188:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0189
; 538: 				clk = 1  'clock out
	BSF 0x07,1
; 539: 				WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 540: 				clk = 0
	BCF 0x07,1
; 541: 				one_round = one_round + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x39
; 542: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 543: 			Wend
	BCF PCLATH,3
	GOTO L0188
L0189:
; 544: 			For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x31
L0190:
	MOVF 0x31,W
	SUBLW 0x64
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0191
; 545: 				clk = 1  'clock out
	BSF 0x07,1
; 546: 				WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 547: 				clk = 0
	BCF 0x07,1
; 548: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 549: 				one_round = one_round + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x39
; 550: 			Next value
	MOVLW 0x01
	ADDWF 0x31,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0190
L0191:
; 551: 			While zero = 1  'turn motor until zero switch is activated
L0192:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0193
; 552: 				clk = 1  'clock out
	BSF 0x07,1
; 553: 				WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 554: 				clk = 0
	BCF 0x07,1
; 555: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 556: 				one_round = one_round + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x39
; 557: 			Wend
	BCF PCLATH,3
	GOTO L0192
L0193:
; 558: 			one_round_half = one_round / 2
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x56
	MOVF R0H,W
	MOVWF 0x57
; 559: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0194:	BTFSC EECON1,WR
	GOTO L0194
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 560: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 561: 			act_pos = 0
	CLRF 0x30
; 562: 		Endif
L0187:
; 563: 		Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0196:	BTFSC EECON1,WR
	GOTO L0196
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 564: 		ena = 0  'set anable off
	BCF 0x07,2
; 565: 	Else  'this is the normal position sequence
	BSF PCLATH,3
	GOTO L0197
L0170:
; 566: 		steps = 0
	CLRF 0x33
	CLRF 0x34
; 567: 		If new_steps > act_steps Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0198
; 568: 			steps = new_steps - act_steps
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x33
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x34
; 569: 			direction = 1
	BSF 0x07,0
; 570: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x56,W
	MOVWF R1L
	MOVF 0x57,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0199
; 571: 				Select Case ctrl_type
; 572: 				Case 2, 3
	MOVF 0x32,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0202
	BSF PCLATH,3
	GOTO L0201
L0202:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0200
L0201:
; 573: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 574: 					Select Case turn_counter
; 575: 					Case > 126  'check if shortest way is allowed
	MOVF 0x3F,W
	SUBLW 0x7E
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0203
; 576: 						turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 577: 						steps = one_round - steps  'go shortest way
	MOVF 0x33,W
	SUBWF 0x38,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x34
; 578: 						direction = 0  'change  direction
	BCF 0x07,0
; 579: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0204:	BTFSC EECON1,WR
	GOTO L0204
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 580: 					Case < 126
	BSF PCLATH,3
	GOTO L0205
L0203:
	MOVLW 0x7E
	SUBWF 0x3F,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0206
; 581: 							Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0207:	BTFSC EECON1,WR
	GOTO L0207
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 582: 					Case Else
	BSF PCLATH,3
	GOTO L0208
L0206:
; 583: 					EndSelect
L0208:
L0205:
; 584: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0209
L0200:
	MOVF 0x32,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0212
	BSF PCLATH,3
	GOTO L0211
L0212:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
L0211:
; 585: 					steps = one_round - steps
	MOVF 0x33,W
	SUBWF 0x38,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x34
; 586: 					direction = 0
	BCF 0x07,0
; 587: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0213
L0210:
; 588: 				EndSelect
L0213:
L0209:
; 589: 			Endif
L0199:
; 590: 		Else
	BSF PCLATH,3
	GOTO L0214
L0198:
; 591: 			steps = act_steps - new_steps
	MOVF 0x36,W
	SUBWF 0x46,W
	MOVWF 0x33
	MOVF 0x37,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x34
; 592: 			direction = 0
	BCF 0x07,0
; 593: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x56,W
	MOVWF R1L
	MOVF 0x57,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0215
; 594: 				Select Case ctrl_type
; 595: 				Case 2, 3  'cable connected bridges
	MOVF 0x32,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0218
	BSF PCLATH,3
	GOTO L0217
L0218:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0216
L0217:
; 596: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 597: 					Select Case turn_counter
; 598: 					Case < 130
	MOVLW 0x82
	SUBWF 0x3F,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0219
; 599: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
; 600: 						steps = one_round - steps  'go shortest way
	MOVF 0x33,W
	SUBWF 0x38,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x34
; 601: 						direction = 1  'change direction
	BSF 0x07,0
; 602: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0220:	BTFSC EECON1,WR
	GOTO L0220
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 603: 					Case > 130
	BSF PCLATH,3
	GOTO L0221
L0219:
	MOVF 0x3F,W
	SUBLW 0x82
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0222
; 604: 						Write mem_turn_counter, 130
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x82
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0223:	BTFSC EECON1,WR
	GOTO L0223
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 605: 					Case Else
	BSF PCLATH,3
	GOTO L0224
L0222:
; 606: 					EndSelect
L0224:
L0221:
; 607: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0225
L0216:
	MOVF 0x32,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0228
	BSF PCLATH,3
	GOTO L0227
L0228:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0226
L0227:
; 608: 					steps = one_round - steps
	MOVF 0x33,W
	SUBWF 0x38,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x34
; 609: 					direction = 1
	BSF 0x07,0
; 610: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0229
L0226:
; 611: 				EndSelect
L0229:
L0225:
; 612: 			Endif
L0215:
; 613: 		Endif
L0214:
; 614: 		If steps > 0 Then  'motor must be activated
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0230
; 615: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0231
; 616: 				steps = steps + free_space_steps
	MOVF 0x33,W
	ADDWF 0x41,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x34
; 617: 			Endif
L0231:
; 618: 			ramp_up = 1
	BSF 0x45,2
; 619: 			ramp_down_point = 0
	CLRF 0x54
	CLRF 0x55
; 620: 			half_steps = steps / 2
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x59
	MOVF R0H,W
	MOVWF 0x5A
; 621: 			speed = speed_min
	MOVF 0x3C,W
	MOVWF 0x4E
	MOVF 0x3D,W
	MOVWF 0x4F
; 622: 			ena = 1  'set anable on
	BSF 0x07,2
; 623: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 624: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0232:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
; 625: 				If max_end = 0 Then
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0234
; 626: 					Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0014
; 627: 				Endif
L0234:
; 628: 				clk = 1  'clock out
	BSF 0x07,1
; 629: 				WaitUs speed
	MOVF 0x4E,W
	MOVWF R4L
	MOVF 0x4F,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 630: 				clk = 0
	BCF 0x07,1
; 631: 				Gosub speed_calc
	BSF PCLATH,3
	CALL L0008
; 632: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 633: 			Wend
	BSF PCLATH,3
	GOTO L0232
L0233:
; 634: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 635: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0235
; 636: 				steps = free_space_steps
	MOVF 0x41,W
	MOVWF 0x33
	CLRF 0x34
; 637: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 638: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0236:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0237
; 639: 					If max_end = 0 Then
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0238
; 640: 						Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0014
; 641: 					Endif
L0238:
; 642: 					clk = 1  'clock out
	BSF 0x07,1
; 643: 					WaitUs speed_min
	MOVF 0x3C,W
	MOVWF R4L
	MOVF 0x3D,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 644: 					clk = 0
	BCF 0x07,1
; 645: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 646: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 647: 				Wend
	BSF PCLATH,3
	GOTO L0236
L0237:
; 648: 			Endif
L0235:
; 649: 			ena = 0  'enable off
	BCF 0x07,2
; 650: 		Endif
L0230:
; 651: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 652: 	Endif
L0197:
; 653: 	act_pos = new_pos
	MOVF 0x4C,W
	MOVWF 0x30
; 654: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0239:	BTFSC EECON1,WR
	GOTO L0239
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 655: 	bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x4D
; 656: 	old_bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x58
; 657: 	manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x42
; 658: 	old_manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x53
; 659: Return
	RETURN
; 660: 
; 661: 
; 662: speed_calc:
L0008:
; 663: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x59,W
	MOVWF R1L
	MOVF 0x5A,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0240
; 664: 		ramp_up = 0
	BCF 0x45,2
; 665: 	Endif
L0240:
; 666: 	If ramp_up = 1 Then  'we were supposed to ramp up
	BSF PCLATH,3
	BTFSS 0x45,2
	GOTO L0241
; 667: 		If speed > speed_max Then
	MOVF 0x4E,W
	MOVWF R0L
	MOVF 0x4F,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0242
; 668: 			speed = speed - speed_step
	MOVF 0x44,W
	SUBWF 0x4E,W
	MOVWF 0x4E
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4F,W
	MOVWF 0x4F
; 669: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x54,W
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x55,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x55
; 670: 		Else
	BSF PCLATH,3
	GOTO L0243
L0242:
; 671: 			ramp_up = 0
	BCF 0x45,2
; 672: 		Endif
L0243:
; 673: 	Else
	BSF PCLATH,3
	GOTO L0244
L0241:
; 674: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x54,W
	MOVWF R1L
	MOVF 0x55,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0245
; 675: 			If speed < speed_min Then
	MOVF 0x4E,W
	MOVWF R0L
	MOVF 0x4F,W
	MOVWF R0H
	MOVF 0x3C,W
	MOVWF R1L
	MOVF 0x3D,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0246
; 676: 				speed = speed + speed_step
	MOVF 0x4E,W
	ADDWF 0x44,W
	MOVWF 0x4E
	MOVF 0x4F,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4F
; 677: 			Endif
L0246:
; 678: 		Endif
L0245:
; 679: 	Endif
L0244:
; 680: Return
	RETURN
; 681: 
; 682: 
; 683: relays:
L0009:
; 684: 	If bridge_power = 0 Then
	MOVF 0x4B,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0247
; 685: 		If onoff = 1 Then
	BSF PCLATH,3
	BTFSS 0x45,1
	GOTO L0248
; 686: 			Select Case ctrl_type
; 687: 			Case 1, 3, 5, 6
	MOVF 0x32,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0251
	BSF PCLATH,3
	GOTO L0250
L0251:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0252
	BSF PCLATH,3
	GOTO L0250
L0252:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
	BSF PCLATH,3
	GOTO L0250
L0253:
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0249
L0250:
; 688: 				swfw = 0
	BCF 0x06,0
; 689: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 690: 				swrev = 1
	BSF 0x06,1
; 691: 			Case Else
	BSF PCLATH,3
	GOTO L0254
L0249:
; 692: 				If act_pos < rev_pos Then  'select polarity rails on bridge
	MOVF 0x40,W
	SUBWF 0x30,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0255
; 693: 					swfw = 1
	BSF 0x06,0
; 694: 					WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 695: 					swrev = 0
	BCF 0x06,1
; 696: 				Else
	BSF PCLATH,3
	GOTO L0256
L0255:
; 697: 					swfw = 0
	BCF 0x06,0
; 698: 					WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 699: 					swrev = 1
	BSF 0x06,1
; 700: 				Endif
L0256:
; 701: 			EndSelect
L0254:
; 702: 		Else
	BSF PCLATH,3
	GOTO L0257
L0248:
; 703: 			swfw = 0
	BCF 0x06,0
; 704: 			swrev = 0
	BCF 0x06,1
; 705: 		Endif
L0257:
; 706: 	Else  'bridge remains under power
	BSF PCLATH,3
	GOTO L0258
L0247:
; 707: 		If act_pos < rev_pos Then
	MOVF 0x40,W
	SUBWF 0x30,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0259
; 708: 			swfw = 1
	BSF 0x06,0
; 709: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 710: 			swrev = 0
	BCF 0x06,1
; 711: 		Else
	BSF PCLATH,3
	GOTO L0260
L0259:
; 712: 			swfw = 0
	BCF 0x06,0
; 713: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 714: 			swrev = 1
	BSF 0x06,1
; 715: 		Endif
L0260:
; 716: 	Endif
L0258:
; 717: Return
	RETURN
; 718: 
; 719: 
; 720: init_eeprom:
L0010:
; 721: 	If pgm = 0 Then  'special for my own fiddle yard
	BSF PCLATH,3
	BTFSC 0x07,7
	GOTO L0261
; 722: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x36
	CLRF 0x37
; 723: 		For act_pos = 1 To 12
	MOVLW 0x01
	MOVWF 0x30
L0262:
	MOVF 0x30,W
	SUBLW 0x0C
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0263
; 724: 			Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 725: 			new_steps = new_steps + 4300
	MOVF 0x36,W
	ADDLW 0xCC
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x37
; 726: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x30,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0262
L0263:
; 727: 		Write mem_max_pos, 12
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0C
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0264:	BTFSC EECON1,WR
	GOTO L0264
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 728: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 729: 	Else
	BSF PCLATH,3
	GOTO L0265
L0261:
; 730: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 731: 		For act_pos = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x30
L0266:
	MOVF 0x30,W
	SUBWF 0x35,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0267
; 732: 			steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVF 0x35,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x33
	MOVF R0H,W
	MOVWF 0x34
; 733: 			new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x33,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x37
; 734: 			Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 735: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x30,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0266
L0267:
; 736: 	Endif
L0265:
; 737: 	free_space_steps = 0
	CLRF 0x41
; 738: 	Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0268:	BTFSC EECON1,WR
	GOTO L0268
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 739: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x38
	MOVLW 0x1F
	MOVWF 0x39
; 740: 	Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0269:	BTFSC EECON1,WR
	GOTO L0269
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 741: 	Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0270:	BTFSC EECON1,WR
	GOTO L0270
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 742: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 743: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0271:	BTFSC EECON1,WR
	GOTO L0271
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 744: Return
	RETURN
; 745: 
; 746: init_values:
L0011:
; 747: 	value = 46  'version number
	MOVLW 0x2E
	MOVWF 0x31
; 748: 	version = 0  'decimal point in display on
	BCF 0x45,3
; 749: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 750: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 751: 	version = 1  'decimal point in display off
	BSF 0x45,3
; 752: 	encoder_count = 0
	CLRF 0x4A
; 753: 	speed_min = 0
	CLRF 0x3C
	CLRF 0x3D
; 754: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 755: 	If speed_min.HB > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0272
; 756: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3D
; 757: 	Else
	BSF PCLATH,3
	GOTO L0273
L0272:
; 758: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0274
; 759: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3D
; 760: 		Endif
L0274:
; 761: 	Endif
L0273:
; 762: 	speed_max = 0
	CLRF 0x3A
	CLRF 0x3B
; 763: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 764: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x3B,W
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0275
; 765: 		speed_max.HB = speed_min.HB
	MOVF 0x3D,W
	MOVWF 0x3B
; 766: 	Else
	BSF PCLATH,3
	GOTO L0276
L0275:
; 767: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3B,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0277
; 768: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x3B
; 769: 		Endif
L0277:
; 770: 	Endif
L0276:
; 771: 
; 772: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 773: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 774: 	If one_round = 0 Then
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0278
; 775: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x38
	MOVLW 0x1F
	MOVWF 0x39
; 776: 	Endif
L0278:
; 777: 	If one_round > 60000 Then
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0279
; 778: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x38
	MOVLW 0x1F
	MOVWF 0x39
; 779: 	Endif
L0279:
; 780: 	one_round_half = one_round / 2
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x56
	MOVF R0H,W
	MOVWF 0x57
; 781: 
; 782: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 783: 	If max_pos > 48 Then
	MOVF 0x35,W
	SUBLW 0x30
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0280
; 784: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 785: 	Endif
L0280:
; 786: 	Read mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 787: 	If rev_pos > max_pos Then
	MOVF 0x40,W
	SUBWF 0x35,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0281
; 788: 		rev_pos = max_pos / 2
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x40
; 789: 		Write mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0282:	BTFSC EECON1,WR
	GOTO L0282
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 790: 	Else
	BSF PCLATH,3
	GOTO L0283
L0281:
; 791: 		If rev_pos = 0 Then
	MOVF 0x40,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0284
; 792: 			rev_pos = max_pos / 2
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x40
; 793: 			Write mem_rev_pos, rev_pos
	MOVLW 0x6F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0285:	BTFSC EECON1,WR
	GOTO L0285
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 794: 		Endif
L0284:
; 795: 	Endif
L0283:
; 796: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 797: 	If act_pos > max_pos Then
	MOVF 0x30,W
	SUBWF 0x35,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0286
; 798: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 799: 	Endif
L0286:
; 800: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 801: 	If free_space_steps > 99 Then
	MOVF 0x41,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0287
; 802: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x41
; 803: 	Endif
L0287:
; 804: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 805: 	If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0288
; 806: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 807: 	Endif
L0288:
; 808: 
; 809: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 810: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x3F,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0289
; 811: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x3F
; 812: 	Else
	BSF PCLATH,3
	GOTO L0290
L0289:
; 813: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x3F,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0291
; 814: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x3F
; 815: 		Endif
L0291:
; 816: 	Endif
L0290:
; 817: 	
; 818: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 819: 	If speed_step > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0292
; 820: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x44
; 821: 	Endif
L0292:
; 822: 	
; 823: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0293
; 824: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0010
; 825: 	Endif
L0293:
; 826: 	steps_set = 0
	BCF 0x45,0
; 827: 	new_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x4C
; 828: 	bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x4D
; 829: 	old_bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x58
; 830: 	manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x42
; 831: 	old_manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x53
; 832: Return
	RETURN
; 833: 
; 834: steps_reading:
L0012:
; 835: 	If act_pos = 0 Then
	MOVF 0x30,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0294
; 836: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 837: 	Else
	BSF PCLATH,3
	GOTO L0295
L0294:
; 838: 		eprom_pointer = act_pos + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x51
; 839: 		Read act_pos, act_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 840: 		Read eprom_pointer, act_steps.HB
	MOVF 0x51,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 841: 	Endif
L0295:
; 842: 	If new_pos = 0 Then
	MOVF 0x4C,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0296
; 843: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 844: 	Else
	BSF PCLATH,3
	GOTO L0297
L0296:
; 845: 		eprom_pointer = new_pos + 48
	MOVF 0x4C,W
	ADDLW 0x30
	MOVWF 0x51
; 846: 		Read new_pos, new_steps.LB
	MOVF 0x4C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 847: 		Read eprom_pointer, new_steps.HB
	MOVF 0x51,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 848: 	Endif
L0297:
; 849: Return
	RETURN
; 850: 
; 851: 
; 852: save_steps:
L0013:
; 853: 	eprom_pointer = act_pos + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x51
; 854: 	Write act_pos, new_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0298:	BTFSC EECON1,WR
	GOTO L0298
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 855: 	Write eprom_pointer, new_steps.HB
	MOVF 0x51,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0299:	BTFSC EECON1,WR
	GOTO L0299
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 856: Return
	RETURN
; 857: 
; 858: stop_the_motor:
L0014:
; 859: 	While ecsw = 1
L0300:
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0301
; 860: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 861: 	Wend
	BSF PCLATH,3
	GOTO L0300
L0301:
; 862: Return
	RETURN
; End of program
	BSF PCLATH,3
L0302:	GOTO L0302
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
