; Compiled with: PIC Simulator IDE v6.86
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0 MHz
;
;       The address of 'servo1' (word) (global) is 0x2C
	servo1 EQU 0x2C
;       The address of 'servo2' (word) (global) is 0x2E
	servo2 EQU 0x2E
;       The address of 'servo3' (word) (global) is 0x30
	servo3 EQU 0x30
;       The address of 'servo4' (word) (global) is 0x32
	servo4 EQU 0x32
;       The address of 'dummy' (byte) (global) is 0x34
	dummy EQU 0x34
;       The address of 'channel' (byte) (global) is 0x35
	channel EQU 0x35
;       The address of 'pulse_1msec' (word) (global) is 0x36
	pulse_1msec EQU 0x36
;       The address of 'pulse_2msec' (word) (global) is 0x38
	pulse_2msec EQU 0x38
;       The address of 'pulse_interval' (word) (global) is 0x3A
	pulse_interval EQU 0x3A
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	W_TEMP EQU 0x7F
	STATUS_TEMP EQU 0x7E
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	MOVWF W_TEMP
	SWAPF STATUS,W
	CLRF STATUS
	MOVWF STATUS_TEMP
	CALL L0003
	SWAPF STATUS_TEMP,W
	MOVWF STATUS
	SWAPF W_TEMP,F
	SWAPF W_TEMP,W
	RETFIE
; Begin of program
L0002:
; 1: 
; 2: TRISB = %00000001
	BSF STATUS,RP0
	MOVLW 0x01
	MOVWF 0x06
; 3: TRISA = %11110000
	MOVLW 0xF0
	MOVWF 0x05
	BCF STATUS,RP0
; 4: 
; 5: '------------------------ VARIABELEN DECLARATIES -------------------------
; 6: Dim servo1 As Word
; 7: Dim servo2 As Word
; 8: Dim servo3 As Word
; 9: Dim servo4 As Word
; 10: 'Dim wacht(4) As Byte
; 11: Dim dummy As Byte
; 12: Dim channel As Byte
; 13: Dim pulse_1msec As Word
; 14: Dim pulse_2msec As Word
; 15: Dim pulse_interval As Word
; 16: pulse_1msec = 63772 '0xF91C
	MOVLW 0x1C
	MOVWF 0x36
	MOVLW 0xF9
	MOVWF 0x37
; 17: pulse_2msec = 61772 '0xF14C
	MOVLW 0x4C
	MOVWF 0x38
	MOVLW 0xF1
	MOVWF 0x39
; 18: pulse_interval = 40000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x9C
	MOVWF 0x3B
; 19: 
; 20: '------------------------ CONSTANTEN DECLARATIES --------------------------
; 21: 
; 22: EEPROM 0, 0x4c, 0xf1, 0x4c, 0xf1, 0x4c, 0xf1, 0x4c, 0xf1, 0x1c, 0xf9, 0x1c, 0xf9, 0x1c, 0xf9, 0x1c, 0xf9, 5, 5, 5, 5, 0x34, 0xf5, 0x34, 0xf5, 0x34, 0xf5, 0x34, 0xf5
; 23: 
; 24: 'Je kunt dus geen Word variabelen op deze manier in EEprom zetten.  Je moet de Word waarde in 2 bytes verdelen met de LSByte als eerste.
; 25: 
; 26: '----------------------- INTERRUPT CONFIGURATIE ---------------------------
; 27: T1CON = %00110000 'timer 1 internal clock, prescale = 1:8, stop
	MOVLW 0x30
	MOVWF 0x10
; 28: INTCON.GIE = 1 'enable all un-masked interrupts
	BSF 0x0B,7
; 29: INTCON.T0IE = 0 'stop tmr1
	BCF 0x0B,5
; 30: dummy = 1
	MOVLW 0x01
	MOVWF 0x34
; 31: servo1 = pulse_1msec
	MOVF 0x36,W
	MOVWF 0x2C
	MOVF 0x37,W
	MOVWF 0x2D
; 32: servo2 = pulse_1msec
	MOVF 0x36,W
	MOVWF 0x2E
	MOVF 0x37,W
	MOVWF 0x2F
; 33: servo3 = pulse_1msec
	MOVF 0x36,W
	MOVWF 0x30
	MOVF 0x37,W
	MOVWF 0x31
; 34: servo4 = pulse_1msec
	MOVF 0x36,W
	MOVWF 0x32
	MOVF 0x37,W
	MOVWF 0x33
; 35: channel = 1 'start with correct channel
	MOVLW 0x01
	MOVWF 0x35
; 36: 
; 37: 
; 38: '--------------------------- PROGRAM Mainloop ---------------------------
; 39: Enable 'start interrupts
	BSF INTCON,GIE
; 40: 
; 41: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 42: While dummy = 1 'endless loop
L0004:
	MOVF 0x34,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0005
; 43: 	WaitMs 4 'runtime servo's is 4 seconds, There are 1000 steps to do, so 4ms each step
	MOVLW 0x04
	MOVWF R0L
	CLRF R0H
	CALL W001
; 44: 	If RA4 = 0 Then 'barrier 1 going down
	BTFSC 0x05,4
	GOTO L0006
; 45: 		If servo1 > pulse_2msec Then
	MOVF 0x2C,W
	MOVWF R0L
	MOVF 0x2D,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1H
	MOVF 0x38,W
	CALL C003
	BTFSS STATUS,Z
	GOTO L0007
; 46: 			servo1 = servo1 - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x2D
; 47: 		Endif
L0007:
; 48: 	Else 'barrier going up
	GOTO L0008
L0006:
; 49: 		If servo1 < pulse_1msec Then
	MOVF 0x2C,W
	MOVWF R0L
	MOVF 0x2D,W
	MOVWF R0H
	MOVF 0x37,W
	MOVWF R1H
	MOVF 0x36,W
	CALL C004
	BTFSS STATUS,Z
	GOTO L0009
; 50: 			servo1 = servo1 + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2C
	MOVF 0x2D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x2D
; 51: 		Endif
L0009:
; 52: 	Endif
L0008:
; 53: 	If RA6 = 0 Then 'barrier 2 going down
	BTFSC 0x05,6
	GOTO L0010
; 54: 		If servo2 > pulse_2msec Then
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1H
	MOVF 0x38,W
	CALL C003
	BTFSS STATUS,Z
	GOTO L0011
; 55: 			servo2 = servo1 - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2E
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x2F
; 56: 		Endif
L0011:
; 57: 	Else 'barrier going up
	GOTO L0012
L0010:
; 58: 		If servo2 < pulse_1msec Then
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVF 0x37,W
	MOVWF R1H
	MOVF 0x36,W
	CALL C004
	BTFSS STATUS,Z
	GOTO L0013
; 59: 			servo2 = servo1 + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2E
	MOVF 0x2D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x2F
; 60: 		Endif
L0013:
; 61: 	Endif
L0012:
; 62: 	If RA7 = 0 Then 'barrier 1 going down
	BTFSC 0x05,7
	GOTO L0014
; 63: 		If servo3 > pulse_2msec Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1H
	MOVF 0x38,W
	CALL C003
	BTFSS STATUS,Z
	GOTO L0015
; 64: 			servo3 = servo1 - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x31
; 65: 		Endif
L0015:
; 66: 	Else 'barrier going up
	GOTO L0016
L0014:
; 67: 		If servo3 < pulse_1msec Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x37,W
	MOVWF R1H
	MOVF 0x36,W
	CALL C004
	BTFSS STATUS,Z
	GOTO L0017
; 68: 			servo3 = servo1 + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x30
	MOVF 0x2D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x31
; 69: 		Endif
L0017:
; 70: 	Endif
L0016:
; 71: 	If RB0 = 0 Then 'barrier 1 going down
	BTFSC 0x06,0
	GOTO L0018
; 72: 		If servo4 > pulse_2msec Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1H
	MOVF 0x38,W
	CALL C003
	BTFSS STATUS,Z
	GOTO L0019
; 73: 			servo4 = servo1 - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x33
; 74: 		Endif
L0019:
; 75: 	Else 'barrier going up
	GOTO L0020
L0018:
; 76: 		If servo4 < pulse_1msec Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x37,W
	MOVWF R1H
	MOVF 0x36,W
	CALL C004
	BTFSS STATUS,Z
	GOTO L0021
; 77: 			servo4 = servo1 + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x32
	MOVF 0x2D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x33
; 78: 		Endif
L0021:
; 79: 	Endif
L0020:
; 80: 
; 81: Wend
	GOTO L0004
L0005:
; 82: End
L0022:	GOTO L0022
; 83: 
; 84: On Interrupt
L0003:
; 85: timer1_interrupt:
L0001:
; 86: 
; 87: 	If channel = 1 Then
	MOVF 0x35,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0023
; 88: 		If RB4 = 0 Then 'just start only once
	BTFSC 0x06,4
	GOTO L0024
; 89: 			TMR1L = servo1.LB 'load timer
	MOVF 0x2C,W
	MOVWF 0x0E
; 90: 			TMR1H = servo1.HB
	MOVF 0x2D,W
	MOVWF 0x0F
; 91: 			RB4 = 1 'first servo
	BSF 0x06,4
; 92: 		Else 'timer will generate interrupt after 65536 - Servo(1) pulses
	GOTO L0025
L0024:
; 93: 			channel = 2 'next servo
	MOVLW 0x02
	MOVWF 0x35
; 94: 			RB4 = 0
	BCF 0x06,4
; 95: 		Endif
L0025:
; 96: 	Endif
L0023:
; 97: 	If channel = 2 Then
	MOVF 0x35,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0026
; 98: 		If RB5 = 0 Then
	BTFSC 0x06,5
	GOTO L0027
; 99: 			TMR1L = servo2.LB 'load timer
	MOVF 0x2E,W
	MOVWF 0x0E
; 100: 			TMR1H = servo2.HB
	MOVF 0x2F,W
	MOVWF 0x0F
; 101: 			RB5 = 1
	BSF 0x06,5
; 102: 		Else
	GOTO L0028
L0027:
; 103: 			RB5 = 0
	BCF 0x06,5
; 104: 			channel = 3
	MOVLW 0x03
	MOVWF 0x35
; 105: 		Endif
L0028:
; 106: 	Endif
L0026:
; 107: 	If channel = 3 Then
	MOVF 0x35,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0029
; 108: 		If RB6 = 0 Then
	BTFSC 0x06,6
	GOTO L0030
; 109: 			TMR1L = servo3.LB 'load timer
	MOVF 0x30,W
	MOVWF 0x0E
; 110: 			TMR1H = servo3.HB
	MOVF 0x31,W
	MOVWF 0x0F
; 111: 			RB6 = 1
	BSF 0x06,6
; 112: 		Else
	GOTO L0031
L0030:
; 113: 			RB6 = 0
	BCF 0x06,6
; 114: 			channel = 4
	MOVLW 0x04
	MOVWF 0x35
; 115: 		Endif
L0031:
; 116: 	Endif
L0029:
; 117: 	If channel = 4 Then
	MOVF 0x35,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0032
; 118: 		If RB7 = 0 Then
	BTFSC 0x06,7
	GOTO L0033
; 119: 			TMR1L = servo4.LB 'load timer
	MOVF 0x32,W
	MOVWF 0x0E
; 120: 			TMR1H = servo4.HB
	MOVF 0x33,W
	MOVWF 0x0F
; 121: 			RB7 = 1
	BSF 0x06,7
; 122: 		Else
	GOTO L0034
L0033:
; 123: 			RB7 = 0
	BCF 0x06,7
; 124: 			channel = 5
	MOVLW 0x05
	MOVWF 0x35
; 125: 		Endif
L0034:
; 126: 	Endif
L0032:
; 127: 
; 128: 	If channel = 5 Then
	MOVF 0x35,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0035
; 129: 		TMR1L = pulse_interval.LB 'pause apporx 12 ms before 1st motor will start again.
	MOVF 0x3A,W
	MOVWF 0x0E
; 130: 		TMR1H = pulse_interval.HB
	MOVF 0x3B,W
	MOVWF 0x0F
; 131: 		channel = 1
	MOVLW 0x01
	MOVWF 0x35
; 132: 	Endif
L0035:
; 133: 	INTCON.T0IF = 0 'enable Interrupt
	BCF 0x0B,2
; 134: Resume
	RETURN
; 135: 
; 136: 
; End of program
L0036:	GOTO L0036
; Comparison Routine
C001:	MOVWF R1L
	MOVLW 0x05
	GOTO C007
C002:	MOVWF R1L
	MOVLW 0x02
	GOTO C007
C003:	MOVWF R1L
	MOVLW 0x06
	GOTO C007
C004:	MOVWF R1L
	MOVLW 0x03
	GOTO C007
C005:	MOVWF R1L
	MOVLW 0x04
	GOTO C007
C006:	MOVWF R1L
	MOVLW 0x01
	GOTO C007
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; EEPROM data
	ORG 0x2100
	DW 0x4C
	DW 0xF1
	DW 0x4C
	DW 0xF1
	DW 0x4C
	DW 0xF1
	DW 0x4C
	DW 0xF1
	DW 0x1C
	DW 0xF9
	DW 0x1C
	DW 0xF9
	DW 0x1C
	DW 0xF9
	DW 0x1C
	DW 0xF9
	DW 0x05
	DW 0x05
	DW 0x05
	DW 0x05
	DW 0x34
	DW 0xF5
	DW 0x34
	DW 0xF5
	DW 0x34
	DW 0xF5
	DW 0x34
	DW 0xF5
; End of listing
	END
