
TRISB = %00000001
TRISA = %11110000

'------------------------ VARIABELEN DECLARATIES -------------------------
Dim servo1 As Word
Dim servo2 As Word
Dim servo3 As Word
Dim servo4 As Word
'Dim wacht(4) As Byte
Dim dummy As Byte
Dim channel As Byte
Dim pulse_1msec As Word
Dim pulse_2msec As Word
Dim pulse_interval As Word
pulse_1msec = 63772  '0xF91C
pulse_2msec = 61772  '0xF14C
pulse_interval = 40000

'------------------------ CONSTANTEN DECLARATIES --------------------------

EEPROM 0, 0x4c, 0xf1, 0x4c, 0xf1, 0x4c, 0xf1, 0x4c, 0xf1, 0x1c, 0xf9, 0x1c, 0xf9, 0x1c, 0xf9, 0x1c, 0xf9, 5, 5, 5, 5, 0x34, 0xf5, 0x34, 0xf5, 0x34, 0xf5, 0x34, 0xf5

'Je kunt dus geen Word variabelen op deze manier in EEprom zetten.  Je moet de Word waarde in 2 bytes verdelen met de LSByte als eerste.

'----------------------- INTERRUPT CONFIGURATIE ---------------------------
T1CON = %00110000  'timer 1 internal clock, prescale = 1:8, stop
INTCON.GIE = 1  'enable all un-masked interrupts
INTCON.T0IE = 0  'stop tmr1
dummy = 1
servo1 = pulse_1msec
servo2 = pulse_1msec
servo3 = pulse_1msec
servo4 = pulse_1msec
channel = 1  'start with correct channel


'--------------------------- PROGRAM Mainloop ---------------------------
Enable  'start interrupts

WaitMs 1000
While dummy = 1  'endless loop
	WaitMs 4  'runtime servo's is 4 seconds, There are 1000 steps to do, so 4ms each step
	If RA4 = 0 Then  'barrier 1 going down
		If servo1 > pulse_2msec Then
			servo1 = servo1 - 1
		Endif
	Else  'barrier going up
		If servo1 < pulse_1msec Then
			servo1 = servo1 + 1
		Endif
	Endif
	If RA6 = 0 Then  'barrier 2 going down
		If servo2 > pulse_2msec Then
			servo2 = servo1 - 1
		Endif
	Else  'barrier going up
		If servo2 < pulse_1msec Then
			servo2 = servo1 + 1
		Endif
	Endif
	If RA7 = 0 Then  'barrier 1 going down
		If servo3 > pulse_2msec Then
			servo3 = servo1 - 1
		Endif
	Else  'barrier going up
		If servo3 < pulse_1msec Then
			servo3 = servo1 + 1
		Endif
	Endif
	If RB0 = 0 Then  'barrier 1 going down
		If servo4 > pulse_2msec Then
			servo4 = servo1 - 1
		Endif
	Else  'barrier going up
		If servo4 < pulse_1msec Then
			servo4 = servo1 + 1
		Endif
	Endif

Wend
End                                               

On Interrupt
timer1_interrupt:

	If channel = 1 Then
		If RB4 = 0 Then  'just start only once
			TMR1L = servo1.LB  'load timer
			TMR1H = servo1.HB
			RB4 = 1  'first servo
		Else  'timer will generate interrupt after 65536 - Servo(1) pulses
			channel = 2  'next servo
			RB4 = 0
		Endif
	Endif
	If channel = 2 Then
		If RB5 = 0 Then
			TMR1L = servo2.LB  'load timer
			TMR1H = servo2.HB
			RB5 = 1
		Else
			RB5 = 0
			channel = 3
		Endif
	Endif
	If channel = 3 Then
		If RB6 = 0 Then
			TMR1L = servo3.LB  'load timer
			TMR1H = servo3.HB
			RB6 = 1
		Else
			RB6 = 0
			channel = 4
		Endif
	Endif
	If channel = 4 Then
		If RB7 = 0 Then
			TMR1L = servo4.LB  'load timer
			TMR1H = servo4.HB
			RB7 = 1
		Else
			RB7 = 0
			channel = 5
		Endif
	Endif

	If channel = 5 Then
		TMR1L = pulse_interval.LB  'pause apporx 12 ms before 1st motor will start again.
		TMR1H = pulse_interval.HB
		channel = 1
	Endif
	INTCON.T0IF = 0  'enable Interrupt
Resume                                            


