	list p=16f627
	#include <p16f627.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.84
; Microcontroller model: PIC16F627
; Clock frequency: 4.0 MHz
;
;       The address of 'turnout_1' (bit) (global) is 0x30,0
;       The address of 'turnout_2' (bit) (global) is 0x30,1
;       The address of 'turnout_3' (bit) (global) is 0x30,2
;       The address of 'turnout_4' (bit) (global) is 0x30,3
;       The address of 'turnout_5' (bit) (global) is 0x30,4
;       The address of 'turnout_6' (bit) (global) is 0x30,5
;       The address of 'turnout_7' (bit) (global) is 0x30,6
;       The address of 'turnout_8' (bit) (global) is 0x30,7
;       The address of 'dip_switch' (byte) (global) is 0x31
	dip_switch EQU 0x31
;       The address of 'turnout_delay' (word) (global) is 0x32
	turnout_delay EQU 0x32
;       The address of 'position' (byte) (global) is 0x34
	position EQU 0x34
;       The address of 'dta' (bit) (global) is 0x6,0
;       The address of 'sck' (bit) (global) is 0x6,1
; Procedure declaration: Proc turnout_command(address As Byte, val As Byte)
;       The address of 'address' (byte) (turnout_command) is 0x35
;       The address of 'val' (byte) (turnout_command) is 0x36
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0003
	ORG 0x0004
	RETFIE
; Begin of program
L0003:
; 1: Define CONF_WORD = 0x3f50
; 2: 
; 3: 'program to control for 8 Turnouts with single coil or motor drive.
; 4: 'By Peter Giling
; 5: 
; 6: 'board MGV125
; 7: 'due to low power supply, only one output will be activated at all times.
; 8: 'positions are saves in EEprom to allow postion memory.
; 9: 
; 10: Dim turnout_1 As Bit
	BCF 0x30,0
; 11: Dim turnout_2 As Bit
	BCF 0x30,1
; 12: Dim turnout_3 As Bit
	BCF 0x30,2
; 13: Dim turnout_4 As Bit
	BCF 0x30,3
; 14: Dim turnout_5 As Bit
	BCF 0x30,4
; 15: Dim turnout_6 As Bit
	BCF 0x30,5
; 16: Dim turnout_7 As Bit
	BCF 0x30,6
; 17: Dim turnout_8 As Bit
	BCF 0x30,7
; 18: Dim dip_switch As Byte
	CLRF 0x31
; 19: Dim turnout_delay As Word
	CLRF 0x32
	CLRF 0x33
; 20: Dim position As Byte
	CLRF 0x34
; 21: 
; 22: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 23: TRISA = %11111111
	BSF STATUS,RP0
	MOVLW 0xFF
	MOVWF 0x05
; 24: TRISB = %11111111
	MOVLW 0xFF
	MOVWF 0x06
	BCF STATUS,RP0
; 25: Symbol dta = PORTB.0
; 26: Symbol sck = PORTB.1
; 27: I2CPrepare dta, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x01
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,0
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x02
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,1
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 28: WaitMs 100
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
	CALL W001
; 29: Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 30: Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 31: WaitMs 5000 'give 5 seconds to get all units ready
	MOVLW 0x88
	MOVWF R0L
	MOVLW 0x13
	MOVWF R0H
	CALL W001
; 32: dip_switch = PORTA
	MOVF 0x05,W
	MOVWF 0x31
; 33: dip_switch = dip_switch And %00011100
	MOVF 0x31,W
	MOVWF R0L
	MOVLW 0x1C
	ANDWF R0L,W
	MOVWF 0x31
; 34: 
; 35: Select Case dip_switch
; 36: Case 0
	MOVF 0x31,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0004
; 37: 	turnout_delay = 100
	MOVLW 0x64
	MOVWF 0x32
	CLRF 0x33
; 38: Case 4
	GOTO L0005
L0004:
	MOVF 0x31,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0006
; 39: 	turnout_delay = 200
	MOVLW 0xC8
	MOVWF 0x32
	CLRF 0x33
; 40: Case 8
	GOTO L0007
L0006:
	MOVF 0x31,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0008
; 41: 	turnout_delay = 400
	MOVLW 0x90
	MOVWF 0x32
	MOVLW 0x01
	MOVWF 0x33
; 42: Case 12
	GOTO L0009
L0008:
	MOVF 0x31,W
	SUBLW 0x0C
	BTFSS STATUS,Z
	GOTO L0010
; 43: 	turnout_delay = 800
	MOVLW 0x20
	MOVWF 0x32
	MOVLW 0x03
	MOVWF 0x33
; 44: Case 16
	GOTO L0011
L0010:
	MOVF 0x31,W
	SUBLW 0x10
	BTFSS STATUS,Z
	GOTO L0012
; 45: 	turnout_delay = 1600
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x06
	MOVWF 0x33
; 46: Case 20
	GOTO L0013
L0012:
	MOVF 0x31,W
	SUBLW 0x14
	BTFSS STATUS,Z
	GOTO L0014
; 47: 	turnout_delay = 3200
	MOVLW 0x80
	MOVWF 0x32
	MOVLW 0x0C
	MOVWF 0x33
; 48: Case 24
	GOTO L0015
L0014:
	MOVF 0x31,W
	SUBLW 0x18
	BTFSS STATUS,Z
	GOTO L0016
; 49: 	turnout_delay = 6400
	MOVLW 0x00
	MOVWF 0x32
	MOVLW 0x19
	MOVWF 0x33
; 50: Case Else
	GOTO L0017
L0016:
; 51: 	turnout_delay = 12800
	MOVLW 0x00
	MOVWF 0x32
	MOVLW 0x32
	MOVWF 0x33
; 52: EndSelect
L0017:
L0015:
L0013:
L0011:
L0009:
L0007:
L0005:
; 53: Read 1, position
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 54: turnout_1 = position.0
	BTFSC 0x34,0
	BSF 0x30,0
	BTFSS 0x34,0
	BCF 0x30,0
; 55: Read 2, position
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 56: turnout_2 = position.0
	BTFSC 0x34,0
	BSF 0x30,1
	BTFSS 0x34,0
	BCF 0x30,1
; 57: Read 3, position
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 58: turnout_3 = position.0
	BTFSC 0x34,0
	BSF 0x30,2
	BTFSS 0x34,0
	BCF 0x30,2
; 59: Read 4, position
	MOVLW 0x04
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 60: turnout_4 = position.0
	BTFSC 0x34,0
	BSF 0x30,3
	BTFSS 0x34,0
	BCF 0x30,3
; 61: Read 5, position
	MOVLW 0x05
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 62: turnout_5 = position.0
	BTFSC 0x34,0
	BSF 0x30,4
	BTFSS 0x34,0
	BCF 0x30,4
; 63: Read 6, position
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 64: turnout_6 = position.0
	BTFSC 0x34,0
	BSF 0x30,5
	BTFSS 0x34,0
	BCF 0x30,5
; 65: Read 7, position
	MOVLW 0x07
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 66: turnout_7 = position.0
	BTFSC 0x34,0
	BSF 0x30,6
	BTFSS 0x34,0
	BCF 0x30,6
; 67: Read 8, position
	MOVLW 0x08
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x34
; 68: turnout_8 = position.0
	BTFSC 0x34,0
	BSF 0x30,7
	BTFSS 0x34,0
	BCF 0x30,7
; 69: main:
L0001:
; 70: 		If RA0 <> turnout_1 Then 'turnout 1 to be checked
	CLRW
	BTFSC 0x05,0
	ADDLW 0x01
	BTFSC 0x30,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0018
; 71: 			If turnout_1 = 1 Then
	BTFSS 0x30,0
	GOTO L0019
; 72: 				Call turnout_command(64, %00000001)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x01
	MOVWF 0x36
	CALL L0002
; 73: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 74: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 75: 				turnout_1 = 0
	BCF 0x30,0
; 76: 				position = 0
	CLRF 0x34
; 77: 			Else
	GOTO L0020
L0019:
; 78: 				Call turnout_command(64, %00000010)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x02
	MOVWF 0x36
	CALL L0002
; 79: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 80: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 81: 				turnout_1 = 1
	BSF 0x30,0
; 82: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 83: 			Endif
L0020:
; 84: 			Write 1, position 'store actial position
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0021:	BTFSC EECON1,WR
	GOTO L0021
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 85: 		Endif
L0018:
; 86: 		If RA1 <> turnout_2 Then 'turnout  2 to be checked
	CLRW
	BTFSC 0x05,1
	ADDLW 0x01
	BTFSC 0x30,1
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0022
; 87: 			If turnout_2 = 1 Then
	BTFSS 0x30,1
	GOTO L0023
; 88: 				Call turnout_command(64, %00000100)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x04
	MOVWF 0x36
	CALL L0002
; 89: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 90: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 91: 				turnout_2 = 0
	BCF 0x30,1
; 92: 				position = 0
	CLRF 0x34
; 93: 			Else
	GOTO L0024
L0023:
; 94: 				Call turnout_command(64, %00001000)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x08
	MOVWF 0x36
	CALL L0002
; 95: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 96: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 97: 				turnout_2 = 1
	BSF 0x30,1
; 98: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 99: 			Endif
L0024:
; 100: 			Write 2, position 'store actial position
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0025:	BTFSC EECON1,WR
	GOTO L0025
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 101: 		Endif
L0022:
; 102: 		If RB5 <> turnout_3 Then 'turnout  3 to be checked
	CLRW
	BTFSC 0x06,5
	ADDLW 0x01
	BTFSC 0x30,2
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0026
; 103: 			If turnout_3 = 1 Then
	BTFSS 0x30,2
	GOTO L0027
; 104: 				Call turnout_command(64, %00010000)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x10
	MOVWF 0x36
	CALL L0002
; 105: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 106: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 107: 				turnout_3 = 0
	BCF 0x30,2
; 108: 				position = 0
	CLRF 0x34
; 109: 			Else
	GOTO L0028
L0027:
; 110: 				Call turnout_command(64, %00100000)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x20
	MOVWF 0x36
	CALL L0002
; 111: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 112: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 113: 				turnout_3 = 1
	BSF 0x30,2
; 114: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 115: 			Endif
L0028:
; 116: 			Write 3, position 'store actial position
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0029:	BTFSC EECON1,WR
	GOTO L0029
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 117: 		Endif
L0026:
; 118: 		If RA5 <> turnout_4 Then 'turnout  4 to be checked
	CLRW
	BTFSC 0x05,5
	ADDLW 0x01
	BTFSC 0x30,3
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0030
; 119: 			If turnout_4 = 1 Then
	BTFSS 0x30,3
	GOTO L0031
; 120: 				Call turnout_command(64, %01000000)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x40
	MOVWF 0x36
	CALL L0002
; 121: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 122: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 123: 				turnout_4 = 0
	BCF 0x30,3
; 124: 				position = 0
	CLRF 0x34
; 125: 			Else
	GOTO L0032
L0031:
; 126: 				Call turnout_command(64, %10000000)
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x80
	MOVWF 0x36
	CALL L0002
; 127: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 128: 				Call turnout_command(64, 0)
	MOVLW 0x40
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 129: 				turnout_4 = 1
	BSF 0x30,3
; 130: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 131: 			Endif
L0032:
; 132: 			Write 4, position 'store actial position
	MOVLW 0x04
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0033:	BTFSC EECON1,WR
	GOTO L0033
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 133: 		Endif
L0030:
; 134: 		If RB7 <> turnout_5 Then 'turnout 5 to be checked
	CLRW
	BTFSC 0x06,7
	ADDLW 0x01
	BTFSC 0x30,4
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0034
; 135: 			If turnout_5 = 1 Then
	BTFSS 0x30,4
	GOTO L0035
; 136: 				Call turnout_command(66, %00000001)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x01
	MOVWF 0x36
	CALL L0002
; 137: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 138: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 139: 				turnout_5 = 0
	BCF 0x30,4
; 140: 				position = 0
	CLRF 0x34
; 141: 			Else
	GOTO L0036
L0035:
; 142: 				Call turnout_command(66, %00000010)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x02
	MOVWF 0x36
	CALL L0002
; 143: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 144: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 145: 				turnout_5 = 1
	BSF 0x30,4
; 146: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 147: 			Endif
L0036:
; 148: 			Write 5, position 'store actial position
	MOVLW 0x05
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0037:	BTFSC EECON1,WR
	GOTO L0037
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 149: 		Endif
L0034:
; 150: 		If RB6 <> turnout_6 Then 'turnout  6 to be checked
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x30,5
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0038
; 151: 			If turnout_6 = 1 Then
	BTFSS 0x30,5
	GOTO L0039
; 152: 				Call turnout_command(66, %00000100)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x04
	MOVWF 0x36
	CALL L0002
; 153: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 154: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 155: 				turnout_6 = 0
	BCF 0x30,5
; 156: 				position = 0
	CLRF 0x34
; 157: 			Else
	GOTO L0040
L0039:
; 158: 				Call turnout_command(66, %00001000)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x08
	MOVWF 0x36
	CALL L0002
; 159: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 160: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 161: 				turnout_6 = 1
	BSF 0x30,5
; 162: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 163: 			Endif
L0040:
; 164: 			Write 6, position 'store actial position
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0041:	BTFSC EECON1,WR
	GOTO L0041
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 165: 		Endif
L0038:
; 166: 		If RA6 <> turnout_7 Then 'turnout  7 to be checked
	CLRW
	BTFSC 0x05,6
	ADDLW 0x01
	BTFSC 0x30,6
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0042
; 167: 			If turnout_7 = 1 Then
	BTFSS 0x30,6
	GOTO L0043
; 168: 				Call turnout_command(66, %00010000)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x10
	MOVWF 0x36
	CALL L0002
; 169: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 170: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 171: 				turnout_7 = 0
	BCF 0x30,6
; 172: 				position = 0
	CLRF 0x34
; 173: 			Else
	GOTO L0044
L0043:
; 174: 				Call turnout_command(66, %00100000)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x20
	MOVWF 0x36
	CALL L0002
; 175: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 176: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 177: 				turnout_7 = 1
	BSF 0x30,6
; 178: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 179: 			Endif
L0044:
; 180: 			Write 7, position 'store actial position
	MOVLW 0x07
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0045:	BTFSC EECON1,WR
	GOTO L0045
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 181: 		Endif
L0042:
; 182: 		If RA7 <> turnout_8 Then 'turnout  8 to be checked
	CLRW
	BTFSC 0x05,7
	ADDLW 0x01
	BTFSC 0x30,7
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0046
; 183: 			If turnout_8 = 1 Then
	BTFSS 0x30,7
	GOTO L0047
; 184: 				Call turnout_command(66, %01000000)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x40
	MOVWF 0x36
	CALL L0002
; 185: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 186: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 187: 				turnout_8 = 0
	BCF 0x30,7
; 188: 				position = 0
	CLRF 0x34
; 189: 			Else
	GOTO L0048
L0047:
; 190: 				Call turnout_command(66, %10000000)
	MOVLW 0x42
	MOVWF 0x35
	MOVLW 0x80
	MOVWF 0x36
	CALL L0002
; 191: 				WaitMs turnout_delay
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CALL W001
; 192: 				Call turnout_command(66, 0)
	MOVLW 0x42
	MOVWF 0x35
	CLRF 0x36
	CALL L0002
; 193: 				turnout_8 = 1
	BSF 0x30,7
; 194: 				position = 1
	MOVLW 0x01
	MOVWF 0x34
; 195: 			Endif
L0048:
; 196: 			Write 8, position 'store actial position
	MOVLW 0x08
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x34,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0049:	BTFSC EECON1,WR
	GOTO L0049
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 197: 		Endif
L0046:
; 198: 		WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 199: 
; 200: End
L0050:	GOTO L0050
; 201: Proc turnout_command(address As Byte, val As Byte)
L0002:
; 202: 	I2CStart
	CALL IC31
; 203: 	I2CSend address
	MOVF 0x35,W
	CALL IC01
; 204: 	I2CSend val
	MOVF 0x36,W
	CALL IC01
; 205: 	I2CStop
	CALL IC41
; 206: End Proc
	RETURN
; End of program
L0051:	GOTO L0051
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:	CALL IC21
	CALL IC23
	GOTO IC29
IC41:	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
