; Compiled with: PIC Simulator IDE v6.92
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_act_pos' (global) is 127
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_pos_match_delay' (global) is 113
;       The value of 'mem_bridge_rev_pos' (global) is 114
;       The address of 'speed_min' (word) (global) is 0x30
	speed_min EQU 0x30
;       The address of 'steps' (word) (global) is 0x32
	steps EQU 0x32
;       The address of 'act_pos' (byte) (global) is 0x34
	act_pos EQU 0x34
;       The address of 'value' (byte) (global) is 0x35
	value EQU 0x35
;       The address of 'speed_max' (word) (global) is 0x36
	speed_max EQU 0x36
;       The address of 'manual_pos' (byte) (global) is 0x38
	manual_pos EQU 0x38
;       The address of 'result' (byte) (global) is 0x39
	result EQU 0x39
;       The address of 'one_round' (word) (global) is 0x3A
	one_round EQU 0x3A
;       The address of 'max_pos' (byte) (global) is 0x3C
	max_pos EQU 0x3C
;       The address of 'free_space_steps' (byte) (global) is 0x3D
	free_space_steps EQU 0x3D
;       The address of 'ctrl_type' (byte) (global) is 0x3E
	ctrl_type EQU 0x3E
;       The address of 'new_steps' (word) (global) is 0x3F
	new_steps EQU 0x3F
;       The address of 'bridge_rev_pos' (byte) (global) is 0x41
	bridge_rev_pos EQU 0x41
;       The address of 'pos_match_delay' (byte) (global) is 0x42
	pos_match_delay EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'speed_step' (byte) (global) is 0x44
	speed_step EQU 0x44
;       The address of 'encoder_count' (byte) (global) is 0x45
	encoder_count EQU 0x45
;       The address of 'new_pos' (byte) (global) is 0x46
	new_pos EQU 0x46
;       The address of 'eprom_pointer' (byte) (global) is 0x47
	eprom_pointer EQU 0x47
;       The address of 'proceed' (bit) (global) is 0x48,0
;       The address of 'bridge_power' (byte) (global) is 0x49
	bridge_power EQU 0x49
;       The address of 'speed' (word) (global) is 0x4A
	speed EQU 0x4A
;       The address of 'disp1_val' (byte) (global) is 0x4C
	disp1_val EQU 0x4C
;       The address of 'new_encoder' (byte) (global) is 0x4D
	new_encoder EQU 0x4D
;       The address of 'steps_set' (bit) (global) is 0x48,1
;       The address of 'turn_counter' (byte) (global) is 0x4E
	turn_counter EQU 0x4E
;       The address of 'onoff' (bit) (relays) is 0x48,2
;       The address of 'act_steps' (word) (global) is 0x4F
	act_steps EQU 0x4F
;       The address of 'bus_pos' (byte) (global) is 0x51
	bus_pos EQU 0x51
;       The address of 'disp2_val' (byte) (global) is 0x52
	disp2_val EQU 0x52
;       The address of 'version' (bit) (global) is 0x48,3
;       The address of 'bitposition' (bit) (run_to_zero_switch) is 0x48,4
;       The address of 'ramp_up' (bit) (global) is 0x48,5
;       The address of 'speed' (word) (run_to_zero) is 0x53
;       The address of 'calc' (bit) (run_to_zero) is 0x48,6
;       The address of 'counting' (bit) (run_to_zero_switch) is 0x48,7
;       The address of 'ramp_down_point' (word) (global) is 0x55
	ramp_down_point EQU 0x55
;       The address of 'one_round_half' (word) (global) is 0x57
	one_round_half EQU 0x57
;       The address of 'old_encoder' (byte) (global) is 0x59
	old_encoder EQU 0x59
;       The address of 'old_manual_pos' (byte) (global) is 0x5A
	old_manual_pos EQU 0x5A
;       The address of 'old_pos_write' (bit) (global) is 0x5B,0
;       The address of 'half_steps' (word) (global) is 0x5C
	half_steps EQU 0x5C
;       The address of 'old_bus_pos' (byte) (global) is 0x5E
	old_bus_pos EQU 0x5E
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'adjust_en' (bit) (global) is 0x7,3
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0019
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0019:
; 1: 
; 2: 
; 3: Define CONF_WORD = 0x3f72
; 4: 
; 5: 'program TT for PCBoard GCA145 / MGV145
; 6: 'Universal version 7.1
; 7: 'For sliding systems (FY) extra end switch is used.
; 8: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 9: 'J4 is used as zero switch (pass first rail)
; 10: 'EEP1 jumper is used to enable pos 61 and 62
; 11: 
; 12: 'three extra position are possible:
; 13: '-  position 63 to go to zero switch and then to rail 1
; 14: '-  Position 62 to manually set all positions first time (Manual initialisation, only when eep1 is set)
; 15: 'programs :
; 16: '0  correction actual position
; 17: '1  Max positions
; 18: '2  min speed
; 19: '3  max speed
; 20: '4  incr/decr delay
; 21: '5  extra correction steps
; 22: '6  bridge power normal/ reversed (Pos) at this position and all higher ones, bridge power is reversed
; 23: '7  Bridge power on/off (1/0) while moving
; 24: '8  pos_match delay
; 25: '9  setting of control type (0..6)
; 26: '-  control types:
; 27: '-    1 |control is set For turntable NO 'shortest way option' means that running from highest to lowest position (or v.v.) will NOT pass 0 position.|
; 28: '-    2 |control is set For turntable with  'shortest way option' which means that running from one to next position (or v.v.) could pass 0 position.|
; 29: '-    3 |version for two rail tt, no restriction on 'short way'. This is special for TT with contact rings  (no cables).|
; 30: '-    4 |fiddle yard.railpower. End switch at the High position side is needed.|
; 31: 
; 32: '-      for control type see manual
; 33: 
; 34: Dim steps As Word
; 35: Dim half_steps As Word
; 36: Dim ramp_down_point As Word
; 37: Dim program_set As Byte
; 38: Dim new_steps As Word
; 39: Dim act_steps As Word
; 40: Dim new_pos As Byte
; 41: Dim act_pos As Byte
; 42: Dim one_round As Word
; 43: Dim one_round_half As Word
; 44: Dim bus_pos As Byte
; 45: Dim old_bus_pos As Byte
; 46: Dim speed As Word
; 47: Dim speed_min As Word
; 48: Dim speed_max As Word
; 49: Dim new_encoder As Byte
; 50: Dim old_encoder As Byte
; 51: Dim manual_pos As Byte
; 52: Dim old_manual_pos As Byte
; 53: Dim result As Byte
; 54: Dim free_space_steps As Byte
; 55: Dim value As Byte
; 56: Dim eprom_pointer As Byte
; 57: Dim encoder_count As Byte
; 58: 'Dim onoff As Bit
; 59: Dim max_pos As Byte
; 60: Dim disp1_val As Byte
; 61: Dim disp2_val As Byte
; 62: Dim old_pos_write As Bit
; 63: Dim ramp_up As Bit
; 64: Dim speed_step As Byte
; 65: Dim version As Bit
; 66: Dim steps_set As Bit
; 67: Dim bridge_power As Byte
; 68: Dim pos_match_delay As Byte
; 69: Dim bridge_rev_pos As Byte
; 70: Dim ctrl_type As Byte
; 71: Dim turn_counter As Byte
; 72: Dim proceed As Bit
; 73: Const disp1 = 64
; 74: Const disp2 = 66
; 75: Const mem_act_pos = 127
; 76: Const mem_turn_counter = 101
; 77: Const mem_speed_min = 103
; 78: Const mem_speed_max = 104
; 79: Const mem_speed_step = 105
; 80: Const mem_one_round_lb = 106
; 81: Const mem_one_round_hb = 107
; 82: Const mem_ctrl_type = 108
; 83: Const mem_max_pos = 109
; 84: Const mem_free_space = 110
; 85: Const mem_rev_pos = 111
; 86: Const mem_bridge_power = 112
; 87: Const mem_pos_match_delay = 113
; 88: Const mem_bridge_rev_pos = 114
; 89: Symbol swfw = RB0
; 90: Symbol swrev = RB1
; 91: Symbol sck = RB2
; 92: Symbol sda = RB3
; 93: Symbol pos_match = RB4
; 94: Symbol pos_write = RB5
; 95: Symbol direction = RC0
; 96: Symbol clk = RC1
; 97: Symbol ena = RC2
; 98: Symbol zero = RB6
; 99: Symbol max_end = RB7
; 100: Symbol ec1 = RC4
; 101: Symbol ec2 = RC5
; 102: Symbol ecsw = RC6
; 103: Symbol pgm = RC7
; 104: Symbol adjust_en = RC3
; 105: 
; 106: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 107: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 108: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 109: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 110: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 111: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 112: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 113: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 114: Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 115: program_set = 0
	CLRF 0x43
; 116: max_end = 1
	BSF 0x06,7
; 117: 
; 118: main:
L0001:
; 119: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0020
; 120: 		Gosub adjust_settings
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0004
; 121: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 122: 	Endif
L0020:
; 123: 
; 124: 	Gosub get_new_position
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0002
; 125: 	If bus_pos <> old_bus_pos Then
	MOVF 0x51,W
	SUBWF 0x5E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0021
; 126: 		Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 127: 'onoff = 0
; 128: 'Gosub relays
; 129: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 130: 		new_pos = bus_pos
	MOVF 0x51,W
	MOVWF 0x46
; 131: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 132: 		Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 133: 'onoff = 1
; 134: 'Gosub relays
; 135: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 136: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0022
L0021:
; 137: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0023
; 138: 			If manual_pos <> old_manual_pos Then
	MOVF 0x38,W
	SUBWF 0x5A,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0024
; 139: 				Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 140: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 141: 				old_manual_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x5A
; 142: 				new_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x46
; 143: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 144: 				Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 145: 				Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 146: 			Endif
L0024:
; 147: 		Endif
L0023:
; 148: 	Endif
L0022:
; 149: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 150: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 151: End
;       PAGE SELECT
	BCF PCLATH,3
L0025:	GOTO L0025
; 152: 
; 153: get_new_position:
L0002:
; 154: 	value = bus_pos  'remember the position
	MOVF 0x51,W
	MOVWF 0x35
; 155: 	If pos_write = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0026
; 156: 		If old_pos_write = 0 Then  'react once on rising edge
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x5B,0
	GOTO L0027
; 157: 			old_pos_write = 1
	BSF 0x5B,0
; 158: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x35
; 159: 			Select Case value
; 160: 			Case 63  'position reset is desired
	MOVF 0x35,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 161: 				value = 63
	MOVLW 0x3F
	MOVWF 0x35
; 162: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0029
L0028:
; 163: 				If value > max_pos Then  'this is not allowed
	MOVF 0x35,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 164: 					value = bus_pos  'put it back to old situation
	MOVF 0x51,W
	MOVWF 0x35
; 165: 				Endif
L0030:
; 166: 			EndSelect
L0029:
; 167: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 168: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x35,W
	SUBWF 0x51,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0031
; 169: 				pos_match = 1
	BSF 0x06,4
; 170: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 171: 				pos_match = 0
	BCF 0x06,4
; 172: 			Endif
L0031:
; 173: 		Endif
L0027:
; 174: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0032
L0026:
; 175: 		old_pos_write = 0
	BCF 0x5B,0
; 176: 	Endif
L0032:
; 177: 	bus_pos = value  'now take over the desired position
	MOVF 0x35,W
	MOVWF 0x51
; 178: 	Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 179: 	Select Case result
; 180: 	Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 181: 		If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x45,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 182: 			encoder_count = encoder_count + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 183: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0035
L0034:
; 184: 			encoder_count = 0
	CLRF 0x45
; 185: 			Select Case manual_pos
; 186: 			Case < max_pos
	MOVF 0x3C,W
	SUBWF 0x38,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0036
; 187: 				manual_pos = manual_pos + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 188: 			Case max_pos
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0036:
	MOVF 0x38,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 189: 				If adjust_en = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0039
; 190: 					manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 191: 				Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0040
L0039:
; 192: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 193: 				Endif
L0040:
; 194: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0041
L0038:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 195: 				manual_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 196: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0043
L0042:
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0044
; 197: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 198: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0045
L0044:
; 199: 			EndSelect
L0045:
L0043:
L0041:
L0037:
; 200: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 201: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 202: 		Endif
L0035:
; 203: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0046
L0033:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0047
; 204: 		If encoder_count > 0 Then
	MOVF 0x45,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0048
; 205: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 206: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0049
L0048:
; 207: 			encoder_count = 6
	MOVLW 0x06
	MOVWF 0x45
; 208: 			Select Case manual_pos
; 209: 			Case 62
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 210: 				manual_pos = max_pos
	MOVF 0x3C,W
	MOVWF 0x38
; 211: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 212: 				If adjust_en = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0053
; 213: 					manual_pos = max_pos
	MOVF 0x3C,W
	MOVWF 0x38
; 214: 				Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0053:
; 215: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 216: 				Endif
L0054:
; 217: 			Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0055
L0052:
	MOVF 0x38,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 218: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 219: 			Case 0
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0057
L0056:
	MOVF 0x38,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 220: 				manual_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 221: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0059
L0058:
; 222: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 223: 			EndSelect
L0059:
L0057:
L0055:
L0051:
; 224: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 225: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 226: 		Endif
L0049:
; 227: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0060
L0047:
; 228: 	EndSelect
L0060:
L0046:
; 229: 	WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 230: 	
; 231: Return
	RETURN
; 232: 
; 233: 
; 234: 
; 235: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 236: '1 = increasing value
; 237: '2 = decreasing value
; 238: '3 = no change
; 239: 		new_encoder = 0
	CLRF 0x4D
; 240: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4D,0
	BTFSS 0x07,4
	BCF 0x4D,0
; 241: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4D,1
	BTFSS 0x07,5
	BCF 0x4D,1
; 242: 		Select Case old_encoder
; 243: 		Case 0
	MOVF 0x59,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 244: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x39
L0062:
; 245: 		Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0063
L0061:
	MOVF 0x59,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 246: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0065
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x39
L0065:
; 247: 		Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0066
L0064:
	MOVF 0x59,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
; 248: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x39
L0068:
; 249: 		Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0069
L0067:
; 250: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0070
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x39
L0070:
; 251: 		EndSelect
L0069:
L0066:
L0063:
; 252: 		old_encoder = new_encoder
	MOVF 0x4D,W
	MOVWF 0x59
; 253: Return
	RETURN
; 254: 
; 255: 
; 256: adjust_settings:
L0004:
; 257: 	Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 258: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 259: 	Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 260: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 261: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x4F,W
	MOVWF 0x3F
	MOVF 0x50,W
	MOVWF 0x40
; 262: 	While pgm = 0  'the program switch is still activated
L0071:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0072
; 263: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0073
; 264: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 265: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0074
; 266: 				program_set = 0
	CLRF 0x43
; 267: 			Endif
L0074:
; 268: 			Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 269: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 270: 			While ecsw = 0  'be sure pushbutton is released
L0075:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0076
; 271: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 272: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0075
L0076:
; 273: 		Endif
L0073:
; 274: 		Select Case program_set
; 275: 		Case 0  'correction of current position
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0077
; 276: 			value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 277: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 278: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 279: 			Select Case result
; 280: 			Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
; 281: 				If new_steps < 60000 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 282: 					ena = 1  'motor on
	BSF 0x07,2
; 283: 					new_steps = new_steps + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 284: 					direction = 1
	BSF 0x07,0
; 285: 					clk = 1  'clock out
	BSF 0x07,1
; 286: 					WaitUs speed_min
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 287: 					clk = 0
	BCF 0x07,1
; 288: 					WaitUs speed_min
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 289: 				Endif
L0079:
; 290: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0080
L0078:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 291: 				If new_steps > 0 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0082
; 292: 					ena = 1  'motor on
	BSF 0x07,2
; 293: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 294: 					direction = 0
	BCF 0x07,0
; 295: 					clk = 1  'clock out
	BSF 0x07,1
; 296: 					WaitUs speed_min
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 297: 					clk = 0
	BCF 0x07,1
; 298: 					WaitUs speed_min
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 299: 				Endif
L0082:
; 300: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0083
L0081:
; 301: 			EndSelect
L0083:
L0080:
; 302: 		Case 1  'setting of maximum positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0084
L0077:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 303: 			steps_set = 0
	BCF 0x48,1
; 304: 			ena = 0  'shut off motor
	BCF 0x07,2
; 305: 			value = max_pos
	MOVF 0x3C,W
	MOVWF 0x35
; 306: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 307: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 308: 			Select Case result
; 309: 			Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 310: 				Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 311: 				If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0087
; 312: 					If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0088
; 313: 						max_pos = max_pos + 1
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x3C
; 314: 						Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0089:	BTFSC EECON1,WR
	GOTO L0089
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 315: 					Endif
L0088:
; 316: 				Endif
L0087:
; 317: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0090
L0086:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0091
; 318: 				Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 319: 				If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0092
; 320: 					If max_pos > 2 Then  'minimum 2 positions
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 321: 						max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 322: 						Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 323: 					Endif
L0093:
; 324: 				Endif
L0092:
; 325: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0095
L0091:
; 326: 			EndSelect
L0095:
L0090:
; 327: 		Case 2  'setting of speed interval Minimum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0096
L0085:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 328: 					'setting will be done in multiple of 256 uSecs
; 329: 					'minimum is usually not less then 5, and maximum is 99 (is real slow)
; 330: 			steps_set = 0
	BCF 0x48,1
; 331: 			ena = 0  'shut off motor
	BCF 0x07,2
; 332: 			value = speed_min.HB
	MOVF 0x31,W
	MOVWF 0x35
; 333: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 334: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 335: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 336: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0098
; 337: 				Select Case result
; 338: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 339: 					If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x31,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0100
; 340: 						speed_min.HB = speed_min.HB + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 341: 						Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0101:	BTFSC EECON1,WR
	GOTO L0101
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 342: 					Endif
L0100:
; 343: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0102
L0099:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 344: 					If speed_min.HB > speed_max.HB Then
	MOVF 0x31,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0104
; 345: 						speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 346: 						Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 347: 					Endif
L0104:
; 348: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0106
L0103:
; 349: 				EndSelect
L0106:
L0102:
; 350: 			Endif
L0098:
; 351: 		Case 3  'setting of speed interval Maximum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0107
L0097:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 352: 					'setting will be done in multiple of 256 uSecs
; 353: 					'minimum is 1 and maximum is 99 (is real slow)
; 354: 			steps_set = 0
	BCF 0x48,1
; 355: 			ena = 0  'shut off motor
	BCF 0x07,2
; 356: 			value = speed_max.HB
	MOVF 0x37,W
	MOVWF 0x35
; 357: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 358: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 359: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 360: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0109
; 361: 				Select Case result
; 362: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0110
; 363: 					If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x31,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0111
; 364: 						speed_max.HB = speed_max.HB + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 365: 						Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0112:	BTFSC EECON1,WR
	GOTO L0112
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 366: 					Endif
L0111:
; 367: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0113
L0110:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0114
; 368: 					If speed_max.HB > 2 Then
	MOVF 0x37,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0115
; 369: 						speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 370: 						Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0116:	BTFSC EECON1,WR
	GOTO L0116
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 371: 					Endif
L0115:
; 372: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0117
L0114:
; 373: 				EndSelect
L0117:
L0113:
; 374: 			Endif
L0109:
; 375: 		Case 4  'setting of ramp up and down speed
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0118
L0108:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 376: 					'speed will be the value that speed will be changed every step up and down
; 377: 			steps_set = 0
	BCF 0x48,1
; 378: 			ena = 0  'shut off motor
	BCF 0x07,2
; 379: 			value = speed_step
	MOVF 0x44,W
	MOVWF 0x35
; 380: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 381: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 382: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 383: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0120
; 384: 				Select Case result
; 385: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 386: 					If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0122
; 387: 						speed_step = speed_step + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 388: 						Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 389: 					Endif
L0122:
; 390: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0124
L0121:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 391: 					If speed_step > 1 Then
	MOVF 0x44,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0126
; 392: 						speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 393: 						Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 394: 					Endif
L0126:
; 395: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0128
L0125:
; 396: 				EndSelect
L0128:
L0124:
; 397: 			Endif
L0120:
; 398: 	
; 399: 		Case 5  'setting of extra free space steps
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0129
L0119:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 400: 			steps_set = 0
	BCF 0x48,1
; 401: 			ena = 0  'shut off motor
	BCF 0x07,2
; 402: 			If free_space_steps > 250 Then
	MOVF 0x3D,W
	SUBLW 0xFA
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0131
; 403: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3D
; 404: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0132:	BTFSC EECON1,WR
	GOTO L0132
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 405: 			Endif
L0131:
; 406: 			value = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x35
; 407: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 408: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 409: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 410: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0133
; 411: 				Select Case result
; 412: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0134
; 413: 					If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0135
; 414: 						free_space_steps = free_space_steps + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 415: 						Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0136:	BTFSC EECON1,WR
	GOTO L0136
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 416: 					Endif
L0135:
; 417: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0137
L0134:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 418: 					If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0139
; 419: 						free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 420: 						Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0140:	BTFSC EECON1,WR
	GOTO L0140
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 421: 					Endif
L0139:
; 422: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0141
L0138:
; 423: 				EndSelect
L0141:
L0137:
; 424: 			Endif
L0133:
; 425: 		Case 6  'at which postion is in bridge reversed power
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0142
L0130:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0143
; 426: 			steps_set = 0
	BCF 0x48,1
; 427: 			ena = 0  'shut off motor
	BCF 0x07,2
; 428: 			steps_set = 0
	BCF 0x48,1
; 429: 			ena = 0  'shut off motor
	BCF 0x07,2
; 430: 			value = bridge_rev_pos
	MOVF 0x41,W
	MOVWF 0x35
; 431: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 432: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 433: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 434: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0144
; 435: 				Select Case result
; 436: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 437: 					If bridge_rev_pos < max_pos Then  'no more positions possible
	MOVF 0x3C,W
	SUBWF 0x41,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 438: 						bridge_rev_pos = bridge_rev_pos + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 439: 						Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 440: 					Endif
L0146:
; 441: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0148
L0145:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
; 442: 					If bridge_rev_pos > 0 Then  '0 does not effect reversing
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0150
; 443: 						bridge_rev_pos = bridge_rev_pos - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 444: 						Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0151:	BTFSC EECON1,WR
	GOTO L0151
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 445: 					Endif
L0150:
; 446: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0152
L0149:
; 447: 				EndSelect
L0152:
L0148:
; 448: 			Endif
L0144:
; 449: 		Case 7  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0153
L0143:
	MOVF 0x43,W
	SUBLW 0x07
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0154
; 450: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x49
; 451: 			If bridge_power > 1 Then
	MOVF 0x49,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0155
; 452: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x49
; 453: 			Endif
L0155:
; 454: 			value = bridge_power
	MOVF 0x49,W
	MOVWF 0x35
; 455: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 456: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 457: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 458: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0156
; 459: 				Select Case result
; 460: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 461: 					bridge_power = 1
	MOVLW 0x01
	MOVWF 0x49
; 462: 					Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0158:	BTFSC EECON1,WR
	GOTO L0158
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 463: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0159
L0157:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 464: 					bridge_power = 0
	CLRF 0x49
; 465: 					Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 466: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0162
L0160:
; 467: 				EndSelect
L0162:
L0159:
; 468: 			Endif
L0156:
; 469: 		Case 8  'setting delay in millisecs before tt is ready is sent)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0163
L0154:
	MOVF 0x43,W
	SUBLW 0x08
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0164
; 470: 			Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 471: 			If pos_match_delay > 50 Then
	MOVF 0x42,W
	SUBLW 0x32
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0165
; 472: 				pos_match_delay = 50
	MOVLW 0x32
	MOVWF 0x42
; 473: 			Endif
L0165:
; 474: 			value = pos_match_delay
	MOVF 0x42,W
	MOVWF 0x35
; 475: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 476: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 477: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 478: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0166
; 479: 				Select Case result
; 480: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
; 481: 					If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x42,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0168
; 482: 						pos_match_delay = pos_match_delay + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 483: 					Endif
L0168:
; 484: 					Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 485: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0170
L0167:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0171
; 486: 					If pos_match_delay > 0 Then
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0172
; 487: 						pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 488: 					Endif
L0172:
; 489: 					Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 490: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0174
L0171:
; 491: 				EndSelect
L0174:
L0170:
; 492: 			Endif
L0166:
; 493: 		Case Else  'menu 9 , setting control type
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0175
L0164:
; 494: 			steps_set = 0
	BCF 0x48,1
; 495: 			ena = 0  'shut off motor
	BCF 0x07,2
; 496: 			If ctrl_type > 4 Then
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0176
; 497: 				ctrl_type = 4
	MOVLW 0x04
	MOVWF 0x3E
; 498: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 499: 			Endif
L0176:
; 500: 			value = ctrl_type
	MOVF 0x3E,W
	MOVWF 0x35
; 501: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 502: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 503: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 504: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0178
; 505: 				Select Case result
; 506: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
; 507: 					If ctrl_type < 4 Then
	MOVLW 0x04
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0180
; 508: 						ctrl_type = ctrl_type + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
; 509: 						Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0181:	BTFSC EECON1,WR
	GOTO L0181
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 510: 					Endif
L0180:
; 511: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0182
L0179:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0183
; 512: 					If ctrl_type > 1 Then
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0184
; 513: 						ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 514: 						Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0185:	BTFSC EECON1,WR
	GOTO L0185
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 515: 					Endif
L0184:
; 516: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0186
L0183:
; 517: 				EndSelect
L0186:
L0182:
; 518: 			Endif
L0178:
; 519: 		EndSelect
L0175:
L0163:
L0153:
L0142:
L0129:
L0118:
L0107:
L0096:
L0084:
; 520: 		WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 521: 	Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0071
L0072:
; 522: 	ena = 0  'shut off motor
	BCF 0x07,2
; 523: 		'***************   now check if changes have to BE written in eeprom
; 524: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x4F,W
	MOVWF R1L
	MOVF 0x50,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 525: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 526: 	Endif
L0187:
; 527: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 528: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 529: 	Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 530: Return
	RETURN
; 531: 
; 532: i2c_display:
L0005:
; 533: 	Select Case value
; 534: 	Case 99
	MOVF 0x35,W
	SUBLW 0x63
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0188
; 535: 		disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x4C
; 536: 		disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x52
; 537: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0189
L0188:
; 538: 		disp1_val = value
	MOVF 0x35,W
	MOVWF 0x4C
; 539: 		disp1_val = disp1_val Mod 10
	MOVF 0x4C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4C
; 540: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0190
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4C
L0190:
; 541: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4C,7
	BTFSS 0x07,7
	BCF 0x4C,7
; 542: 		disp2_val = value
	MOVF 0x35,W
	MOVWF 0x52
; 543: 		disp2_val = disp2_val / 10
	MOVF 0x52,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
; 544: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x52,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0191
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x52
L0191:
; 545: 		disp2_val.7 = version
	BTFSC 0x48,3
	BSF 0x52,7
	BTFSS 0x48,3
	BCF 0x52,7
; 546: 	EndSelect
L0189:
; 547: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 548: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 549: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 550: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 551: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 552: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 553: 	I2CSend disp2_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x52,W
	CALL IC01
; 554: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 555: Return
	RETURN
; 556: 
; 557: i2c_display_pgm:
L0006:
; 558: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x43,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0192
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4C
L0192:
; 559: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 560: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 561: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 562: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 563: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 564: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 565: 	I2CSend %10111111
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 566: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 567: Return
	RETURN
; 568: 
; 569: stepmotor:
L0007:
; 570: 	speed = 0
	CLRF 0x4A
	CLRF 0x4B
; 571: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 572: 	Select Case new_pos
; 573: 	Case 62  'this is the manual setting for each position
	MOVF 0x46,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 574: 'this position is equal for all control types, except for max switch
; 575: 'in case of control type < 6 the zero switch is used for total steps calculation
; 576: 'and bridge will run one full round extra.
; 577: 		direction = 0  'first backward
	BCF 0x07,0
; 578: 		ena = 1  'motor on
	BSF 0x07,2
; 579: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 580: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 581: 		ena = 0  'motor off
	BCF 0x07,2
; 582: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 583: 		one_round = 0  'start counting steps to max pos
	CLRF 0x3A
	CLRF 0x3B
; 584: 		ena = 1  'motor on
	BSF 0x07,2
; 585: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x34
; 586: 		If ctrl_type < 4 Then  'now extra round to be made to calculate total steps
	MOVLW 0x04
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0194
; 587: 			Call run_to_zero_switch(0, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BCF 0x48,4
	BSF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 588: 			Call run_to_zero_switch(1, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BSF 0x48,4
	BSF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 589: 		Endif
L0194:
; 590: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 591: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0196:	BTFSC EECON1,WR
	GOTO L0196
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 592: 		one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 593: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 594: 		direction = 1  'run forward
	BSF 0x07,0
; 595: 		value = 0  'WE ARE IN ZERO POSITION NOW
	CLRF 0x35
; 596: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 597: 		one_round = 0  'temporary use variable to count individual postitions
	CLRF 0x3A
	CLRF 0x3B
; 598: 		While act_pos <= max_pos  'turn motor until max pos is reached
L0197:
	MOVF 0x34,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0198
; 599: 				clk = 1  'clock out
	BSF 0x07,1
; 600: 				WaitUs speed_min
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 601: 				clk = 0
	BCF 0x07,1
; 602: 				WaitUs speed_min
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 603: 				one_round = one_round + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 604: 				If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0199
; 605: 					new_steps = one_round
	MOVF 0x3A,W
	MOVWF 0x3F
	MOVF 0x3B,W
	MOVWF 0x40
; 606: 					Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 607: 					value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 608: 					Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 609: 					act_pos = act_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 610: 					WaitMs 500  'give some time to breeze
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 611: 					While ecsw = 0  'Check If knob is Not pressed
L0200:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0201
; 612: 					Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0200
L0201:
; 613: 				Endif
L0199:
; 614: 				If ctrl_type = 4 Then  'for FY , max limit switch is to be checked.
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0202
; 615: 					If max_end = 0 Then  'end switch for fy is touched, end cycle
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0203
; 616: 						act_pos = max_pos + 1  'cancel the procedure
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x34
; 617: 						ena = 0
	BCF 0x07,2
; 618: 					Endif
L0203:
; 619: 				Endif
L0202:
; 620: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0197
L0198:
; 621: 		Write mem_turn_counter, 127  'reset turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7F
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0204:	BTFSC EECON1,WR
	GOTO L0204
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 622: 		Read mem_one_round_lb, one_round.LB  'put stored value back in one_round
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 623: 		Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 624: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 625: 		ena = 1  'set anable on
	BSF 0x07,2
; 626: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 627: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 628: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 629: 		act_pos = 0
	CLRF 0x34
; 630: 		new_pos = 1
	MOVLW 0x01
	MOVWF 0x46
; 631: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 632: 		direction = 1  'now forwards
	BSF 0x07,0
; 633: 		steps = new_steps + free_space_steps
	MOVF 0x3F,W
	ADDWF 0x3D,W
	MOVWF 0x32
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x33
; 634: 		ramp_up = 1
	BSF 0x48,5
; 635: 		ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 636: 		half_steps = steps / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 637: 		ena = 1  'set Enable on
	BSF 0x07,2
; 638: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 639: 		Call run_to_zero(speed_min, 0)
	MOVF 0x30,W
	MOVWF 0x53
	MOVF 0x31,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 640: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 641: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x32
	CLRF 0x33
; 642: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 643: 		Call run_to_zero(speed_min, 0)
	MOVF 0x30,W
	MOVWF 0x53
	MOVF 0x31,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 644: 		ena = 0  'enable off
	BCF 0x07,2
; 645: 	Case 63  'go to zero switch and then to 1st rail position (Pos 1)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0205
L0193:
	MOVF 0x46,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 646: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 647: 		ena = 1  'set anable on
	BSF 0x07,2
; 648: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 649: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 650: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 651: 		new_pos = 1
	MOVLW 0x01
	MOVWF 0x46
; 652: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 653: 		direction = 1  'now forwards
	BSF 0x07,0
; 654: 		steps = new_steps + free_space_steps
	MOVF 0x3F,W
	ADDWF 0x3D,W
	MOVWF 0x32
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x33
; 655: 		ramp_up = 1
	BSF 0x48,5
; 656: 		ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 657: 		half_steps = steps / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 658: 		speed = speed_min
	MOVF 0x30,W
	MOVWF 0x4A
	MOVF 0x31,W
	MOVWF 0x4B
; 659: 		ena = 1  'set Enable on
	BSF 0x07,2
; 660: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 661: 		Call run_to_zero(speed_min, 1)
	MOVF 0x30,W
	MOVWF 0x53
	MOVF 0x31,W
	MOVWF 0x54
	BSF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 662: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 663: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x32
	CLRF 0x33
; 664: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 665: 		Call run_to_zero(speed_min, 1)
	MOVF 0x30,W
	MOVWF 0x53
	MOVF 0x31,W
	MOVWF 0x54
	BSF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 666: 		ena = 0  'enable off
	BCF 0x07,2
; 667: 	Case Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0207
L0206:
; 668: 		steps = 0
	CLRF 0x32
	CLRF 0x33
; 669: 		one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 670: 		If new_steps > act_steps Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x4F,W
	MOVWF R1L
	MOVF 0x50,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
; 671: 			steps = new_steps - act_steps
	MOVF 0x4F,W
	SUBWF 0x3F,W
	MOVWF 0x32
	MOVF 0x50,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x33
; 672: 			direction = 1
	BSF 0x07,0
; 673: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 674: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0209
L0208:
; 675: 			steps = act_steps - new_steps
	MOVF 0x3F,W
	SUBWF 0x4F,W
	MOVWF 0x32
	MOVF 0x40,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x50,W
	MOVWF 0x33
; 676: 			direction = 0
	BCF 0x07,0
; 677: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 678: 		Endif
L0209:
; 679: 		If steps > 0 Then  'motor must be activated
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
; 680: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0211
; 681: 				steps = steps + free_space_steps
	MOVF 0x32,W
	ADDWF 0x3D,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x33
; 682: 			Endif
L0211:
; 683: 			ramp_up = 1
	BSF 0x48,5
; 684: 			ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 685: 			half_steps = steps / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 686: 			speed = speed_min
	MOVF 0x30,W
	MOVWF 0x4A
	MOVF 0x31,W
	MOVWF 0x4B
; 687: 			ena = 1  'set anable on
	BSF 0x07,2
; 688: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 689: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0212:
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0213
; 690: 				clk = 1  'clock out
	BSF 0x07,1
; 691: 				WaitUs speed
	MOVF 0x4A,W
	MOVWF R4L
	MOVF 0x4B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 692: 				clk = 0
	BCF 0x07,1
; 693: 				WaitUs speed
	MOVF 0x4A,W
	MOVWF R4L
	MOVF 0x4B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 694: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 695: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 696: 				If ctrl_type = 4 Then  'only for fiddle yard
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 697: 					If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0215
; 698: 						If max_end = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0216
; 699: 							Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 700: 						Endif
L0216:
; 701: 					Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0217
L0215:
; 702: 						If zero = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,6
	GOTO L0218
; 703: 							Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 704: 						Endif
L0218:
; 705: 					Endif
L0217:
; 706: 				Endif
L0214:
; 707: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0212
L0213:
; 708: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0219
; 709: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0220
; 710: 					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 711: 					steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x32
	CLRF 0x33
; 712: 					direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 713: 					Call run_to_zero(speed_min, 0)
	MOVF 0x30,W
	MOVWF 0x53
	MOVF 0x31,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 714: 				Endif
L0220:
; 715: 			Endif
L0219:
; 716: 			ena = 0  'enable off
	BCF 0x07,2
; 717: 		Endif
L0210:
; 718: 	EndSelect
L0207:
L0205:
; 719: 	act_pos = new_pos
	MOVF 0x46,W
	MOVWF 0x34
; 720: 	Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0221:	BTFSC EECON1,WR
	GOTO L0221
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 721: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x51
; 722: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5E
; 723: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 724: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5A
; 725: 
; 726: Return
	RETURN
; 727: 
; 728: check_0_pass_allowed:
L0008:
; 729: 	If steps > one_round_half Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0222
; 730: 		Select Case ctrl_type
; 731: 		Case 2  'crossing zero possible but only if not too many turns in one direction
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0223
; 732: 			If steps > one_round_half Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0224
; 733: 				Read mem_turn_counter, turn_counter  'get the total turns
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4E
; 734: 				If turn_counter > 124 And direction = 1 Then  'extra round in direction 0 allowed
	MOVF 0x4E,W
	SUBLW 0x7C
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0225
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0225
; 735: 					turn_counter = turn_counter - 1  'substract 1 pass
	MOVLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 736: 					Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0226:	BTFSC EECON1,WR
	GOTO L0226
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 737: 					direction = 0  'change direction
	BCF 0x07,0
; 738: 					steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x32,W
	SUBWF 0x3A,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x33
; 739: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0227
L0225:
; 740: 					If turn_counter < 130 And direction = 0 Then  'extra round in direction 1 allowed
	MOVLW 0x82
	SUBWF 0x4E,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0228
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,0
	GOTO L0228
; 741: 						turn_counter = turn_counter + 1
	MOVF 0x4E,W
	ADDLW 0x01
	MOVWF 0x4E
; 742: 						Write mem_turn_counter, turn_counter  'add 1 pass
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0229:	BTFSC EECON1,WR
	GOTO L0229
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 743: 						direction = 1  'change direction
	BSF 0x07,0
; 744: 						steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x32,W
	SUBWF 0x3A,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x33
; 745: 					Endif
L0228:
; 746: 				Endif
L0227:
; 747: 			Endif
L0224:
; 748: 		Case 3  'crossing zero always possible
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0230
L0223:
	MOVF 0x3E,W
	SUBLW 0x03
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0231
; 749: 			direction = Not direction  'change direction
	MOVLW 0x01
	XORWF 0x07,F
; 750: 			steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x32,W
	SUBWF 0x3A,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x33
; 751: 		Case Else  'no zero crossing allowed
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0232
L0231:
; 752: 		EndSelect
L0232:
L0230:
; 753: 	Endif
L0222:
; 754: Return
	RETURN
; 755: 
; 756: 
; 757: speed_calc:
L0009:
; 758: 	If steps < half_steps Then  'at this point  ramp up MUST end half way
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x5C,W
	MOVWF R1L
	MOVF 0x5D,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
; 759: 		ramp_up = 0
	BCF 0x48,5
; 760: 	Endif
L0233:
; 761: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,5
	GOTO L0234
; 762: 		If speed > speed_max Then
	MOVF 0x4A,W
	MOVWF R0L
	MOVF 0x4B,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
; 763: 			speed = speed - speed_step
	MOVF 0x44,W
	SUBWF 0x4A,W
	MOVWF 0x4A
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4B,W
	MOVWF 0x4B
; 764: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x55,W
	ADDLW 0x01
	MOVWF 0x55
	MOVF 0x56,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x56
; 765: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0236
L0235:
; 766: 			ramp_up = 0
	BCF 0x48,5
; 767: 		Endif
L0236:
; 768: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0237
L0234:
; 769: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0238
; 770: 			If speed < speed_min Then
	MOVF 0x4A,W
	MOVWF R0L
	MOVF 0x4B,W
	MOVWF R0H
	MOVF 0x30,W
	MOVWF R1L
	MOVF 0x31,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0239
; 771: 				speed = speed + speed_step
	MOVF 0x4A,W
	ADDWF 0x44,W
	MOVWF 0x4A
	MOVF 0x4B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4B
; 772: 			Endif
L0239:
; 773: 		Endif
L0238:
; 774: 	Endif
L0237:
; 775: Return
	RETURN
; 776: 
; 777: 
; 778: 
; 779: init_values:
L0010:
; 780: 	value = 71  'version number
	MOVLW 0x47
	MOVWF 0x35
; 781: 	version = 0  'decimal point in display on
	BCF 0x48,3
; 782: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 783: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 784: 	version = 1  'decimal point in display off
	BSF 0x48,3
; 785: 	encoder_count = 0
	CLRF 0x45
; 786: 	speed_min = 0
	CLRF 0x30
	CLRF 0x31
; 787: 	
; 788: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 789: 	If ctrl_type > 4 Or ctrl_type = 0 Then
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0242
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0241
L0242:
	MOVF 0x3E,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0240
L0241:
; 790: 		ctrl_type = 1
	MOVLW 0x01
	MOVWF 0x3E
; 791: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0243:	BTFSC EECON1,WR
	GOTO L0243
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 792: 	Endif
L0240:
; 793: 	
; 794: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 795: 	If speed_min.HB > 99 Then
	MOVF 0x31,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0244
; 796: 		speed_min.HB = 30
	MOVLW 0x1E
	MOVWF 0x31
; 797: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0245
L0244:
; 798: 		If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x31,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0246
; 799: 			speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x31
; 800: 		Endif
L0246:
; 801: 	Endif
L0245:
; 802: 
; 803: 	Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0247:	BTFSC EECON1,WR
	GOTO L0247
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 804: 	speed_max = 0
	CLRF 0x36
	CLRF 0x37
; 805: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 806: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x37,W
	SUBWF 0x31,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0248
; 807: 		speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 808: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0249
L0248:
; 809: 		If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x37,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0250
; 810: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 811: 		Endif
L0250:
; 812: 	Endif
L0249:
; 813: 	Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0251:	BTFSC EECON1,WR
	GOTO L0251
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 814: 
; 815: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 816: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 817: 	If one_round = 0 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0252
; 818: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x1F
	MOVWF 0x3B
; 819: 	Endif
L0252:
; 820: 	If one_round > 60000 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
; 821: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x1F
	MOVWF 0x3B
; 822: 	Endif
L0253:
; 823: 	one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 824: 
; 825: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 826: 	If max_pos > 48 Or max_pos < 2 Then
	MOVF 0x3C,W
	SUBLW 0x30
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0256
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0255
L0256:
	MOVLW 0x02
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0254
L0255:
; 827: 		max_pos = 20
	MOVLW 0x14
	MOVWF 0x3C
; 828: 		bridge_rev_pos = 10
	MOVLW 0x0A
	MOVWF 0x41
; 829: 		Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0257:	BTFSC EECON1,WR
	GOTO L0257
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 830: 		Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0258:	BTFSC EECON1,WR
	GOTO L0258
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 831: 	Endif
L0254:
; 832: 	
; 833: 	Read mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 834: 	If bridge_rev_pos > max_pos Then
	MOVF 0x41,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0259
; 835: 		bridge_rev_pos = max_pos / 2
	MOVF 0x3C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x41
; 836: 		Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0260:	BTFSC EECON1,WR
	GOTO L0260
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 837: 	Endif
L0259:
; 838: 	
; 839: 	Read mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 840: 	If act_pos > max_pos Then
	MOVF 0x34,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0261
; 841: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x34
; 842: 		Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0262:	BTFSC EECON1,WR
	GOTO L0262
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 843: 	Endif
L0261:
; 844: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 845: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 846: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 847: 	If free_space_steps > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0263
; 848: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3D
; 849: 	Endif
L0263:
; 850: 	Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 851: 	If pos_match_delay > 50 Then
	MOVF 0x42,W
	SUBLW 0x32
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0264
; 852: 		pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x42
; 853: 	Endif
L0264:
; 854: 	
; 855: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 856: 	If speed_step > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0265
; 857: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x44
; 858: 	Endif
L0265:
; 859: 	steps_set = 0
	BCF 0x48,1
; 860: 	new_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x46
; 861: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x51
; 862: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5E
; 863: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 864: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5A
; 865: 	old_pos_write = 1
	BSF 0x5B,0
; 866: Return
	RETURN
; 867: 
; 868: steps_reading:
L0011:
; 869: 	Select Case act_pos
; 870: 	Case 63, 62
	MOVF 0x34,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0268
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0267
L0268:
	MOVF 0x34,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0266
L0267:
; 871: 		act_steps = 0
	CLRF 0x4F
	CLRF 0x50
; 872: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0269
L0266:
; 873: 		eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x47
; 874: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 875: 		Read act_pos, act_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4F
; 876: 		Read eprom_pointer, act_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x50
; 877: 	EndSelect
L0269:
; 878: 	Select Case new_pos
; 879: 	Case 62, 63
	MOVF 0x46,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0272
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0271
L0272:
	MOVF 0x46,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0270
L0271:
; 880: 		new_steps = 0
	CLRF 0x3F
	CLRF 0x40
; 881: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0273
L0270:
; 882: 		eprom_pointer = new_pos
	MOVF 0x46,W
	MOVWF 0x47
; 883: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 884: 		Read new_pos, new_steps.LB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 885: 		Read eprom_pointer, new_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 886: 	EndSelect
L0273:
; 887: Return
	RETURN
; 888: 
; 889: 
; 890: save_steps:
L0012:
; 891: 	eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x47
; 892: 	eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 893: 	Write act_pos, new_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0274:	BTFSC EECON1,WR
	GOTO L0274
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 894: 	Write eprom_pointer, new_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0275:	BTFSC EECON1,WR
	GOTO L0275
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 895: Return
	RETURN
; 896: 
; 897: 
; 898: stop_the_motor:
L0013:
; 899: 	ena = 0  'set anable oFF
	BCF 0x07,2
; 900: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 901: 	version = 0  'decimal point in display on
	BCF 0x48,3
; 902: 	While ecsw = 1
L0276:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0277
; 903: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 904: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 905: 		version = Not version
	MOVLW 0x08
	XORWF 0x48,F
; 906: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0276
L0277:
; 907: 	version = 1  'decimal point off
	BSF 0x48,3
; 908: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 909: 	ena = 1  'set anable on
	BSF 0x07,2
; 910: Return
	RETURN
; 911: wait_pos_match:
L0014:
; 912: 	value = 99
	MOVLW 0x63
	MOVWF 0x35
; 913: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 914: 	steps = pos_match_delay * 100
	MOVF 0x42,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x32
	MOVF R2H,W
	MOVWF 0x33
; 915: 	WaitMs steps
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 916: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 917: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 918: 	pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 919: Return
	RETURN
; 920: Proc run_to_zero(speed As Word, calc As Bit)
L0015:
; 921: 	While steps > 0  'NOW RUN UNTIL STEPS = 0
L0278:
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0279
; 922: 		If calc = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,6
	GOTO L0280
; 923: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 924: 		Endif
L0280:
; 925: 		
; 926: 		clk = 1  'clock out
	BSF 0x07,1
; 927: 		WaitUs speed
	MOVF 0x53,W
	MOVWF R4L
	MOVF 0x54,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 928: 		clk = 0
	BCF 0x07,1
; 929: 		WaitUs speed
	MOVF 0x53,W
	MOVWF R4L
	MOVF 0x54,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 930: 		Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 931: 		steps = steps - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 932: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0278
L0279:
; 933: 
; 934: End Proc
	RETURN
; 935: Proc run_to_zero_switch(bitposition As Bit, counting As Bit)
L0016:
; 936: 	If counting = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,7
	GOTO L0281
; 937: 		While zero = bitposition  'NOW RUN UNTIL switch is activated
L0282:
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x48,4
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0283
; 938: 			clk = 1  'clock out
	BSF 0x07,1
; 939: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 940: 			clk = 0
	BCF 0x07,1
; 941: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 942: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 943: 			one_round = one_round + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 944: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0282
L0283:
; 945: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0284
L0281:
; 946: 		While zero = bitposition  'NOW RUN UNTIL switch is activated
L0285:
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x48,4
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0286
; 947: 			clk = 1  'clock out
	BSF 0x07,1
; 948: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 949: 			clk = 0
	BCF 0x07,1
; 950: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 951: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 952: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0285
L0286:
; 953: 	Endif
L0284:
; 954: End Proc
	RETURN
; 955: 
; 956: Proc relays(onoff As Bit)
L0017:
; 957: 		If act_pos < bridge_rev_pos Or bridge_rev_pos = 0 Then  'just normal Bridge power (if allowed)
	MOVF 0x41,W
	SUBWF 0x34,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0289
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0288
L0289:
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0287
L0288:
; 958: 			swfw = 0
	BCF 0x06,0
; 959: 			WaitMs 100  'just wait for the relay to drop
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 960: 			If onoff = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x48,2
	GOTO L0290
; 961: 				swrev = bridge_power.0
	BTFSC 0x49,0
	BSF 0x06,1
	BTFSS 0x49,0
	BCF 0x06,1
; 962: 			Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0291
L0290:
; 963: 				swrev = 1
	BSF 0x06,1
; 964: 			Endif
L0291:
; 965: 		Else  'inverse bridge power (if allowed)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0292
L0287:
; 966: 			swrev = 0
	BCF 0x06,1
; 967: 			WaitMs 100  'just wait for the relay to drop
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 968: 			If onoff = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x48,2
	GOTO L0293
; 969: 				swfw = bridge_power.0
	BTFSC 0x49,0
	BSF 0x06,0
	BTFSS 0x49,0
	BCF 0x06,0
; 970: 			Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0294
L0293:
; 971: 				swfw = 1
	BSF 0x06,0
; 972: 			Endif
L0294:
; 973: 		Endif
L0292:
; 974: End Proc
	RETURN
; 975: Proc check_encoder_count()
L0018:
; 976: 	If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x45,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0295
; 977: 		encoder_count = encoder_count + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 978: 		proceed = 0
	BCF 0x48,0
; 979: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0296
L0295:
; 980: 		encoder_count = 0
	CLRF 0x45
; 981: 		proceed = 1
	BSF 0x48,0
; 982: 	Endif
L0296:
; 983: End Proc
	RETURN
; End of program
;       PAGE SELECT
	BSF PCLATH,3
L0297:	GOTO L0297
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
