Define CONF_WORD = 0x31c4
Dim program As Byte
Dim program_enable As Bit
Dim dummy As Byte
Dim counter As Byte
Dim counter2 As Byte
Dim result As Byte
Dim led1 As Byte
Dim led2 As Byte
Dim led3 As Byte
Dim led4 As Byte
Dim on_time As Byte
Dim off_time As Byte
Const maxprogram = 11
TRISIO = %001000
AllDigital
GPIO = 63
Read 0, program  'get actual program from eeprom
If program > maxprogram Then
	program = maxprogram
Endif
GPIO = %000000
Call set_ports(program)
WaitMs 1000
program_enable = 0
dummy = 1
main:
While dummy = 1  'endless loop
	led1 = led1 + 1
	led2 = led2 + 1
	led3 = led3 + 1
	led4 = led4 + 1
	
	Select Case program
	Case 1  'night rider
		Select Case led1
		Case 0, 8
			GPIO = %010000
			WaitMs 50
		Case 1, 7
			GPIO = %000100
		Case 2, 6
			GPIO = %000010
		Case 3, 5
			GPIO = %000001
		Case 4
			GPIO = %100000
			WaitMs 50
		Case Else
			led1 = 0
		EndSelect
		WaitMs 100
	Case 2  'police flash
		led2 = led2 Mod 43
		led1 = led1 Mod 39
		counter = 0
		Select Case led1
		Case 4, 6, 8, 10, 12, 14, 16, 18
			counter.4 = 1
		Case 24, 26, 28, 30, 32, 34, 36, 38
			counter.2 = 1
		Case Else
		EndSelect
		Select Case led2
		Case 4, 6, 8, 10, 12, 14, 16, 18, 20
			counter.1 = 1
		Case 26, 28, 30, 32, 34, 36, 38, 40, 42
			counter.0 = 1
		Case Else
		EndSelect
		GPIO = counter
		WaitMs 30  'just wait 30 mSecs

	Case 3  'fire dep. car flashes
		led1 = led1 Mod 250
		led3 = led3 Mod 245
		led4 = led4 Mod 241
		counter = 0
		If led1 < 45 Then
			counter.4 = 1  '1st led on
		Endif
		If led2 < 45 Then
			counter.2 = 1  '2nd led on
		Endif
		If led3 < 45 Then
			counter.1 = 1  '3RD led on
		Endif
		If led4 < 45 Then
			counter.0 = 1  '4TH LED ON
		Endif
		GPIO = counter
		WaitUs 1500  'just wait 1,5 mSec

	Case 4  'high tower flashes
		If led1 < 10 Then
			GPIO = %110111  'all leds On
		Else
			GPIO = %000000  'all leds off
		Endif
		WaitMs 10
	Case 5  'road blockade
		If led1 > 79 Then
			led1 = 0
		Endif
		Select Case led1
		Case 0
			GPIO = %010000
			WaitMs 25
			GPIO = %000000
		Case 1
			GPIO = %000100
			WaitMs 25
			GPIO = %000000
		Case 2
			GPIO = %000010
			WaitMs 25
			GPIO = %000000
		Case 3
			GPIO = %000001
			WaitMs 25
			GPIO = %000000
		Case 4
			GPIO = %100000
			WaitMs 25
			GPIO = %000000
		Case Else
		EndSelect
		WaitMs 25
	Case 6  'traffics lights flash (led 4 and 5)
		If led1 < 100 Then
			GPIO = %010010
		Else
			GPIO = %000101
		Endif
		WaitMs 4
	Case 7, 8  'traffic lights dutch and german pattern
		Select Case led1
		Case 1  'red
			GPIO = %010000
		Case 10, 11  'yellow
			If program = 8 Then  'german
				GPIO = %010100
			Else  'dutch
				GPIO = %000100
			Endif
		Case 12  'green
			GPIO = %000010
		Case 21  'yellow
			GPIO = %000100
		Case 22
			led1 = 0
		Case Else
		EndSelect
		WaitMs 1500
	Case 9  'red and white flashes for railroad crossing
		If GPIO.5 = 0 Then  'red flashes need to be activated
			led1 = led1 Mod 12
			If led1 < 6 Then
				GPIO = %000100
			Else
				GPIO = %000010
			Endif
			WaitMs 50
		Else
			led1 = led1 Mod 20
			If led1 = 0 Then
				GPIO = %010000
			Else
				GPIO = %000000
			Endif
		Endif
		WaitMs 100
	Case 10  'railroad crossing for German system.
		If GPIO.5 = 0 Then
			If program_enable = 0 Then
				GPIO = %110000  'Orange led on
				WaitMs 3000
				GPIO = %100100  'red led on
				WaitMs 6000
				GPIO = %100110  'red led + command for 1st barrier to go down.
				WaitMs 6000
				GPIO = %100111  'red led + 1st and second barrier down
				program_enable = 1  'this sequence only once
			Endif
		Else
			If program_enable = 1 Then
				GPIO = %100100  'barriers up and red led on
				WaitMs 6000
				GPIO = %100000  'led off
				program_enable = 0  'this sequence only once
			Endif
		Endif

	Case Else  'led 1 makes simulation of welding flashes. also useable as TV simulation
		For counter = 0 To 29
			counter2 = counter + result
			While counter2 > 29
				counter2 = counter2 - 29
			Wend
			on_time = LookUp(2, 14, 13, 6, 8, 15, 2, 22, 18, 3, 9, 11, 17, 4, 7, 21, 12, 4, 6, 6, 18, 3, 18, 14, 15, 16, 4, 8, 9, 7), counter
			off_time = LookUp(9, 11, 17, 4, 7, 21, 22, 4, 6, 6, 13, 3, 18, 3, 18, 14, 11, 16, 4, 8, 9, 2, 24, 13, 6, 8, 15, 2, 12, 18), counter2
			on_time = on_time * 10
			off_time = off_time * 10
			If on_time > 13 Then
				GPIO = %011001
			Else
				GPIO = %011000
			Endif
			WaitMs on_time
			If counter2 > 13 Then
				GPIO = %001010
			Else
				GPIO = %001000
			Endif
			WaitMs off_time
			If GPIO.3 = 0 Then
				counter = 29
			Endif
		Next counter
	EndSelect
	If GPIO.3 = 0 Then
		GPIO = %000000
		program = program + 1
		If program > maxprogram Then
			program = 1
		Endif
		Call set_ports(program)
		Write 0, program
		WaitMs 250
		While GPIO.3 = 0
			WaitMs 250
		Wend
		led1 = 0
		led2 = 0
	Endif
Wend

End                                               

Proc set_ports(program As Byte)
	Select Case program
	Case 9, 10
		TRISIO = %101000  'gpio5 is need for input
		WPU.5 = 1  'set internal weak pull-up
	Case Else
		TRISIO = %001000
		WPU.5 = 0
	EndSelect

End Proc                                          
