'Program for Serial Programming Leds 8 bit version
'processor PIC16F688  4 MHz
Define CONFIG = 0x33c4
Define CLOCK_FREQUENCY = 8
AllDigital
TRISA = %001000
TRISC = %110000
OSCCON.4 = 1
OSCCON.5 = 1
OSCCON.6 = 1
Dim character As Byte
Dim character_count As Byte  'this byte stores which received character is to be handled
Dim old_adress As Byte
Dim new_adress As Byte
Dim adress As Byte  'adress to be matched with decie_address
Dim device_adress As Byte
Dim leds As Byte
Dim command_type As Byte

Symbol led1 = RC2
Symbol led2 = RC1
Symbol led3 = RC0
Symbol led4 = RA2
Symbol led5 = RA1
Symbol led6 = RA4
Symbol led7 = RA0
Symbol led8 = RA5
Symbol led9 = RC3
Hseropen 9600  'set serial receive to 9600 bd
led9 = 0
WaitMs 1000
character_count = 0
'Read 0, device_adress  'get the address of this chip
'********************************************
'temporary, to be removed later on
'If device_adress = 255 Then
device_adress = 2
'Write 0, device_adress
'Endif
'********************************************
Call set_leds(device_adress)  'show programmed address
'waitms 2000
'Call set_leds(0)  'leds remain on, until first message.
command_type = 0
leds = 0
adress = 0

main:
	led9 = 1  'led off
	Hserin character

		character_count = character_count + 1
		led9 = 0  'led on
		command_type = 0
		Select Case character_count
		Case 1
			If character <> 72 Then  '*  'H' received?
				character_count = 0  'wrong character , start again
			Endif
		Case 2
			Call convert_ascii()
			adress = character * 16
			old_adress = adress
		Case 3
			Call convert_ascii()
			adress = old_adress Or character
			old_adress = adress
		Case 4
			If character = 83 Then  '*  'S'received
				command_type = 1
			Else
				If character = 80 Then  '*  'P' received
					command_type = 2
				Else
					character_count = 0  'BETTER START AGAIN
				Endif
			Endif
		Case 5
			Select Case command_type
			Case 1
				Call convert_ascii()
				leds = character * 16
			Case 2
				If character <> 97 Then  '*  'a'received?
					command_type = 0
					character_count = 0  'wrong character , start again
				Endif
			Case Else
			EndSelect
		Case 6
			Select Case command_type
			Case 1
				Call convert_ascii()
				leds = leds Or character
			Case 2
				If character <> 97 Then  '*  'a'received?
					command_type = 0
					character_count = 0  'wrong character , start again
				Endif
			Case Else
			EndSelect
		Case 7
			Select Case command_type
			Case 1
				character_count = 0  'END OF TRANSMISSION
				If character = 13 Then  'only when CR received
					If adress = device_adress Then
						Call set_leds(leds)
					Endif
				Endif
			Case 2
				If character <> 53 Then  '*  '5'received?
					command_type = 0
					character_count = 0  'wrong character , start again
				Endif
			Case Else
			EndSelect
		Case 8
			If command_type = 2 Then
				If character <> 53 Then  '*  '5'received?
					command_type = 0
					character_count = 0  'wrong character , start again
				Endif
			Endif
		Case 9
			Call convert_ascii()
			new_adress = character * 16
		Case 10
			Call convert_ascii()
			new_adress = new_adress Or character
		Case 11
			character_count = 0
			If character = 13 Then
				Gosub setadress
			Endif
		Case Else
		EndSelect

Goto main
End                                               

Proc set_leds(value As Byte)
	led1 = value.0
	led2 = value.1
	led3 = value.2
	led4 = value.3
	led5 = value.4
	led6 = value.5
	led7 = value.6
	led8 = value.7
End Proc                                          

setadress:
	If device_adress = old_adress Then
		Write 0, new_adress
		device_adress = new_adress
	Endif
Return                                            

Proc convert_ascii(value As Byte)  'convert ascii value to binairy
	If value > 57 Then
		value = value - 55  'A..F > 10..15'
	Else
		value = value - 48  '0..9
	Endif
End Proc                                          

