; Compiled with: PIC Simulator IDE v7.37
; Microcontroller model: PIC16F688
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R3H EQU 0x027
	R4L EQU 0x028
	R4H EQU 0x029
	R5L EQU 0x02A
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R3HL EQU 0x026
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	R3HL2HL EQU 0x024
	LONG_0 EQU 0x02B
	LONG_1 EQU 0x02C
	LONG_2 EQU 0x02D
	LONG_3 EQU 0x02E
	LONG2_0 EQU 0x02F
	LONG2_1 EQU 0x030
	LONG2_2 EQU 0x031
	LONG2_3 EQU 0x032
	LONG1 EQU 0x02B
	LONG2 EQU 0x02F
	REGSTEP EQU 0x033
	W_TEMP EQU 0x07F
	STATUS_TEMP EQU 0x07E
;       The address of 'servo_speed' (word) (global) is 0x036
;       The address of 'pause_time' (word) (global) is 0x039
;       The address of 'program' (byte) (global) is 0x038
;       The address of 'pause_timer' (word) (global) is 0x034
;       The address of 'old_pause_timer' (word) (global) is 0x03B
;       The address of 'led' (bit) (global) is 0x005,2
;       The address of 'fw_rev' (bit) (global) is 0x007,1
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	MOVWF W_TEMP
	SWAPF STATUS,W
	CLRF STATUS
	MOVWF STATUS_TEMP
	CALL L0003
	SWAPF STATUS_TEMP,W
	MOVWF STATUS
	SWAPF W_TEMP,F
	SWAPF W_TEMP,W
	RETFIE
; User code start
L0002:
; 1: Define CONFIG = 0x33c4
; 2: 
; 3: 
; 4: 'program GCA198
; 5: 'this is the version for GCA198 with dip-switch and PIC16F688 processor
; 6: 'SW1-1 is ON for full step and OF  for half step
; 7: 'SW1-2 is ON for forward and OFF for reverse
; 8: 'program is universal for monophase stepper motors (5 connections )
; 9: 'mainly issued for use with steppermotor 28BYJ-48
; 10: Define STEP_A_REG = PORTC
; 11: Define STEP_A_BIT = 3
; 12: Define STEP_B_REG = PORTC
; 13: Define STEP_B_BIT = 4
; 14: Define STEP_C_REG = PORTC
; 15: Define STEP_C_BIT = 5
; 16: Define STEP_D_REG = PORTC
; 17: Define STEP_D_BIT = 2
; 18: If RC0 = 0 Then  'half step selected
	BTFSC 0x007,0
	GOTO L0004
; 19: Define STEP_MODE = 2
; 20: Else  'full step mode
	GOTO L0005
L0004:
; 21: Define STEP_MODE = 1
; 22: Endif
L0005:
; 23: 
; 24: TRISA = %111011
	MOVLW 0x3B
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 25: TRISC = %000011
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF TRISC
; 26: AllDigital
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON0
; 27: ANSEL = %110000
	MOVLW 0x30
	BSF STATUS,RP0
	MOVWF ANSEL
	BCF STATUS,RP0
; 28: StepHold
	BSF PORTC,3
	BSF PORTC,4
	BCF PORTC,5
	BCF PORTC,2
	BSF STATUS,RP0
	BCF TRISC,3
	BCF TRISC,4
	BCF TRISC,5
	BCF TRISC,2
	BCF STATUS,RP0
	CLRF REGSTEP
; 29: Dim servo_speed As Word
	CLRF 0x036
	CLRF 0x037
; 30: Dim pause_time As Word
	CLRF 0x039
	CLRF 0x03A
; 31: Dim program As Byte
	CLRF 0x038
; 32: Dim pause_timer As Word
	CLRF 0x034
	CLRF 0x035
; 33: Dim old_pause_timer As Word
	CLRF 0x03B
	CLRF 0x03C
; 34: Symbol led = RA2
; 35: Symbol fw_rev = RC1
; 36: OPTION_REG.T0CS = 0  'bit 5 TMR0 Clock Source Select bit:0=Internal Clock (CLKO) / 1=Transition on T0CKI pin
	BSF STATUS,RP0
	BCF OPTION_REG,5
; 37: OPTION_REG.T0SE = 0  'bit 4 TMR0 Source Edge Select bit: 0=low/high / 1=high/low
	BCF OPTION_REG,4
; 38: OPTION_REG.PSA = 0  'bit 3 Prescaler Assignment bit: 0=Prescaler is assigned to the WDT
	BCF OPTION_REG,3
; 39: OPTION_REG.PS2 = 0  'bits 2-0  PS2:PS0: Prescaler Rate Select bits
	BCF OPTION_REG,2
; 40: OPTION_REG.PS1 = 0
	BCF OPTION_REG,1
; 41: OPTION_REG.PS0 = 0
	BCF OPTION_REG,0
	BCF STATUS,RP0
; 42: TMR0 = 56  'preset for timer register
	MOVLW 0x38
	MOVWF TMR0
; 43: 
; 44: led = 1  'LED OFF
	BSF PORTA,2
; 45: Adcin 4, servo_speed
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	MOVLW 0x04
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x036
	MOVF ADRESH,W
	MOVWF 0x037
; 46: servo_speed = servo_speed * 60
	MOVF 0x036,W
	MOVWF R3L
	MOVF 0x037,W
	MOVWF R3H
	MOVLW 0x3C
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x036
	MOVF R2H,W
	MOVWF 0x037
; 47: servo_speed = servo_speed + 500
	MOVF 0x036,W
	ADDLW 0xF4
	MOVWF 0x036
	MOVF 0x037,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x037
; 48: Adcin 5, pause_time
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	MOVLW 0x05
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x039
	MOVF ADRESH,W
	MOVWF 0x03A
; 49: program = 0
	CLRF 0x038
; 50: pause_timer = 0
	CLRF 0x034
	CLRF 0x035
; 51: Enable
	BSF INTCON,GIE
; 52: main:
L0001:
; 53: Adcin 2, servo_speed
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	MOVLW 0x02
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x036
	MOVF ADRESH,W
	MOVWF 0x037
; 54: servo_speed = servo_speed * 60
	MOVF 0x036,W
	MOVWF R3L
	MOVF 0x037,W
	MOVWF R3H
	MOVLW 0x3C
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x036
	MOVF R2H,W
	MOVWF 0x037
; 55: servo_speed = servo_speed + 500
	MOVF 0x036,W
	ADDLW 0xF4
	MOVWF 0x036
	MOVF 0x037,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x037
; 56: If pause_time < 50 Then  'continous run
	MOVF 0x039,W
	MOVWF R0L
	MOVF 0x03A,W
	MOVWF R0H
	MOVLW 0x32
	MOVWF R1L
	CLRF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0006
; 57: If fw_rev = 1 Then
	BTFSS 0x007,1
	GOTO L0007
; 58: StepCW 1, servo_speed
	MOVLW 0x01
	MOVWF R5L
	MOVF R5L,F
	BTFSC STATUS,Z
	GOTO L0009
L0008:
	CALL ST01
	MOVF 0x036,W
	MOVWF R4L
	MOVF 0x037,W
	MOVWF R4H
	CALL Y001
	DECFSZ R5L,F
	GOTO L0008
L0009:
; 59: Else
	GOTO L0010
L0007:
; 60: StepCCW 1, servo_speed
	MOVLW 0x01
	MOVWF R5L
	MOVF R5L,F
	BTFSC STATUS,Z
	GOTO L0012
L0011:
	CALL ST02
	MOVF 0x036,W
	MOVWF R4L
	MOVF 0x037,W
	MOVWF R4H
	CALL Y001
	DECFSZ R5L,F
	GOTO L0011
L0012:
; 61: Endif
L0010:
; 62: led = 0
	BCF PORTA,2
; 63: Else
	GOTO L0013
L0006:
; 64: 'NOW p1 IS USED FOR INTERVAL SET
; 65: Adcin 2, pause_time
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	MOVLW 0x02
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x039
	MOVF ADRESH,W
	MOVWF 0x03A
; 66: Select Case program
; 67: Case 0  'motor runs
	MOVF 0x038,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0014
; 68: If pause_timer < pause_time Then
	MOVF 0x034,W
	MOVWF R0L
	MOVF 0x035,W
	MOVWF R0H
	MOVF 0x039,W
	MOVWF R1L
	MOVF 0x03A,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0015
; 69: pause_timer = pause_timer + 1
	MOVF 0x034,W
	ADDLW 0x01
	MOVWF 0x034
	MOVF 0x035,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x035
; 70: If fw_rev = 1 Then
	BTFSS 0x007,1
	GOTO L0016
; 71: StepCW 1, servo_speed
	MOVLW 0x01
	MOVWF R5L
	MOVF R5L,F
	BTFSC STATUS,Z
	GOTO L0018
L0017:
	CALL ST01
	MOVF 0x036,W
	MOVWF R4L
	MOVF 0x037,W
	MOVWF R4H
	CALL Y001
	DECFSZ R5L,F
	GOTO L0017
L0018:
; 72: Else
	GOTO L0019
L0016:
; 73: StepCCW 1, servo_speed
	MOVLW 0x01
	MOVWF R5L
	MOVF R5L,F
	BTFSC STATUS,Z
	GOTO L0021
L0020:
	CALL ST02
	MOVF 0x036,W
	MOVWF R4L
	MOVF 0x037,W
	MOVWF R4H
	CALL Y001
	DECFSZ R5L,F
	GOTO L0020
L0021:
; 74: Endif
L0019:
; 75: led = 0
	BCF PORTA,2
; 76: Else
	GOTO L0022
L0015:
; 77: pause_timer = 0
	CLRF 0x034
	CLRF 0x035
; 78: program = 1
	MOVLW 0x01
	MOVWF 0x038
; 79: Endif
L0022:
; 80: Case Else  'motor stop, interval timing
	GOTO L0023
L0014:
; 81: While old_pause_timer = pause_timer
L0024:
	MOVF 0x03B,W
	MOVWF R0L
	MOVF 0x03C,W
	MOVWF R0H
	MOVF 0x034,W
	MOVWF R1L
	MOVF 0x035,W
	MOVWF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0025
; 82: Wend
	GOTO L0024
L0025:
; 83: old_pause_timer = pause_timer
	MOVF 0x034,W
	MOVWF 0x03B
	MOVF 0x035,W
	MOVWF 0x03C
; 84: If pause_timer < pause_time Then
	MOVF 0x034,W
	MOVWF R0L
	MOVF 0x035,W
	MOVWF R0H
	MOVF 0x039,W
	MOVWF R1L
	MOVF 0x03A,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0026
; 85: pause_timer = pause_timer + 1
	MOVF 0x034,W
	ADDLW 0x01
	MOVWF 0x034
	MOVF 0x035,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x035
; 86: led = pause_timer.3
	BCF PORTA,2
	BTFSC 0x034,3
	BSF PORTA,2
; 87: Else
	GOTO L0027
L0026:
; 88: pause_timer = 0
	CLRF 0x034
	CLRF 0x035
; 89: program = 0
	CLRF 0x038
; 90: Endif
L0027:
; 91: EndSelect
L0023:
; 92: Endif
L0013:
; 93: Goto main
	GOTO L0001
; 94: End
L0028:	GOTO L0028
; 95: On Interrupt  'this routine increases speed_timer each 1/100 second
L0003:
; 96: pause_timer = pause_timer + 1  'counts 100x pro second, so p2 set full = 1023 = 10,23 secs
	MOVF 0x034,W
	ADDLW 0x01
	MOVWF 0x034
	MOVF 0x035,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x035
; 97: TMR0 = 59
	MOVLW 0x3B
	MOVWF TMR0
; 98: INTCON.T0IF = 0  'clear timer interrupt flag
	BCF INTCON,2
; 99: INTCON.GIE = 1
	BSF INTCON,7
; 100: Resume
	RETURN
; End of user code
L0029:	GOTO L0029
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitus Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
;
;
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x05
	MOVWF R4L
	CALL DL01
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Stepper Routine
ST01:	INCF REGSTEP,F
	GOTO ST03
ST02:	DECF REGSTEP,F
ST03:
	BTFSC REGSTEP,1
	GOTO ST04
	BTFSC REGSTEP,0
	GOTO ST21
	GOTO ST20
ST04:
	BTFSC REGSTEP,0
	GOTO ST23
	GOTO ST22
ST20:
	BSF PORTC,3
	BSF PORTC,4
	BCF PORTC,5
	BCF PORTC,2
	RETURN
ST21:
	BCF PORTC,3
	BSF PORTC,4
	BSF PORTC,5
	BCF PORTC,2
	RETURN
ST22:
	BCF PORTC,3
	BCF PORTC,4
	BSF PORTC,5
	BSF PORTC,2
	RETURN
ST23:
	BSF PORTC,3
	BCF PORTC,4
	BCF PORTC,5
	BSF PORTC,2
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x33C4
; End of listing
	END
