; Compiled with: PIC Simulator IDE v7.51
; Microcontroller model: PIC16F628A
; Clock frequency: 20.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
;       The value of 'maxdelay' (global) is 50
;       The address of 'flasher' (byte) (global) is 0x03A
;       The address of 'route' (byte) (global) is 0x027
;       The address of 'speed' (byte) (global) is 0x034
;       The address of 'maxspeed_fw' (byte) (global) is 0x035
;       The address of 'run' (bit) (global) is 0x032,0
;       The address of 'delay_right' (byte) (global) is 0x036
;       The address of 'delay_mid' (byte) (global) is 0x037
;       The address of 'delay_left' (byte) (global) is 0x038
;       The address of 'delay' (byte) (global) is 0x033
;       The address of 'acc_time' (byte) (global) is 0x039
;       The address of 'direction' (bit) (motordirection) is 0x032,1
;       The address of 'time' (byte) (indicate_delay) is 0x03B
;       The address of 'which' (byte) (indicate_delay) is 0x03C
;       The address of 'pluskey' (bit) (global) is 0x006,6
;       The address of 'minuskey' (bit) (global) is 0x006,5
;       The address of 'shiftkey' (bit) (global) is 0x006,7
;       The address of 'stopleft' (bit) (global) is 0x005,0
;       The address of 'stopmid' (bit) (global) is 0x005,2
;       The address of 'stopright' (bit) (global) is 0x005,1
;       The address of 'stopextra' (bit) (global) is 0x005,5
;       The address of 'leftled' (bit) (global) is 0x005,3
;       The address of 'rightled' (bit) (global) is 0x005,4
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0006
	ORG 0x0004
	RETFIE
; User code start
L0006:
; 1: Define CONF_WORD = 0x3f50
; 2: 
; 3: 'Commuter program for MGV140 unit definitve version with 3 pushbuttons
; 4: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 5: TRISA = %11100111
	MOVLW 0xE7
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 6: TRISB = %11100000
	MOVLW 0xE0
	BSF STATUS,RP0
	MOVWF TRISB
	BCF STATUS,RP0
; 7: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 8: PORTA = 255
	MOVLW 0xFF
	MOVWF PORTA
; 9: 
; 10: Symbol pluskey = RB6
; 11: Symbol minuskey = RB5
; 12: Symbol shiftkey = RB7
; 13: Symbol stopleft = RA0
; 14: Symbol stopmid = RA2
; 15: Symbol stopright = RA1
; 16: Symbol stopextra = RA5
; 17: Symbol leftled = RA3
; 18: Symbol rightled = RA4
; 19: Dim flasher As Byte
; 20: Dim route As Byte
; 21: Dim speed As Byte
; 22: Dim maxspeed_fw As Byte
; 23: 'Dim maxspeed_rev As Byte
; 24: Dim run As Bit
; 25: Dim delay_right As Byte
; 26: Dim delay_mid As Byte
; 27: Dim delay_left As Byte
; 28: Dim delay As Byte
; 29: Dim acc_time As Byte
; 30: Const maxdelay = 50
; 31: 'WaitMs 1000
; 32: Read 0, maxspeed_fw
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x035
; 33: If maxspeed_fw > 240 Then
	MOVF 0x035,W
	SUBLW 0xF0
	BTFSC STATUS,C
	GOTO L0007
; 34: maxspeed_fw = 125
	MOVLW 0x7D
	MOVWF 0x035
; 35: Write 0, maxspeed_fw
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x035,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0008:	BTFSC EECON1,WR
	GOTO L0008
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 36: Endif
L0007:
; 37: If maxspeed_fw < 30 Then
	MOVLW 0x1E
	SUBWF 0x035,W
	BTFSC STATUS,C
	GOTO L0009
; 38: maxspeed_fw = 30
	MOVLW 0x1E
	MOVWF 0x035
; 39: Write 0, maxspeed_fw
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x035,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0010:	BTFSC EECON1,WR
	GOTO L0010
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 40: Endif
L0009:
; 41: Read 1, delay_right
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x036
; 42: If delay_right > maxdelay Then
	MOVF 0x036,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0011
; 43: delay_right = maxdelay  '2 seconds to start with
	MOVLW 0x32
	MOVWF 0x036
; 44: Write 1, delay_right
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x036,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0012:	BTFSC EECON1,WR
	GOTO L0012
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 45: Endif
L0011:
; 46: Read 2, delay_mid
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x037
; 47: If delay_mid > maxdelay Then
	MOVF 0x037,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0013
; 48: delay_mid = maxdelay  '2 seconds to start with
	MOVLW 0x32
	MOVWF 0x037
; 49: Write 2, delay_mid
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x037,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0014:	BTFSC EECON1,WR
	GOTO L0014
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 50: Endif
L0013:
; 51: Read 3, delay_left
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x038
; 52: If delay_left > maxdelay Then
	MOVF 0x038,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0015
; 53: delay_left = maxdelay  '2 seconds to start with
	MOVLW 0x32
	MOVWF 0x038
; 54: Write 3, delay_left
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x038,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0016:	BTFSC EECON1,WR
	GOTO L0016
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 55: Endif
L0015:
; 56: PWMon 1, 7
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BSF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 57: PWMduty 1, 0
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x00
	MOVWF CCPR1L
; 58: route = 0
	CLRF 0x027
; 59: If stopright = 0 Then
	BTFSC 0x005,1
	GOTO L0017
; 60: route = 4
	MOVLW 0x04
	MOVWF 0x027
; 61: Endif
L0017:
; 62: If stopmid = 0 Then
	BTFSC 0x005,2
	GOTO L0018
; 63: route = 2
	MOVLW 0x02
	MOVWF 0x027
; 64: Endif
L0018:
; 65: Call calc_acc()
	CALL L0004
; 66: main:
L0001:
; 67: Select Case route
; 68: Case 0  'loc = in left hand side position
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0019
; 69: run = 0  'lok stopped
	BCF 0x032,0
; 70: rightled = 1
	BSF PORTA,4
; 71: leftled = flasher.2
	BTFSS 0x03A,2
	BCF PORTA,3
	BTFSC 0x03A,2
	BSF PORTA,3
; 72: If delay > 0 Then  'lok waiting for timeout
	MOVF 0x033,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0020
; 73: If speed = 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0021
; 74: delay = delay - 1
	DECF 0x033,F
; 75: Endif
L0021:
; 76: Else  'time is up
	GOTO L0022
L0020:
; 77: route = 1  'next route step
	MOVLW 0x01
	MOVWF 0x027
; 78: run = 1  'start lok
	BSF 0x032,0
; 79: Call motordirection(0)  'set correect direction
	BCF 0x032,1
	CALL L0002
; 80: Endif
L0022:
; 81: Case 1  'running 'right towards midsection
	GOTO L0023
L0019:
	MOVF 0x027,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0024
; 82: run = 1  'lok running
	BSF 0x032,0
; 83: leftled = 1  'left led off
	BSF PORTA,3
; 84: rightled = 0  'right led on
	BCF PORTA,4
; 85: Call motordirection(0)  'set correct direction
	BCF 0x032,1
	CALL L0002
; 86: If stopmid = 0 Then  'arrival in station
	BTFSC 0x005,2
	GOTO L0025
; 87: run = 0  'stop loc
	BCF 0x032,0
; 88: delay = delay_mid  'start timeout
	MOVF 0x037,W
	MOVWF 0x033
; 89: route = route + 1  'next route step
	INCF 0x027,F
; 90: Endif
L0025:
; 91: If stopright = 0 Then  'arrival on left end position
	BTFSC 0x005,1
	GOTO L0026
; 92: run = 0  'stop engine
	BCF 0x032,0
; 93: delay = delay_right  'start timeout
	MOVF 0x036,W
	MOVWF 0x033
; 94: route = 4  'stepover to correct next route
	MOVLW 0x04
	MOVWF 0x027
; 95: Endif
L0026:
; 96: Case 2  'loc = in mid position to go right
	GOTO L0027
L0024:
	MOVF 0x027,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0028
; 97: run = 0  'stop engine
	BCF 0x032,0
; 98: leftled = 1  'lefd led off
	BSF PORTA,3
; 99: rightled = flasher.3  'blink right led
	BTFSS 0x03A,3
	BCF PORTA,4
	BTFSC 0x03A,3
	BSF PORTA,4
; 100: If delay > 0 Then  'loc waiting for timeout
	MOVF 0x033,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0029
; 101: If speed = 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0030
; 102: delay = delay - 1
	DECF 0x033,F
; 103: Endif
L0030:
; 104: Else  'time is up
	GOTO L0031
L0029:
; 105: route = 3  'next route step
	MOVLW 0x03
	MOVWF 0x027
; 106: run = 1  'start loc
	BSF 0x032,0
; 107: Call motordirection(0)  'select correct direction
	BCF 0x032,1
	CALL L0002
; 108: Endif
L0031:
; 109: Case 3  'running 'right towards end
	GOTO L0032
L0028:
	MOVF 0x027,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0033
; 110: run = 1  'start loc
	BSF 0x032,0
; 111: leftled = 1  'left led off
	BSF PORTA,3
; 112: rightled = 0  'right led on
	BCF PORTA,4
; 113: Call motordirection(0)  'select correct direction
	BCF 0x032,1
	CALL L0002
; 114: If stopright = 0 Then  'arrival in right had stop section?
	BTFSC 0x005,1
	GOTO L0034
; 115: run = 0  'stop engine
	BCF 0x032,0
; 116: delay = delay_right  'set timeout
	MOVF 0x036,W
	MOVWF 0x033
; 117: route = 4  'set next route step
	MOVLW 0x04
	MOVWF 0x027
; 118: Endif
L0034:
; 119: Case 4  'loc = in right hand side position
	GOTO L0035
L0033:
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0036
; 120: run = 0  'stop engine
	BCF 0x032,0
; 121: rightled = flasher.2  'right led off
	BTFSS 0x03A,2
	BCF PORTA,4
	BTFSC 0x03A,2
	BSF PORTA,4
; 122: leftled = 1  'blink left led
	BSF PORTA,3
; 123: If delay > 0 Then  'waiting for timeout
	MOVF 0x033,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0037
; 124: If speed = 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0038
; 125: delay = delay - 1
	DECF 0x033,F
; 126: Endif
L0038:
; 127: Else  'time is up
	GOTO L0039
L0037:
; 128: route = 5  'set next route
	MOVLW 0x05
	MOVWF 0x027
; 129: run = 1  'start engine
	BSF 0x032,0
; 130: Call motordirection(1)  'select correct direction
	BSF 0x032,1
	CALL L0002
; 131: Endif
L0039:
; 132: Case 5  'running 'left towards midsection
	GOTO L0040
L0036:
	MOVF 0x027,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0041
; 133: run = 1  'start engine
	BSF 0x032,0
; 134: rightled = 1  'right led off
	BSF PORTA,4
; 135: leftled = 0  'left led on
	BCF PORTA,3
; 136: Call motordirection(1)  'set correct direction
	BSF 0x032,1
	CALL L0002
; 137: If stopextra = 0 Then  'arrival in station?
	BTFSC 0x005,5
	GOTO L0042
; 138: run = 0  'stop loc
	BCF 0x032,0
; 139: delay = delay_mid  'set timeout
	MOVF 0x037,W
	MOVWF 0x033
; 140: route = route + 1  'set next route step
	INCF 0x027,F
; 141: Endif
L0042:
; 142: If stopleft = 0 Then  'arrival in left end station
	BTFSC 0x005,0
	GOTO L0043
; 143: run = 0  'stop loc
	BCF 0x032,0
; 144: delay = delay_left  'set timeout
	MOVF 0x038,W
	MOVWF 0x033
; 145: route = 0  'loc is at left end position
	CLRF 0x027
; 146: Endif
L0043:
; 147: Case 6  'loc = in mid position to go left
	GOTO L0044
L0041:
	MOVF 0x027,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0045
; 148: run = 0  'stop engine
	BCF 0x032,0
; 149: rightled = 1  'right led off
	BSF PORTA,4
; 150: leftled = flasher.3  'blink left led
	BTFSS 0x03A,3
	BCF PORTA,3
	BTFSC 0x03A,3
	BSF PORTA,3
; 151: If delay > 0 Then  'waiting for timeout
	MOVF 0x033,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0046
; 152: If speed = 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0047
; 153: delay = delay - 1
	DECF 0x033,F
; 154: Endif
L0047:
; 155: Else  'time is up
	GOTO L0048
L0046:
; 156: route = 7  'set next route step
	MOVLW 0x07
	MOVWF 0x027
; 157: run = 1  'start loc
	BSF 0x032,0
; 158: Call motordirection(1)  'set correct direction
	BSF 0x032,1
	CALL L0002
; 159: Endif
L0048:
; 160: Case 7  'running left towards end
	GOTO L0049
L0045:
	MOVF 0x027,W
	SUBLW 0x07
	BTFSS STATUS,Z
	GOTO L0050
; 161: run = 1  'start loc
	BSF 0x032,0
; 162: leftled = 0  'left led On
	BCF PORTA,3
; 163: rightled = 1  'right led off
	BSF PORTA,4
; 164: Call motordirection(1)  'select correct direction
	BSF 0x032,1
	CALL L0002
; 165: If stopleft = 0 Then  'arrival in left end station?
	BTFSC 0x005,0
	GOTO L0051
; 166: run = 0  'stop lok
	BCF 0x032,0
; 167: delay = delay_left  'set timeout
	MOVF 0x038,W
	MOVWF 0x033
; 168: route = 0  'next route step
	CLRF 0x027
; 169: Endif
L0051:
; 170: Case Else
	GOTO L0052
L0050:
; 171: EndSelect
L0052:
L0049:
L0044:
L0040:
L0035:
L0032:
L0027:
L0023:
; 172: If run = 0 Then  'controlling ramp up or ramp down speed
	BTFSC 0x032,0
	GOTO L0053
; 173: If speed > 30 Then
	MOVF 0x034,W
	SUBLW 0x1E
	BTFSC STATUS,C
	GOTO L0054
; 174: speed = speed - acc_time
	MOVF 0x039,W
	SUBWF 0x034,W
	MOVWF 0x034
; 175: Else
	GOTO L0055
L0054:
; 176: speed = 0
	CLRF 0x034
; 177: Endif
L0055:
; 178: Else
	GOTO L0056
L0053:
; 179: If speed < maxspeed_fw Then
	MOVF 0x035,W
	SUBWF 0x034,W
	BTFSC STATUS,C
	GOTO L0057
; 180: If speed < 30 Then
	MOVLW 0x1E
	SUBWF 0x034,W
	BTFSC STATUS,C
	GOTO L0058
; 181: speed = 30
	MOVLW 0x1E
	MOVWF 0x034
; 182: Else
	GOTO L0059
L0058:
; 183: speed = speed + acc_time
	MOVF 0x034,W
	ADDWF 0x039,W
	MOVWF 0x034
; 184: Endif
L0059:
; 185: Else
	GOTO L0060
L0057:
; 186: speed = maxspeed_fw
	MOVF 0x035,W
	MOVWF 0x034
; 187: Endif
L0060:
; 188: Endif
L0056:
; 189: PWMduty 1, speed
	MOVF 0x034,W
	MOVWF R0L
	BTFSC R0L,0
	BSF CCP1CON,CCP1Y
	BTFSS R0L,0
	BCF CCP1CON,CCP1Y
	BTFSC R0L,1
	BSF CCP1CON,CCP1X
	BTFSS R0L,1
	BCF CCP1CON,CCP1X
	BCF STATUS,C
	RRF R0L,F
	BCF STATUS,C
	RRF R0L,W
	MOVWF CCPR1L
; 190: Gosub readkey
	CALL L0003
; 191: flasher = flasher + 1
	INCF 0x03A,F
; 192: WaitMs 125
	MOVLW 0x22
	MOVWF R4L
	MOVLW 0xF4
	MOVWF R4H
	CALL DL02
; 193: Goto main
	GOTO L0001
; 194: 
; 195: End
L0061:	GOTO L0061
; 196: Proc motordirection(direction As Bit)
L0002:
; 197: RB1 = direction
	BTFSS 0x032,1
	BCF PORTB,1
	BTFSC 0x032,1
	BSF PORTB,1
; 198: RB0 = Not direction
	BTFSS 0x032,1
	BSF 0x006,0
	BTFSC 0x032,1
	BCF 0x006,0
; 199: End Proc
	RETURN
; 200: readkey:
L0003:
; 201: While shiftkey = 0  'changing waittimes
L0062:
	BTFSC 0x006,7
	GOTO L0063
; 202: rightled = 1
	BSF PORTA,4
; 203: leftled = 1
	BSF PORTA,3
; 204: If pluskey = 0 Then
	BTFSC 0x006,6
	GOTO L0064
; 205: Select Case route
; 206: Case 4
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0065
; 207: If delay_right < maxdelay Then  'maximum = 250 x 0.1 sec
	MOVLW 0x32
	SUBWF 0x036,W
	BTFSC STATUS,C
	GOTO L0066
; 208: delay_right = delay_right + 10  '1 second more
	MOVF 0x036,W
	ADDLW 0x0A
	MOVWF 0x036
; 209: Call indicate_delay(delay_right, 2)
	MOVF 0x036,W
	MOVWF 0x03B
	MOVLW 0x02
	MOVWF 0x03C
	CALL L0005
; 210: Write 1, delay_right
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x036,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0067:	BTFSC EECON1,WR
	GOTO L0067
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 211: Endif
L0066:
; 212: Case 2, 6
	GOTO L0068
L0065:
	MOVF 0x027,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0071
	GOTO L0070
L0071:
	MOVF 0x027,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0069
L0070:
; 213: If delay_mid < maxdelay Then  'maximum = 250 x 0.1 sec
	MOVLW 0x32
	SUBWF 0x037,W
	BTFSC STATUS,C
	GOTO L0072
; 214: delay_mid = delay_mid + 10  '1 second more
	MOVF 0x037,W
	ADDLW 0x0A
	MOVWF 0x037
; 215: Call indicate_delay(delay_mid, 1)
	MOVF 0x037,W
	MOVWF 0x03B
	MOVLW 0x01
	MOVWF 0x03C
	CALL L0005
; 216: Write 2, delay_mid
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x037,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0073:	BTFSC EECON1,WR
	GOTO L0073
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 217: Endif
L0072:
; 218: Case 0
	GOTO L0074
L0069:
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0075
; 219: If delay_left < maxdelay Then  'maximum = 250 x 0.1 sec
	MOVLW 0x32
	SUBWF 0x038,W
	BTFSC STATUS,C
	GOTO L0076
; 220: delay_left = delay_left + 10  '1 second more
	MOVF 0x038,W
	ADDLW 0x0A
	MOVWF 0x038
; 221: Call indicate_delay(delay_left, 1)
	MOVF 0x038,W
	MOVWF 0x03B
	MOVLW 0x01
	MOVWF 0x03C
	CALL L0005
; 222: Write 3, delay_left
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x038,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0077:	BTFSC EECON1,WR
	GOTO L0077
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 223: Endif
L0076:
; 224: Case Else
	GOTO L0078
L0075:
; 225: EndSelect
L0078:
L0074:
L0068:
; 226: While pluskey = 0
L0079:
	BTFSC 0x006,6
	GOTO L0080
; 227: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 228: Wend
	GOTO L0079
L0080:
; 229: Endif
L0064:
; 230: If minuskey = 0 Then
	BTFSC 0x006,5
	GOTO L0081
; 231: Select Case route
; 232: Case 4
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0082
; 233: If delay_right > 19 Then  'minimum = 10 x 0.1 sec
	MOVF 0x036,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0083
; 234: delay_right = delay_right - 10  '1 second less
	MOVLW 0x0A
	SUBWF 0x036,W
	MOVWF 0x036
; 235: Call indicate_delay(delay_right, 2)
	MOVF 0x036,W
	MOVWF 0x03B
	MOVLW 0x02
	MOVWF 0x03C
	CALL L0005
; 236: Endif
L0083:
; 237: Case 2, 6
	GOTO L0084
L0082:
	MOVF 0x027,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0087
	GOTO L0086
L0087:
	MOVF 0x027,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0085
L0086:
; 238: If delay_mid > 19 Then  'minimum = 10 x 0.1 sec
	MOVF 0x037,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0088
; 239: delay_mid = delay_mid - 10  '1 second less
	MOVLW 0x0A
	SUBWF 0x037,W
	MOVWF 0x037
; 240: Call indicate_delay(delay_mid, 1)
	MOVF 0x037,W
	MOVWF 0x03B
	MOVLW 0x01
	MOVWF 0x03C
	CALL L0005
; 241: Endif
L0088:
; 242: Case 0
	GOTO L0089
L0085:
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0090
; 243: If delay_left > 19 Then  'minimum = 10 x 0.1 sec
	MOVF 0x038,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0091
; 244: delay_left = delay_left - 10  '1 second less
	MOVLW 0x0A
	SUBWF 0x038,W
	MOVWF 0x038
; 245: Call indicate_delay(delay_left, 1)
	MOVF 0x038,W
	MOVWF 0x03B
	MOVLW 0x01
	MOVWF 0x03C
	CALL L0005
; 246: Endif
L0091:
; 247: Case Else
	GOTO L0092
L0090:
; 248: EndSelect
L0092:
L0089:
L0084:
; 249: While minuskey = 0
L0093:
	BTFSC 0x006,5
	GOTO L0094
; 250: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 251: Wend
	GOTO L0093
L0094:
; 252: Endif
L0081:
; 253: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 254: Wend
	GOTO L0062
L0063:
; 255: 'just speed change
; 256: If pluskey = 0 Then
	BTFSC 0x006,6
	GOTO L0095
; 257: If maxspeed_fw < 254 Then
	MOVLW 0xFE
	SUBWF 0x035,W
	BTFSC STATUS,C
	GOTO L0096
; 258: maxspeed_fw = maxspeed_fw + 2
	MOVF 0x035,W
	ADDLW 0x02
	MOVWF 0x035
; 259: Write 0, maxspeed_fw
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x035,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0097:	BTFSC EECON1,WR
	GOTO L0097
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 260: Endif
L0096:
; 261: Call calc_acc()
	CALL L0004
; 262: While pluskey = 0
L0098:
	BTFSC 0x006,6
	GOTO L0099
; 263: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 264: Wend
	GOTO L0098
L0099:
; 265: Endif
L0095:
; 266: If minuskey = 0 Then
	BTFSC 0x006,5
	GOTO L0100
; 267: If maxspeed_fw > 61 Then
	MOVF 0x035,W
	SUBLW 0x3D
	BTFSC STATUS,C
	GOTO L0101
; 268: maxspeed_fw = maxspeed_fw - 2
	MOVLW 0x02
	SUBWF 0x035,W
	MOVWF 0x035
; 269: Write 0, maxspeed_fw
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x035,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0102:	BTFSC EECON1,WR
	GOTO L0102
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 270: Endif
L0101:
; 271: Call calc_acc()
	CALL L0004
; 272: While minuskey = 0
L0103:
	BTFSC 0x006,5
	GOTO L0104
; 273: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 274: Wend
	GOTO L0103
L0104:
; 275: Endif
L0100:
; 276: Return
	RETURN
; 277: 
; 278: Proc calc_acc()
L0004:
; 279: acc_time = maxspeed_fw - 30
	MOVLW 0x1E
	SUBWF 0x035,W
	MOVWF 0x039
; 280: acc_time = acc_time / 30  '3 secs acc / dec
	MOVF 0x039,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x1E
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x039
; 281: If acc_time < 1 Then
	MOVLW 0x01
	SUBWF 0x039,W
	BTFSC STATUS,C
	GOTO L0105
; 282: acc_time = 1
	MOVLW 0x01
	MOVWF 0x039
; 283: Endif
L0105:
; 284: If acc_time > 240 Then
	MOVF 0x039,W
	SUBLW 0xF0
	BTFSC STATUS,C
	GOTO L0106
; 285: acc_time = 1
	MOVLW 0x01
	MOVWF 0x039
; 286: Endif
L0106:
; 287: End Proc
	RETURN
; 288: 
; 289: Proc indicate_delay(time As Byte, which As Byte)
L0005:
; 290: 'led left , right or both will flash the amount of seconds as set.
; 291: For flasher = 0 To time Step 10
	CLRF 0x03A
L0107:
	MOVF 0x03A,W
	SUBWF 0x03B,W
	BTFSS STATUS,C
	GOTO L0108
; 292: leftled = 1
	BSF PORTA,3
; 293: rightled = 1
	BSF PORTA,4
; 294: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 295: Select Case which
; 296: Case 0  'left hand flash
	MOVF 0x03C,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0109
; 297: leftled = 0
	BCF PORTA,3
; 298: Case 1  'middle position
	GOTO L0110
L0109:
	MOVF 0x03C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0111
; 299: leftled = 0
	BCF PORTA,3
; 300: rightled = 0
	BCF PORTA,4
; 301: Case Else  'right hand position
	GOTO L0112
L0111:
; 302: rightled = 0
	BCF PORTA,4
; 303: EndSelect
L0112:
L0110:
; 304: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 305: Next flasher
	MOVLW 0x0A
	ADDWF 0x03A,F
	BTFSS STATUS,C
	GOTO L0107
L0108:
; 306: End Proc
	RETURN
; 307: 
; End of user code
L0113:	GOTO L0113
;
;
; Delay Routine Byte
; minimal routine execution time: 2s
; routine execution time step: 1s
; maximal routine execution time: 256s
DL01:
	NOP
	NOP
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 3s
; routine execution time step: 2s
; maximal routine execution time: 131073s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0xF1
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
