; Compiled with: OshonSoft PIC Basic Compiler v8.21
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R4HL EQU 0x028
;       The address of 'activation_time' (word) (global) is 0x024
;       The address of 'dummy' (byte) (global) is 0x022
;       The address of 'switch' (byte) (global) is 0x023
;       The address of 'ap_1' (bit) (global) is 0x026,4
;       The address of 'ap_2' (bit) (global) is 0x026,5
;       The address of 'ap_3' (bit) (global) is 0x026,6
;       The address of 'ap_4' (bit) (global) is 0x026,7
;       The address of 'ci1' (bit) (global) is 0x026,0
;       The address of 'ci2' (bit) (global) is 0x026,1
;       The address of 'ci3' (bit) (global) is 0x026,2
;       The address of 'ci4' (bit) (global) is 0x026,3
;       The address of 'fb1' (bit) (global) is 0x005,4
;       The address of 'fb2' (bit) (global) is 0x005,3
;       The address of 'fb3' (bit) (global) is 0x005,6
;       The address of 'fb4' (bit) (global) is 0x005,7
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0005
	ORG 0x0004
	RETFIE
; LookUp Table: (%11000110, %11000110, %11000101, %11001010, %11001001, %11010010, %11010001, %11100010, %11100001)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC6
	RETLW 0xC6
	RETLW 0xC5
	RETLW 0xCA
	RETLW 0xC9
	RETLW 0xD2
	RETLW 0xD1
	RETLW 0xE2
	RETLW 0xE1
; User code start
L0005:
; 1: 'program for GCA79
; 2: 
; 3: #define CONFIG = 0x3f50
;       The value of 'CONFIG' is 16208
; 4: '#define SIMULATION_WAITMS_VALUE = 0
; 5: All_Digital
	MOVLW 0x07
	MOVWF CMCON
	BSF STATUS,RP0
	BCF VRCON,6
	BCF STATUS,RP0
; 6: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 7: TRISA = %00100111
	MOVLW 0x27
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 8: PORTA = %00100111
	MOVLW 0x27
	MOVWF PORTA
; 9: TRISB = %11000000
	MOVLW 0xC0
	BSF STATUS,RP0
	MOVWF TRISB
	BCF STATUS,RP0
; 10: PORTB = %11000000
	MOVLW 0xC0
	MOVWF PORTB
; 11: 
; 12: Dim activation_time As Word
; 13: Dim dummy As Byte
; 14: Dim switch As Byte
; 15: 'define actual positons (will be calculated at start from inputs)
; 16: Dim ap_1 As Bit
; 17: Dim ap_2 As Bit
; 18: Dim ap_3 As Bit
; 19: Dim ap_4 As Bit
; 20: 'define command inputs
; 21: Dim ci1 As Bit
; 22: Dim ci2 As Bit
; 23: Dim ci3 As Bit
; 24: Dim ci4 As Bit
; 25: 'define feed-back
; 26: Symbol fb1 = PORTA.4
; 27: Symbol fb2 = PORTA.3
; 28: Symbol fb3 = PORTA.6
; 29: Symbol fb4 = PORTA.7
; 30: 
; 31: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 32: Call get_positions()
	CALL L0003
; 33: Main:
L0001:
; 34: 'switch 1
; 35: ci1 = PORTA.0
	BCF 0x026,0
	BTFSC PORTA,0
	BSF 0x026,0
; 36: If ci1 <> ap_1 Then
	CLRW
	BTFSC 0x026,0
	ADDLW 0x01
	BTFSC 0x026,4
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0006
; 37: If ci1 = 1 Then  '*     switch straight
	BTFSS 0x026,0
	GOTO L0007
; 38: switch = 1
	MOVLW 0x01
	MOVWF 0x023
; 39: Else  '*               switch round
	GOTO L0008
L0007:
; 40: switch = 2
	MOVLW 0x02
	MOVWF 0x023
; 41: Endif
L0008:
; 42: Call position()
	CALL L0002
; 43: ap_1 = ci1
	BCF 0x026,4
	BTFSC 0x026,0
	BSF 0x026,4
; 44: fb1 = ci1
	BTFSS 0x026,0
	BCF PORTA,4
	BTFSC 0x026,0
	BSF PORTA,4
; 45: Endif
L0006:
; 46: 'switch 2
; 47: ci2 = PORTA.1
	BCF 0x026,1
	BTFSC PORTA,1
	BSF 0x026,1
; 48: If ci2 <> ap_2 Then
	CLRW
	BTFSC 0x026,1
	ADDLW 0x01
	BTFSC 0x026,5
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0009
; 49: If ci2 = 1 Then  '*     switch straight
	BTFSS 0x026,1
	GOTO L0010
; 50: switch = 3
	MOVLW 0x03
	MOVWF 0x023
; 51: Else  '*               switch round
	GOTO L0011
L0010:
; 52: switch = 4
	MOVLW 0x04
	MOVWF 0x023
; 53: Endif
L0011:
; 54: Call position()
	CALL L0002
; 55: ap_2 = ci2
	BCF 0x026,5
	BTFSC 0x026,1
	BSF 0x026,5
; 56: fb2 = ci2
	BTFSS 0x026,1
	BCF PORTA,3
	BTFSC 0x026,1
	BSF PORTA,3
; 57: Endif
L0009:
; 58: 'switch 3
; 59: ci3 = PORTA.2
	BCF 0x026,2
	BTFSC PORTA,2
	BSF 0x026,2
; 60: If ci3 <> ap_3 Then
	CLRW
	BTFSC 0x026,2
	ADDLW 0x01
	BTFSC 0x026,6
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0012
; 61: If ci3 = 1 Then  '*     switch straight
	BTFSS 0x026,2
	GOTO L0013
; 62: switch = 5
	MOVLW 0x05
	MOVWF 0x023
; 63: Else  '*               switch round
	GOTO L0014
L0013:
; 64: switch = 6
	MOVLW 0x06
	MOVWF 0x023
; 65: Endif
L0014:
; 66: Call position()
	CALL L0002
; 67: ap_3 = ci3
	BCF 0x026,6
	BTFSC 0x026,2
	BSF 0x026,6
; 68: fb3 = ci3
	BTFSS 0x026,2
	BCF PORTA,6
	BTFSC 0x026,2
	BSF PORTA,6
; 69: Endif
L0012:
; 70: 'switch 4
; 71: ci4 = PORTA.5
	BCF 0x026,3
	BTFSC PORTA,5
	BSF 0x026,3
; 72: If ci4 <> ap_4 Then
	CLRW
	BTFSC 0x026,3
	ADDLW 0x01
	BTFSC 0x026,7
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0015
; 73: If ci4 = 1 Then  '*     switch straight
	BTFSS 0x026,3
	GOTO L0016
; 74: switch = 7
	MOVLW 0x07
	MOVWF 0x023
; 75: Else  '*               switch round
	GOTO L0017
L0016:
; 76: switch = 8
	MOVLW 0x08
	MOVWF 0x023
; 77: Endif
L0017:
; 78: Call position()
	CALL L0002
; 79: ap_4 = ci4
	BCF 0x026,7
	BTFSC 0x026,3
	BSF 0x026,7
; 80: fb4 = ci4
	BTFSS 0x026,3
	BCF PORTA,7
	BTFSC 0x026,3
	BSF PORTA,7
; 81: Endif
L0015:
; 82: 
; 83: Goto Main
	GOTO L0001
; 84: 
; 85: End
L0018:	GOTO L0018
; 86: 
; 87: Proc position()
L0002:
; 88: 'get dip switch settings
; 89: dummy = 0
	CLRF 0x022
; 90: dummy.0 = PORTB.7
	BCF 0x022,0
	BTFSC PORTB,7
	BSF 0x022,0
; 91: dummy.1 = PORTB.6
	BCF 0x022,1
	BTFSC PORTB,6
	BSF 0x022,1
; 92: Select Case dummy
; 93: Case 3
	MOVF 0x022,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0019
; 94: activation_time = 100
	MOVLW 0x64
	MOVWF 0x024
	CLRF 0x025
; 95: Case 2
	GOTO L0020
L0019:
	MOVF 0x022,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0021
; 96: activation_time = 250
	MOVLW 0xFA
	MOVWF 0x024
	CLRF 0x025
; 97: Case 1
	GOTO L0022
L0021:
	MOVF 0x022,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0023
; 98: activation_time = 500
	MOVLW 0xF4
	MOVWF 0x024
	MOVLW 0x01
	MOVWF 0x025
; 99: Case Else
	GOTO L0024
L0023:
; 100: activation_time = 2000
	MOVLW 0xD0
	MOVWF 0x024
	MOVLW 0x07
	MOVWF 0x025
; 101: EndSelect
L0024:
L0022:
L0020:
; 102: 
; 103: PORTB = LookUp(%11000110, %11000110, %11000101, %11001010, %11001001, %11010010, %11010001, %11100010, %11100001), switch
	MOVF 0x023,W
	MOVWF R0L
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0025
	CALL _lookup_lab_0001
	MOVWF PORTB
L0025:
; 104: WaitMs activation_time
	MOVF 0x024,W
	MOVWF R0L
	MOVF 0x025,W
	MOVWF R0H
	CALL W001
; 105: PORTB = %11000011
	MOVLW 0xC3
	MOVWF PORTB
; 106: End Proc
	RETURN
; 107: 
; 108: Proc get_positions()
L0003:
; 109: ap_1 = PORTA.0
	BCF 0x026,4
	BTFSC PORTA,0
	BSF 0x026,4
; 110: fb1 = ap_1
	BTFSS 0x026,4
	BCF PORTA,4
	BTFSC 0x026,4
	BSF PORTA,4
; 111: ap_2 = PORTA.1
	BCF 0x026,5
	BTFSC PORTA,1
	BSF 0x026,5
; 112: fb2 = ap_2
	BTFSS 0x026,5
	BCF PORTA,3
	BTFSC 0x026,5
	BSF PORTA,3
; 113: ap_3 = PORTA.2
	BCF 0x026,6
	BTFSC PORTA,2
	BSF 0x026,6
; 114: fb3 = ap_3
	BTFSS 0x026,6
	BCF PORTA,6
	BTFSC 0x026,6
	BSF PORTA,6
; 115: ap_4 = PORTA.5
	BCF 0x026,7
	BTFSC PORTA,5
	BSF 0x026,7
; 116: fb4 = ap_4
	BTFSS 0x026,7
	BCF PORTA,7
	BTFSC 0x026,7
	BSF PORTA,7
; 117: End Proc
	RETURN
; 118: 
; 119: 
; Library code
L0004:
	RETURN
; End of user code
L0026:	GOTO L0026
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
