; Compiled with: PIC Simulator IDE v7.51
; Microcontroller model: PIC12F675
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R4HL EQU 0x028
;       The address of 'u1ab' (bit) (global) is 0x005,2
;       The address of 'u3ab' (bit) (global) is 0x005,3
;       The address of 'leds' (bit) (global) is 0x005,1
;       The address of 'turnout' (bit) (global) is 0x005,0
;       The address of 'relay_left' (bit) (global) is 0x005,4
;       The address of 'relay_right' (bit) (global) is 0x005,5
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	RETFIE
; User code start
L0002:
; 1: 
; 2: 
; 3: 'program for Reverse loop controller GCA102
; 4: 
; 5: Define CONF_WORD = 0x31c4
; 6: 
; 7: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON
; 8: TRISIO = %001100
	MOVLW 0x0C
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 9: GPIO = %111111
	MOVLW 0x3F
	MOVWF GPIO
; 10: Symbol u1ab = GP2
; 11: Symbol u3ab = GP3
; 12: Symbol leds = GP1
; 13: Symbol turnout = GP0
; 14: Symbol relay_left = GP4
; 15: Symbol relay_right = GP5
; 16: relay_left = 0
	BCF GPIO,4
; 17: WaitMs 500
	MOVLW 0x4E
	MOVWF R4L
	MOVLW 0xC3
	MOVWF R4H
	CALL DL02
; 18: relay_left = 1
	BSF GPIO,4
; 19: leds = 0
	BCF GPIO,1
; 20: main:
L0001:
; 21: While u3ab = 1  'pulse control direct from J2 pin 4
L0003:
	BTFSS 0x005,3
	GOTO L0004
; 22: relay_left = 0
	BCF GPIO,4
; 23: leds = 0
	BCF GPIO,1
; 24: turnout = 0
	BCF GPIO,0
; 25: Wend
	GOTO L0003
L0004:
; 26: While u1ab = 1  'pulse control direct from J2 pin 3
L0005:
	BTFSS 0x005,2
	GOTO L0006
; 27: relay_right = 0
	BCF GPIO,5
; 28: leds = 1
	BSF GPIO,1
; 29: turnout = 1
	BSF GPIO,0
; 30: Wend
	GOTO L0005
L0006:
; 31: relay_left = 1
	BSF GPIO,4
; 32: relay_right = 1
	BSF GPIO,5
; 33: Goto main
	GOTO L0001
; End of user code
L0007:	GOTO L0007
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
