/*

*/

#include <Adafruit_GFX.h>    // Core graphics library
#include <Adafruit_ST7735.h> // Hardware-specific library
//#include<Fonts/FreeMono9pt7b.h>
#include <SPI.h>


// For the breakout, you can use any 2 or 3 pins
// These pins will also work for the 1.8" TFT shield
#define TFT_CS     10
#define TFT_RST    9  // you can also connect this to the Arduino reset
                      // in which case, set this #define pin to 0!
#define TFT_DC     8

// Option 1 (recommended): must use the hardware SPI pins
// (for UNO thats sclk = 13 and sid = 11) and pin 10 must be
// an output. This is much faster - also required if you want
// to use the microSD card (see the image drawing example)
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS,  TFT_DC, TFT_RST);

// Option 2: use any pins but a little slower!
#define TFT_SCLK 13   // set these to be whatever pins you like!
#define TFT_MOSI 11   // set these to be whatever pins you like!

/* const unsigned char myBitmap [] PROGMEM = {
0xf0, 0xf0, 0xf0, 0xf0, 
0xf0, 0xf0, 0xf0, 0xf0, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff,
};
*/

const unsigned char myBitmap [] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfe, 0x03, 0x80, 
0x03, 0xff, 0x01, 0xc0, 0x07, 0xff, 0x80, 0xe0, 0x0e, 0x01, 0xc0, 0x70, 0x1c, 0x00, 0xe0, 0x38, 
0x3f, 0xfc, 0x7f, 0xfe, 0x7f, 0xfe, 0x3f, 0xfe, 0x3c, 0x0f, 0x00, 0x3c, 0x0e, 0x03, 0x80, 0x78, 
0x07, 0x01, 0xff, 0xf0, 0x03, 0x80, 0xff, 0xc0, 0x01, 0xc0, 0x7f, 0x80, 0x00, 0x00, 0x00, 0x00, 

};


String inputString = "";         // a string to hold incoming data
String firsttxt="";
String secondtxt="";
String thirdtxt="";
String fourthtxt="";
String fifthtxt="";
String sixtxt="";



boolean stringComplete = false;  // whether the string is complete
  
void setup(void) {
 Serial.begin(9600);
 Serial.print("Hello! Adafruit ST7735  test");
 Serial.println("  init");
 tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab
 tft.setTextWrap(false); // Allow text to run off right edge
 Serial.println("invoer: vertrek perron,vertrek tijd,soort trein,bestemming,sub bestemming");
    tft.setRotation(1);
    tft.fillScreen(ST7735_BLACK);
    tft.fillRoundRect(0, 0 , 160, 110,2, ST7735_BLUE); 
    tft.fillRoundRect(32,88,122,12,2,ST7735_DARKBLUE);
    tft.fillRoundRect(32, 12 , 122, 78, 2,ST7735_WHITE);
    tft.fillRect(4, 12 , 20, 20, ST7735_WHITE);
    tft.fillRect(4,12,4,4, ST7735_BLUE);// x1,y1  b,h
    tft.drawLine(28,0, 28,128, ST7735_BLACK);
    tft.drawLine(27,0, 27,128, ST7735_BLACK);
    tft.drawRect(32, 12, 122, 88, ST7735_BLACK);   

    tft.drawBitmap(120, 15, myBitmap, 32, 16, ST7735_BLUE);
}

void loop(void) {
   while (!Serial.available());
}


void serialEvent() {
  while (Serial.available()) {
    char inChar = (char)Serial.read();
    inputString += inChar;
    if (inChar == '\n') {
      stringComplete = true;
      if (inputString.length() > 10){
        int commaIndex = inputString.indexOf(',');
        int secondCommaIndex = inputString.indexOf(',', commaIndex+1);
        int thirdCommaIndex = inputString.indexOf(',', secondCommaIndex+1);
        int fourthCommaIndex = inputString.indexOf(',', thirdCommaIndex+1);
        int fifthCommaIndex = inputString.indexOf(',', fourthCommaIndex+1);
          
       String firstValue = inputString.substring(0, commaIndex);
       String secondValue = inputString.substring(commaIndex+1, secondCommaIndex);
       String thirdValue = inputString.substring(secondCommaIndex+1, thirdCommaIndex); 
       String fourthValue = inputString.substring(thirdCommaIndex+1, fourthCommaIndex);
       String fifthValue = inputString.substring(fourthCommaIndex+1); 
         
       firsttxt=firstValue;
       secondtxt=secondValue;
       thirdtxt=thirdValue;
       fourthtxt=fourthValue;
       fifthtxt=fifthValue;

      tft.fillRoundRect(32, 12 , 122, 78, 2,ST7735_WHITE);
      tft.fillRoundRect(4, 12 , 20, 20, 2,ST7735_WHITE);
      tft.fillRect(4,12,4,4, ST7735_BLUE);// x1,y1  b,h

      tft.setTextColor(ST7735_BLUE);
      tft.setTextSize(1); 
      tft.setCursor(35, 20);tft.print(secondtxt); 
      tft.setCursor(90, 20);tft.print(thirdtxt);
      tft.setTextSize(2);
      tft.setCursor(10, 15);tft.print(firsttxt); 
      tft.setCursor(40, 35);tft.print(fourthtxt); 
      tft.setCursor(40, 60);tft.print(fifthtxt);     
}
else{
   tft.fillRect(123,91,29,9, ST7735_DARKBLUE);// x1,y1  b,h
    sixtxt=inputString;
    tft.setTextSize(1);
   

    tft.setTextColor(ST7735_WHITE);   
    tft.setCursor(123, 92);tft.print(sixtxt); 
 
    tft.setTextColor(ST7735_BLUE); 
  
  }
 }
}

  if (stringComplete) {
    Serial.println(inputString);      
    inputString = "";
    stringComplete = false;
  }
}
